/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Action in clicking 'Launch nformation Banner' button
void on_launch(GtkWidget *button, gpointer window)
{
	gtk_widget_set_sensitive(GTK_WIDGET(Bclose), FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(Bdisable), TRUE);
	const gchar *str;
	str=gtk_button_get_label (GTK_BUTTON(Blaunch));
	if(strcmp(str, "Launch Information Banner") == 0)
	{
		gtk_infoprint(window, "Info-print text here!");
		gtk_button_set_label(GTK_BUTTON(Blaunch), "Set printf format string");
	}
	else
	{
		gtk_infoprintf(window, "there are %d days in a week", 7);
		gtk_button_set_label(GTK_BUTTON(Blaunch), "Launch Information Banner");
	}
}

//Action on clicking 'Launch Information Banner with iconstock' button
void on_launch3(GtkWidget *button, gpointer data)
{
	 const gchar *str;
	 str=gtk_button_get_label (GTK_BUTTON(Blaunch3));
	 if(strcmp(str, "Launch Information Banner with iconstock") == 0)
	 {
		 gtk_widget_set_sensitive(GTK_WIDGET(Bclose), FALSE);
		 gtk_widget_set_sensitive(GTK_WIDGET(Bdisable), TRUE);
		 gtk_infoprint_with_icon_stock(GTK_WINDOW(window), "I have chosen\nto print!", GTK_STOCK_PRINT);
		 gtk_button_set_label(GTK_BUTTON(Blaunch3), "Infoprint with long text");
	 }
	 else
	 {
		 gtk_widget_set_sensitive(GTK_WIDGET(Bclose), FALSE);
                 gtk_widget_set_sensitive(GTK_WIDGET(Bdisable), TRUE);
		 gtk_infoprint_with_icon_stock(GTK_WINDOW(window),"This is an extremely long text which has expanded the banner's width to maximum and wrapped the string into two full lines. Hence truncating the string", GTK_STOCK_CUT);
		 gtk_button_set_label(GTK_BUTTON(Blaunch3), "Launch Information Banner with iconstock");
	 }
}
			 
//ACtion on clicking 'Launch Confirmation Banner' button
void on_launch2(GtkWidget *button, gpointer window)
{
	const gchar *str;
	str=gtk_button_get_label (GTK_BUTTON(Blaunch2));
	if(strcmp(str, "Launch Confirmation Banner") == 0)
	{
		gtk_widget_set_sensitive(GTK_WIDGET(Bclose), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(Bdisable), TRUE);
		gtk_confirmation_banner(GTK_WINDOW(window), "Delete file??", NULL);	
		gtk_button_set_label(GTK_BUTTON(Blaunch2), "With stockicon & 2 lines");
	}
	else
	{
		gtk_widget_set_sensitive(GTK_WIDGET(Bclose), FALSE);
                gtk_widget_set_sensitive(GTK_WIDGET(Bdisable), TRUE);
		gtk_confirmation_banner(GTK_WINDOW(window), "Do you want to\nDelete file??", GTK_STOCK_DIALOG_QUESTION);
		gtk_button_set_label(GTK_BUTTON(Blaunch2), "Launch Confirmation Banner");
	}
		
}


//Action on clicking "Launch Banner with Animation" button
void on_launch4(GtkWidget *button, gpointer data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(Bclose), TRUE);
	gtk_widget_set_sensitive(GTK_WIDGET(Bdisable), FALSE);
	const gchar *str;
	str=gtk_button_get_label(GTK_BUTTON(Blaunch4));
	if(strcmp(str, "Launch Banner with Animation") == 0 )
	{
			gtk_banner_show_animation(GTK_WINDOW(window), "Animated!");
			gtk_button_set_label(GTK_BUTTON(Blaunch4), "Show Progress Bar!");
	}
	else if(strcmp(str, "Show Progress Bar!") == 0 )
	{
		gtk_banner_show_bar(GTK_WINDOW(window), "Progress Bar animation!");
		gtk_banner_set_fraction(GTK_WINDOW(window), 0.65);
		gtk_banner_set_text(GTK_WINDOW(window), "This is a Progress Banner");
		gtk_button_set_label(GTK_BUTTON(Blaunch4), "Launch Banner with Animation");
		
	}
		
	
}

//Action on clicking 'Disable Banner' button
void on_disable(GtkWidget *button, gpointer data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(Bclose), FALSE);
	const gchar *str;
	str=gtk_button_get_label(GTK_BUTTON(Bdisable));
	if(strcmp(str, "Disable wrapping for banner") == 0)
	{
		gtk_banner_temporarily_disable_wrap();
		gtk_button_set_label(GTK_BUTTON(Bdisable), "Disable wrapping for infoprint");
	}
	else
	{
		gtk_infoprint_temporarily_disable_wrap();
		gtk_button_set_label(GTK_BUTTON(Bdisable), "Disable wrapping for banner");
	}
}

//Action on clicking 'Close Banner' button
void on_close(GtkWidget *button, gpointer data)
{
	gtk_banner_close(GTK_WINDOW(window));
}

//Action on clicking 'Exit' button
void on_exit(GtkWidget *button, gpointer data)
{
	gtk_widget_destroy(Blaunch);
	gtk_widget_destroy(Blaunch2);
	gtk_widget_destroy(Bexit);
	gtk_widget_destroy(window);
	gtk_main_quit();

}

