/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Creates the second window 
void create_second_window(void)
{
	s_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	s_vbox=gtk_vbox_new(FALSE,0);
	s_hbox1=gtk_hbox_new(FALSE,0);
	s_hbox2=gtk_hbox_new(FALSE,0);
	s_hbox3=gtk_hbox_new(FALSE,0);
	s_hbox4=gtk_hbox_new(FALSE,0);
	
	set_option=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_option)," Above Child ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_option)," Visible Window ");
	gtk_combo_box_set_active(GTK_COMBO_BOX(set_option),0);
	get_option=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_option)," Above Child ");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_option)," Visible Window ");
        gtk_combo_box_set_active(GTK_COMBO_BOX(get_option),0);

	set_button=gtk_button_new_with_label(" Set ");
	get_button=gtk_button_new_with_label(" Get ");
	get_text=gtk_label_new("RESULT: ");
	get_result=gtk_label_new("");
	back=gtk_button_new_with_label(" Back ");

	/*-----------------------------Signak Handlers----------------------------*/
	g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_call),NULL);
	g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_call),NULL);
	g_signal_connect(G_OBJECT(back),"clicked",G_CALLBACK(back_call),NULL);
	
	/*---------------------------Packing-------------------------------------*/
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox1,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox2,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox3,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox4,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox1),set_option,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox1),set_button,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox2),get_option,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox2),get_button,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox3),get_text,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox3),get_result,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox4),back,FALSE,FALSE,20);
	gtk_container_add(GTK_CONTAINER(s_window),s_vbox);
	
}

//Creates the main window
void create_main_window (void)
{
	GdkColor p;
	p.pixel=0;
	p.red=30000;
	p.green=0;
	p.blue=0;
	GdkColor *rp=&p;
	m_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	m_vbox=gtk_vbox_new(FALSE,0);
	m_hbox1=gtk_hbox_new(FALSE,0);
	m_hbox2=gtk_hbox_new(FALSE,0);
	m_hbox3=gtk_hbox_new(FALSE,0);
	
	e_vbox=gtk_vbox_new(FALSE,5);
	e_hbox=gtk_hbox_new(FALSE,10);	
	
	eventbox=gtk_event_box_new();
	gtk_widget_set_size_request (eventbox, 250, 70);
	
	test=gtk_button_new_with_label("test of event box");
	set_get=gtk_button_new_with_label("Set/Get Properties");
	capture=gtk_label_new("");
	gtk_container_add (GTK_CONTAINER(eventbox),e_vbox); 
	gtk_widget_show (test);
	quit_button=gtk_button_new_with_label(" Quit ");
	
	gtk_widget_modify_bg(m_window,GTK_STATE_NORMAL,rp);
	gtk_box_pack_start(GTK_BOX(e_vbox),e_hbox,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(e_hbox),test,FALSE,FALSE,0);
	create_second_window();

	/*-------------------Signal Handlers-----------------*/
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(m_window),"destroy",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(set_get),"clicked",G_CALLBACK(set_get_call),NULL);
	gtk_widget_set_events (eventbox, GDK_BUTTON_PRESS_MASK);
	g_signal_connect (G_OBJECT (eventbox), "button_press_event",
			                  G_CALLBACK(event_call), NULL);
	g_signal_connect(G_OBJECT(test),"clicked",G_CALLBACK(win_call),NULL);
	
	/*---------------------Packing-------------------------*/
	gtk_box_pack_start(GTK_BOX(m_vbox),m_hbox1,FALSE,FALSE,70);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox3,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox2,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox1),eventbox,FALSE,FALSE,50);
	gtk_box_pack_start(GTK_BOX(m_hbox2),set_get,FALSE,FALSE,50);
	gtk_box_pack_start(GTK_BOX(m_hbox2),capture,FALSE,FALSE,10);
	gtk_box_pack_end(GTK_BOX(m_hbox3),quit_button,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(m_window),m_vbox);

	gtk_widget_show_all(m_window);
}
