/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Action on capturing 'Button press' event by the event box
void event_call(GtkWidget *b,gpointer data)
{
	gtk_label_set_text(GTK_LABEL(capture),"EventBox captured signal");
}

//Action on clicking the 'test of event box' button
void win_call(GtkWidget *b,gpointer data)
{
	gtk_label_set_text(GTK_LABEL(capture),"Window captured signal");
		
}

//Action on Selection of an item from the 'Set' combo box 
void set_call(GtkButton *b,gpointer data)
{
	 gint val;
         val=gtk_combo_box_get_active(GTK_COMBO_BOX(set_option));
	 switch(val)
	 {
		 case 0:	gtk_event_box_set_above_child(GTK_EVENT_BOX(eventbox),TRUE);
				break;
		 case 1:	gtk_event_box_set_visible_window(GTK_EVENT_BOX(eventbox),FALSE);
				break;
	 }
	 gtk_widget_hide(s_window);
	 gtk_widget_show_all(m_window);
}

//Action on Selection of an item from the 'Get' combo box
void get_call(GtkButton *b,gpointer data)
{
	 gint val;
	 gboolean res;
         val=gtk_combo_box_get_active(GTK_COMBO_BOX(get_option));
	 switch(val)
	 {
		 case 0:	res=gtk_event_box_get_above_child(GTK_EVENT_BOX(eventbox));
				if(res==TRUE)
					gtk_label_set_text(GTK_LABEL(get_result),"TRUE");
				else
					gtk_label_set_text(GTK_LABEL(get_result),"FALSE");
				break;
		 case 1:	res=gtk_event_box_get_visible_window(GTK_EVENT_BOX(eventbox));
				if(res==TRUE)
					gtk_label_set_text(GTK_LABEL(get_result),"TRUE");
			        else
				        gtk_label_set_text(GTK_LABEL(get_result),"FALSE");
				break;
								
	 }
}

//Action on clicking 'Set/Get Properties' button in the main window
void set_get_call(GtkButton *b,gpointer data)
{
	gtk_widget_hide(m_window);
	gtk_widget_show_all(s_window);
}

//Action on clicking 'Back' button in the second window
void back_call(GtkButton *b,gpointer data)
{
	gtk_widget_hide(s_window);
	gtk_widget_show_all(m_window);
}
