/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*-------------The window where we can choose the properties for the widget-------------*/
void create_second_window(void)
{
	s_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	s_vbox=gtk_vbox_new(FALSE,0);
	s_hbox1=gtk_hbox_new(FALSE,0);
	s_hbox2=gtk_hbox_new(FALSE,0);
	s_hbox3=gtk_hbox_new(FALSE,0);

	set_options=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Visibility FALSE ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Invisible char to None ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Invisible char to % ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Visibility TRUE ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Entry Text ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Activate default ");	
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," No Frame ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Has Frame ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Width=8 chars ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Right Align ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Left Align ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Max length=5 ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Entry Completion ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_options)," Insensitive state ");
	gtk_combo_box_set_active(GTK_COMBO_BOX(set_options),0);
	set_button=gtk_button_new_with_label(" Set ");

	get_options=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Visibility ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Invisible char ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Entry text ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Activate default ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Has frame ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Width of entry ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Alignment ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Max length ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Layout Offsets ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_options)," Layout ");
	gtk_combo_box_set_active(GTK_COMBO_BOX(get_options),0);
	get_button=gtk_button_new_with_label(" Get ");

	result=gtk_label_new("");
	resultl=gtk_label_new("");
	back=gtk_button_new_with_label(" Back ");

	/*--------------------Signal Handlers---------------------*/
	g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_call),NULL);
	g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_call),NULL);
	g_signal_connect(G_OBJECT(back),"clicked",G_CALLBACK(back_call),NULL);
	
	/*----------------------Packing----------------------------*/	
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox1,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox2,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(s_vbox),s_hbox3,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(s_hbox1),set_options,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(s_hbox1),set_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(s_hbox2),get_options,FALSE,FALSE,10);
        gtk_box_pack_start(GTK_BOX(s_hbox2),get_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(s_hbox2),GTK_WIDGET(result),TRUE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(s_hbox2),GTK_WIDGET(resultl),TRUE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(s_hbox3),back,TRUE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(s_window),s_vbox);
	
}


/*-------------------Creates the main display window-----------*/
void create_main_window (void)
{
	m_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	m_vbox=gtk_vbox_new(FALSE,0);	
	m_hbox1=gtk_hbox_new(FALSE,0);
	m_hbox2=gtk_hbox_new(FALSE,0);
	m_hbox3=gtk_hbox_new(FALSE,0);

	entry=gtk_entry_new();
	property=gtk_button_new_with_label(" Set/Get Properties ");
	quit_button=gtk_button_new_with_label(" Quit ");

	create_second_window();

	completion=gtk_entry_completion_new();

	/*-------------------Signal Handlers-----------------*/
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(property),"clicked",G_CALLBACK(property_call),NULL);
	g_signal_connect(G_OBJECT(m_window),"destroy",gtk_main_quit,NULL);
	
	/*---------------------PACKING-------------------------*/
	gtk_box_pack_start(GTK_BOX(m_vbox),m_hbox1,TRUE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox2,TRUE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox1),entry,TRUE,0,0);
	gtk_box_pack_end(GTK_BOX(m_hbox2),quit_button,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(m_hbox2),property,TRUE,TRUE,0);
	gtk_container_add(GTK_CONTAINER(m_window),m_vbox);

	gtk_widget_show_all(m_window);
	g_signal_connect(G_OBJECT(entry),"insensitive_press",dim_call,NULL);
}
