/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*-------------------For building the entry completin model-----------------*/
GtkTreeModel *
create_simple_completion_model (void)
{
	GtkListStore *store;
        GtkTreeIter iter;
	
	store = gtk_list_store_new (1, G_TYPE_STRING);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "gnome", -1);
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "gnominious", -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "gigantic", -1);
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "gtkEntry",-1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "total", -1);
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "totally", -1);
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "toto", -1);
	gtk_list_store_append (store, &iter);
        gtk_list_store_set (store, &iter, 0, "totterer", -1);
        gtk_list_store_append (store, &iter);
        gtk_list_store_set (store, &iter, 0, "totipotency", -1);
        gtk_list_store_append (store, &iter);
        gtk_list_store_set (store, &iter, 0, "totalizer", -1);
        gtk_list_store_append (store, &iter);
        gtk_list_store_set (store, &iter, 0, "totalitarianism", -1);
    
	return GTK_TREE_MODEL (store);

}

/*-----------------Matching the entries---------------*/
static gboolean
match_func (GtkEntryCompletion *completion,
		            const gchar        *key,
				GtkTreeIter        *iter,
				gpointer            user_data)
{
	gchar *item = NULL;
	GtkTreeModel *model;
	                                                                                                                                 
	gboolean ret = FALSE;
	                                                                                                                                   
	model = gtk_entry_completion_get_model (completion);
		                                                                                                                             
	gtk_tree_model_get (model, iter, 0, &item, -1);
	                                                                                                                              
	if (item != NULL)
	{
	  g_print ("compare %s %s\n", key, item);
	  if (strncmp (key, item, strlen (key)) == 0)
	  ret = TRUE;
	  g_free (item);
	}
	                                                                                                                                 
	return ret;
}

/*-----------When set/get properties button of main window is clicked--------------*/
void property_call(GtkButton *b,gpointer data)
{
	gtk_widget_hide(m_window);
	gtk_widget_show_all(s_window);
}

/*----------When a property is chosen and SET button is clicked-------------------*/
void set_call(GtkButton *b,gpointer data)
{
	gint val;
	GtkEntryCompletion *g;

	val=gtk_combo_box_get_active(GTK_COMBO_BOX(set_options));
	switch(val)
	{
		case 0: gtk_entry_set_visibility(GTK_ENTRY(entry),FALSE);
			break;
		case 1: gtk_entry_set_invisible_char(GTK_ENTRY(entry),0);
			break;
		case 2: gtk_entry_set_invisible_char(GTK_ENTRY(entry),'%');
			break;
		case 3: gtk_entry_set_visibility(GTK_ENTRY(entry),TRUE);
			break;
		case 4: gtk_entry_set_text(GTK_ENTRY(entry),"HELLO");
			break;
		case 5: gtk_entry_set_activates_default(GTK_ENTRY(entry),TRUE);
			break;
		case 6: gtk_entry_set_has_frame(GTK_ENTRY(entry),FALSE);
			break;
		case 7: gtk_entry_set_has_frame(GTK_ENTRY(entry),TRUE);
                        break;
		case 8: gtk_entry_set_width_chars(GTK_ENTRY(entry),8);
			break;
		case 9: gtk_entry_set_alignment(GTK_ENTRY(entry),1);
			break;
		case 10:gtk_entry_set_alignment(GTK_ENTRY(entry),0);
			break;
		case 11:gtk_entry_set_max_length(GTK_ENTRY(entry),5);
			break;
		case 12:gtk_entry_set_completion(GTK_ENTRY(entry),completion);

			g_object_unref (completion);
			                                                                                                                             
		        completion_model = create_simple_completion_model ();
		        gtk_entry_completion_set_model (completion, completion_model);
		        g_object_unref (completion_model);
		        
			gtk_entry_completion_set_text_column (completion, 0);
			gtk_entry_completion_set_match_func (completion, match_func, NULL, NULL);

			break;
		case 13:gtk_widget_set_sensitive(entry,FALSE);
			break;
											
	}
	gtk_widget_hide(s_window);
	gtk_widget_show_all(m_window);
}

/*----------When Property is chosen and GET button is clicked-------------*/
void get_call(GtkButton *b,gpointer data)
{
	gboolean num;
	gint x,y;
	gint no;
	gint val;
	gchar *str;
	gchar ch;
	gfloat f;
	PangoLayout *layout;
	GtkEntryCompletion *g;
	val=gtk_combo_box_get_active(GTK_COMBO_BOX(get_options));
	switch(val)
	{
		case 0: num=gtk_entry_get_visibility(GTK_ENTRY(entry));
			if(num==TRUE)
				gtk_label_set_text(result,"TRUE");
			else
				gtk_label_set_text(result,"FALSE");
			break;
		case 1: ch=gtk_entry_get_invisible_char(GTK_ENTRY(entry));
			sprintf(str,"%c",ch);
			gtk_label_set_text(result,str);
		        break;
		case 2: str=gtk_entry_get_text(GTK_ENTRY(entry));
			gtk_label_set_text(result,str);
                        break;
                case 3: num=gtk_entry_get_activates_default(GTK_ENTRY(entry));
			if(num==TRUE)
	                        gtk_label_set_text(result,"TRUE");
	                else
	                        gtk_label_set_text(result,"FALSE");
                        break;
                case 4: num=gtk_entry_get_has_frame(GTK_ENTRY(entry));
			if(num==TRUE)
	                        gtk_label_set_text(result,"TRUE");
	                else
	                        gtk_label_set_text(result,"FALSE");
                        break;
		case 5: no=gtk_entry_get_width_chars(GTK_ENTRY(entry));
			sprintf(str,"%d",no);
			gtk_label_set_text(result,str);
                        break;
                case 6:	f=gtk_entry_get_alignment(GTK_ENTRY(entry));
			if(f==0)
				gtk_label_set_text(result,"LEFT");
			else
				gtk_label_set_text(result,"RIGHT");
                        break;
                case 7: no=gtk_entry_get_max_length(GTK_ENTRY(entry));
			sprintf(str,"%d",no);
                        gtk_label_set_text(result,str);
                        break;
		case 8: gtk_entry_get_layout_offsets(GTK_ENTRY(entry),&x,&y);
			gchar s2[10];
			sprintf(s2,"%d",x);
			gtk_label_set_text(result,s2);
			gchar s3[10];
			sprintf(s3,"%d",y);
                        gtk_label_set_text(resultl,s3);
			break;
		case 9: layout=gtk_entry_get_layout(GTK_ENTRY(entry));
			int text;
			pango_layout_set_width(layout,12);
			pango_layout_set_wrap(layout,PANGO_WRAP_WORD);
			text=pango_layout_get_width(layout);
			gchar s1[10];
			sprintf(s1,"%d",text);
			gtk_label_set_text(result,s1);
			gtk_label_set_text(resultl,"");
			break;
	}
}

/*---------------Displays the main window------------*/
void back_call(GtkButton *b,gpointer data)
{
	gtk_widget_hide(s_window);
	gtk_widget_show_all(m_window);
}

/*---------------When user clicks on dimmed entry widget----------*/
void dim_call(GtkWidget *w,gpointer data)
{
	        gtk_infoprint(GTK_WINDOW(m_window),"EntryBox is insensitive");
}

