/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

/*---------Second window where the dialog is displayed------------*/
void create_second_window()
{
	s_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	s_vbox=gtk_vbox_new(FALSE,0);
	s_hbox=gtk_hbox_new(FALSE,0);
	back_button=gtk_button_new_with_label("Back");
	sen_button=gtk_button_new_with_label("Set sensitive");
	gtk_box_pack_end(GTK_BOX(s_vbox),s_hbox,FALSE,0,0);
	gtk_box_pack_start(GTK_BOX(s_hbox),back_button,TRUE,0,0);
	gtk_box_pack_start(GTK_BOX(s_hbox),sen_button,TRUE,0,0);
	gtk_container_add(GTK_CONTAINER(s_window),s_vbox);
	g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(back_callback),NULL);
        g_signal_connect(G_OBJECT(sen_button),"clicked",G_CALLBACK(sen_callback),NULL);
		
}

/*------Creation of Main display window-------*/
void create_main_window(void)
{

	main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(main_window),"GtkDialog App");
	gtk_container_set_border_width(GTK_CONTAINER(main_window),10);
	gtk_widget_set_size_request(GTK_WIDGET(main_window),100,100);

	main_box=gtk_vbox_new(FALSE,0);

	main_modal_button=gtk_button_new_with_label("Modal Dialog");
	main_non_modal_button=gtk_button_new_with_label("Non Modal Dialog");
	main_close_button=gtk_button_new_with_label("Close");
	main_label=gtk_label_new("");

	create_second_window();

	gtk_box_pack_start(GTK_BOX(main_box),main_modal_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(main_box),main_non_modal_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(main_box),main_close_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(main_box),main_label,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(main_window),main_box);

	g_signal_connect(G_OBJECT(main_modal_button),"clicked",G_CALLBACK(create_modal_dialog),NULL);
	g_signal_connect(G_OBJECT(main_non_modal_button),"clicked",G_CALLBACK(create_non_modal_dialog),NULL);
	g_signal_connect(G_OBJECT(main_close_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(main_window),"destroy",gtk_main_quit,NULL);


	gtk_widget_show(main_modal_button);
	gtk_widget_show(main_non_modal_button);
	gtk_widget_show(main_close_button);
	gtk_widget_show(main_label);
	gtk_widget_show(main_box);
	gtk_widget_show(main_window);

}
