/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

/*--------------Modal dialog creation----------------*/
void create_modal_dialog(void)
{
	gtk_widget_hide(main_window);
	gtk_widget_show_all(s_window);
	modal_dialog=gtk_dialog_new_with_buttons("Modal Dialog",GTK_WINDOW(s_window),GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_OK,NULL);
	gtk_widget_set_sensitive(sen_button,FALSE);	

	/*-------------Contents in the dialog area----------------*/
	content1 = gtk_label_new ("Label in a dialog");
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG(modal_dialog)->vbox),content1,TRUE, TRUE, 0);
        gtk_widget_show (content1);
	content2 = gtk_entry_new ();
        gtk_box_pack_start (GTK_BOX (GTK_DIALOG(modal_dialog)->vbox),content2,TRUE, TRUE, 0);
        gtk_widget_show (content2);
	content3 = gtk_entry_new ();
        gtk_box_pack_start (GTK_BOX (GTK_DIALOG(modal_dialog)->vbox),content3,TRUE, TRUE, 0);
        gtk_widget_show (content3);
	/*--------------------------------------------------------*/
	
	gtk_container_set_border_width(GTK_CONTAINER(modal_dialog),10);

	modal_refresh_button=gtk_dialog_add_button(GTK_DIALOG(modal_dialog),GTK_STOCK_REFRESH,GTK_RESPONSE_ACCEPT);
	modal_cancel_button=gtk_dialog_add_button(GTK_DIALOG(modal_dialog),GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL);

	gtk_dialog_set_default_response(GTK_DIALOG(modal_dialog),GTK_RESPONSE_ACCEPT);
	gtk_dialog_set_response_sensitive(GTK_DIALOG(modal_dialog),GTK_RESPONSE_OK,FALSE);

	g_signal_connect(G_OBJECT(modal_dialog),"destroy",G_CALLBACK(gtk_widget_destroy),modal_dialog);
	g_signal_connect(G_OBJECT(modal_refresh_button),"clicked",G_CALLBACK(modal_cancel_call),NULL);

	gtk_widget_show(modal_dialog);

	gint res=gtk_dialog_run(GTK_DIALOG(modal_dialog));

	switch(res)
	{
		case GTK_RESPONSE_OK:  
					gtk_widget_hide(modal_dialog);
					gtk_widget_hide(s_window);
					gtk_widget_show_all(main_window);
					gtk_label_set_text(GTK_LABEL(main_label),"User Clicked Ok Button of Modal");
					break;

		case GTK_RESPONSE_CANCEL:
					gtk_widget_hide(modal_dialog);
					gtk_widget_hide(s_window);
        	                        gtk_widget_show_all(main_window);
					gtk_label_set_text(GTK_LABEL(main_label),"User Clicked Cancel Button of Modal");
					break;

		case GTK_RESPONSE_ACCEPT:
					gtk_widget_hide(modal_dialog);
					gtk_widget_hide(s_window);
                                        gtk_widget_show_all(main_window);
					gtk_label_set_text(GTK_LABEL(main_label),"User Clicked Refresh Button of Modal");
					break;
	}
	
	gtk_widget_destroy(modal_dialog);
}
		

/* --------------Creation of a non-modal dialog----------------*/
void create_non_modal_dialog(void)
{
	gtk_widget_hide(main_window);
	gtk_widget_show_all(s_window);	
	non_modal_dialog=gtk_dialog_new();
	        
	gtk_widget_set_sensitive(non_modal_dialog,FALSE);
        gtk_widget_set_sensitive(sen_button,TRUE);
        gtk_widget_set_sensitive(back_button,FALSE);
		
	gtk_window_set_title(GTK_WINDOW(non_modal_dialog),"Non Modal Dialog");
	gtk_container_set_border_width(GTK_CONTAINER(non_modal_dialog),10);
	gtk_widget_set_size_request(GTK_WIDGET(non_modal_dialog),500,100);

	gtk_dialog_add_buttons(GTK_DIALOG(non_modal_dialog),GTK_STOCK_OK,GTK_RESPONSE_OK,GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,NULL);

	sep_button=gtk_button_new_with_label("Separator");
	gtk_dialog_add_action_widget(GTK_DIALOG(non_modal_dialog),GTK_WIDGET(sep_button),GTK_RESPONSE_ACCEPT);

	g_signal_connect_swapped(G_OBJECT(sep_button),"clicked",G_CALLBACK(sep_call),NULL);
	g_signal_connect_swapped(G_OBJECT(non_modal_dialog),"destroy",G_CALLBACK(gtk_widget_destroy),G_OBJECT(non_modal_dialog));
	g_signal_connect_swapped(G_OBJECT(non_modal_dialog),"response",G_CALLBACK(non_modal_dialog_call),non_modal_dialog);
	
	gtk_widget_show(sep_button);
	gtk_widget_show(non_modal_dialog);

}

/*----------------Called when separator button is pressed in the non-modal dialog--------------*/
void sep_call(void)
{

	if(gtk_dialog_get_has_separator(GTK_DIALOG(non_modal_dialog)))
		gtk_dialog_set_has_separator(GTK_DIALOG(non_modal_dialog),FALSE);
	else
		gtk_dialog_set_has_separator(GTK_DIALOG(non_modal_dialog),TRUE);

}

void non_modal_dialog_call(GtkWidget *dialog,int response)
{

	switch(response)
	{
		case GTK_RESPONSE_OK:
					gtk_widget_hide(s_window);
			                gtk_widget_show_all(main_window);
					gtk_widget_destroy(non_modal_dialog);
					gtk_label_set_text(GTK_LABEL(main_label),"User Clicked Ok Button of Non-Modal");
					break;
		case GTK_RESPONSE_CANCEL:	
					gtk_widget_hide(s_window);
                                        gtk_widget_show_all(main_window);
					gtk_widget_destroy(non_modal_dialog);
					gtk_label_set_text(GTK_LABEL(main_label),"User Clicked Cancel Button of Non-Modal");
					break;

	}	
	
}

void modal_cancel_call(void)
{
	gtk_dialog_response(GTK_DIALOG(modal_dialog),GTK_RESPONSE_ACCEPT);
}


/*-----------------Displays the main window---------------*/
void back_callback(GtkButton *b,gpointer data)
{
	gtk_label_set_text(GTK_LABEL(main_label),"");
	gtk_widget_hide(s_window);
	gtk_widget_show_all(main_window);
	       
}

/*---------------Set sensitive callback---------------*/
void sen_callback(GtkButton *b,gpointer data)
{
       gtk_widget_set_sensitive(non_modal_dialog,TRUE);
       gtk_widget_set_sensitive(sen_button,FALSE);
       gtk_widget_set_sensitive(back_button,TRUE);
}


