/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"


GtkTreeModel* create_tree_model(void)
{
                                                                                                                     
        GtkListStore *store;
	GtkTreeIter iter;
	                                                                                                                       store=gtk_list_store_new(1,G_TYPE_STRING);
	                                                                                                                       gtk_list_store_append(store,&iter);
        gtk_list_store_set(store,&iter,0,"First Item",-1);
	gtk_list_store_append(store,&iter);
	gtk_list_store_set(store,&iter,0,"Second Item",-1);
	gtk_list_store_append(store,&iter);
	gtk_list_store_set(store,&iter,0,"Third Item",-1);
	gtk_list_store_append(store,&iter);
	gtk_list_store_set(store,&iter,0,"Fourth Item",-1);
	gtk_list_store_append(store,&iter);
	gtk_list_store_set(store,&iter,0,"Fifth Item",-1);
		 
	return GTK_TREE_MODEL(store);
}

void create_main_window (void)
{
	
	m_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	
	m_vbox=gtk_vbox_new(FALSE,0);
	m_hbox=gtk_hbox_new(FALSE,0);

	/*-----------------------ComboBoxEntry 1---------------------------------*/

	c_label1=gtk_label_new("ComboBoxEntry Text: ");
	c_entry1=gtk_combo_box_entry_new_text();	
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_entry1),"This is a very very loooooooong text to test to the truncation with ellipses");
        gtk_combo_box_append_text(GTK_COMBO_BOX(c_entry1),"Item2");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_entry1),"Item3");
        gtk_combo_box_append_text(GTK_COMBO_BOX(c_entry1),"Item4");
        gtk_combo_box_append_text(GTK_COMBO_BOX(c_entry1),"Item5");
        gtk_combo_box_append_text(GTK_COMBO_BOX(c_entry1),"Item6");
        gtk_combo_box_append_text(GTK_COMBO_BOX(c_entry1),"Item7");
        gtk_combo_box_append_text(GTK_COMBO_BOX(c_entry1),"Item8");
						

	/*----------------------ComboBoxEntry 2---------------------------------*/
	
	c_label2=gtk_label_new("ComboBoxEntry Model: ");
	c_entry2 = gtk_combo_box_entry_new_with_model(GTK_TREE_MODEL(create_tree_model()),0);

	quit_button=gtk_button_new_with_label("Quit");

	/*--------------------For testing the dimmed effect on the widget--------------*/
	d_button_1=gtk_button_new_with_label("Dim Input");
	d_button_2=gtk_button_new_with_label("Dim Widget");
		
	g_signal_connect(G_OBJECT(m_window),"destroy",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(d_button_1),"clicked",G_CALLBACK(dim_input),NULL);
        g_signal_connect(G_OBJECT(d_button_2),"clicked",G_CALLBACK(dim_widget),NULL);
		
	gtk_container_add(GTK_CONTAINER(m_window),m_vbox);
	gtk_box_pack_start(GTK_BOX(m_vbox),c_label1,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(m_vbox),c_entry1,FALSE,FALSE,10);
        gtk_box_pack_start(GTK_BOX(m_vbox),c_label2,FALSE,FALSE,10);
        gtk_box_pack_start(GTK_BOX(m_vbox),c_entry2,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(m_vbox),m_hbox,FALSE,FALSE,10);
        gtk_box_pack_start(GTK_BOX(m_hbox),d_button_1,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(m_hbox),d_button_2,FALSE,FALSE,10);
 
	gtk_box_pack_end(GTK_BOX(m_vbox),quit_button,FALSE,FALSE,0);
	
	gtk_widget_show_all(m_window);
}
