/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

//Main Function
//Creates the main window
int main(int argc,char *argv[])
{

	gtk_init(&argc,&argv);

	main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(main_window),10);
	gtk_window_set_title(GTK_WINDOW(main_window),"ComboBox App");
	g_signal_connect(G_OBJECT(main_window),"destroy",gtk_main_quit,NULL);

	main_box=gtk_vbox_new(FALSE,0);

	text_button=gtk_button_new_with_label("ComboBox ");
	linear_button=gtk_button_new_with_label("ComboBox LinearList");
	grid_button=gtk_button_new_with_label("ComboBox Grid");
	empty_button=gtk_button_new_with_label("ComboBox Empty");
	close_button=gtk_button_new_with_label("Close");

	gtk_box_pack_start(GTK_BOX(main_box),text_button,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(main_box),linear_button,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(main_box),grid_button,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(main_box),empty_button,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(main_box),close_button,FALSE,FALSE,5);
	gtk_container_add(GTK_CONTAINER(main_window),main_box);

	g_signal_connect(G_OBJECT(text_button),"clicked",G_CALLBACK(create_combo_entry),NULL);
	g_signal_connect(G_OBJECT(linear_button),"clicked",G_CALLBACK(create_combo_linear),NULL);
	g_signal_connect(G_OBJECT(grid_button),"clicked",G_CALLBACK(create_combo_grid),NULL);
	g_signal_connect(G_OBJECT(empty_button),"clicked",G_CALLBACK(create_combo_empty),NULL);
	g_signal_connect(G_OBJECT(close_button),"clicked",gtk_main_quit,NULL);

	gtk_widget_show(text_button);
	gtk_widget_show(linear_button);
	gtk_widget_show(grid_button);
	gtk_widget_show(empty_button);
	gtk_widget_show(close_button);
	gtk_widget_show(main_box);
	gtk_widget_show(main_window);

	gtk_main();
	return 0;

}

