/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

//Creates the combo box with text
void create_combo_entry(void)
{

	GtkWidget *test_combo4;
	GtkWidget *test_button2;
	GtkWidget *int_frame2;

        int_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(int_window),10);
        gtk_widget_set_size_request(GTK_WIDGET(int_window),100,100);
	gtk_window_set_title(GTK_WINDOW(int_window),"ComboBox");
        g_signal_connect(G_OBJECT(int_window),"destroy",G_CALLBACK(home_call),NULL);

        int_box=gtk_vbox_new(FALSE,2);
        gtk_container_add(GTK_CONTAINER(int_window),int_box);

	int_box1=gtk_vbox_new(FALSE,2);
	gtk_box_pack_start(GTK_BOX(int_box),int_box1,FALSE,FALSE,0);

        int_frame=gtk_frame_new("GtkComboBox");
        gtk_box_pack_start(GTK_BOX(int_box1),int_frame,FALSE,FALSE,0);
        int_box2=gtk_vbox_new(FALSE,0);
        gtk_container_set_border_width(GTK_CONTAINER(int_box2),5);
        gtk_container_add(GTK_CONTAINER(int_frame),int_box2);

        int_combo=gtk_combo_box_new_text();
        setup_combo_entry(int_combo);
        gtk_container_add(GTK_CONTAINER(int_box2),int_combo);

        entry_label=gtk_label_new("test");
        gtk_box_pack_start(GTK_BOX(int_box),entry_label,FALSE,FALSE,0);
	
        gtk_combo_box_set_active(GTK_COMBO_BOX(int_combo),1);
        entry_combo_call();

        g_signal_connect(G_OBJECT(int_combo),"changed",G_CALLBACK(entry_combo_call),NULL);

	int_frame2=gtk_frame_new("Dimmed ComboBox");
	gtk_box_pack_start(GTK_BOX(int_box),int_frame2,FALSE,FALSE,5);
	
	test_combo4=gtk_combo_box_new_text();
	gtk_container_add(GTK_CONTAINER(int_frame2), test_combo4);
	gtk_widget_set_sensitive(test_combo4, FALSE);
	
	test_combo3=gtk_combo_box_new_text();
	gtk_box_pack_start(GTK_BOX(int_box),test_combo3,FALSE,FALSE,5);
	
	test_button2=gtk_button_new_with_label("Add Items");
	gtk_box_pack_start(GTK_BOX(int_box),test_button2,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(test_button2),"clicked",G_CALLBACK(add_items_call),NULL);
	
	int_box3=gtk_hbox_new(FALSE,2);
	gtk_container_set_border_width(GTK_CONTAINER(int_box3),5);
	gtk_box_pack_end(GTK_BOX(int_box),int_box3,FALSE,FALSE,0);

	home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_start(GTK_BOX(int_box3),home_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(home_button),"clicked",G_CALLBACK(home_call),NULL);

	gtk_widget_show(int_combo);
	gtk_widget_show(test_combo3);
	gtk_widget_show(test_combo4);
	gtk_widget_show(int_frame2);
	gtk_widget_show(test_button2);
	gtk_widget_show(int_box1);
	gtk_widget_show(int_frame);
	gtk_widget_show(entry_label);
	gtk_widget_show(home_button);
	gtk_widget_show(int_box2);
	gtk_widget_show(int_box3);
	gtk_widget_show(int_box);
	gtk_widget_show(int_window);

}

//Creates a combobox linear list  
void create_combo_linear(void)
{
       
	GtkWidget *model_button;
	GtkWidget *tmp_box;
	GtkWidget *popup_button;
	GtkWidget *popdown_button;
 
	int_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(int_window),10);
	gtk_widget_set_size_request(GTK_WIDGET(int_window),100,100);
	gtk_window_set_title(GTK_WINDOW(int_window),"ComboBox LinearList");
	g_signal_connect(G_OBJECT(int_window),"destroy",G_CALLBACK(home_call),NULL);

	int_box=gtk_vbox_new(FALSE,2);
	gtk_container_add(GTK_CONTAINER(int_window),int_box);

        int_box1=gtk_vbox_new(FALSE,2);
        gtk_box_pack_start(GTK_BOX(int_box),int_box1,FALSE,FALSE,0);

	int_frame=gtk_frame_new("GtkComboBox LinearList");
	gtk_box_pack_start(GTK_BOX(int_box1),int_frame,FALSE,FALSE,0);
	int_box2=gtk_vbox_new(FALSE,0);
        gtk_container_set_border_width(GTK_CONTAINER(int_box2),5);
        gtk_container_add(GTK_CONTAINER(int_frame),int_box2);

        int_combo=setup_combo_linear();
        gtk_box_pack_start(GTK_BOX(int_box2),int_combo,FALSE,FALSE,0);

	/*------------------Changes the model of the linear list with 3 items--------------------*/
	model_button=gtk_button_new_with_label("Change the Model");
	gtk_box_pack_start(GTK_BOX(int_box1),model_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(model_button),"clicked",G_CALLBACK(model_button_call),NULL);

	tmp_box=gtk_hbox_new(FALSE,2);
	gtk_box_pack_start(GTK_BOX(int_box1),tmp_box,FALSE,FALSE,0);

	/*------------------Pops up the linear list---------------------------------------------*/
	popup_button=gtk_button_new_with_label("Popup");
	gtk_box_pack_start(GTK_BOX(tmp_box),popup_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(popup_button),"clicked",G_CALLBACK(popup_button_call),NULL);
	
       /*-------------------Pops down the linear list------------------------------------------*/
	popdown_button=gtk_button_new_with_label("Popdown");
	gtk_box_pack_end(GTK_BOX(tmp_box),popdown_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(popdown_button),"clicked",G_CALLBACK(popdown_button_call),NULL);
	
	linear_label=gtk_label_new("test");
	gtk_box_pack_start(GTK_BOX(int_box1),linear_label,FALSE,FALSE,0);
	
	/*-----------------Signal Handler for the combo box linear list-----------------------*/
	g_signal_connect(G_OBJECT(int_combo),"changed",G_CALLBACK(linear_combo_call),NULL);

        int_box3=gtk_hbox_new(FALSE,2);
        gtk_container_set_border_width(GTK_CONTAINER(int_box3),5);
        gtk_box_pack_end(GTK_BOX(int_box),int_box3,FALSE,FALSE,0);

        home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
        gtk_box_pack_start(GTK_BOX(int_box3),home_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(home_button),"clicked",G_CALLBACK(home_call),NULL);

	gtk_widget_show(int_combo);
	gtk_widget_show(int_box1);
	gtk_widget_show(int_frame);
	gtk_widget_show(int_box2);
	gtk_widget_show(model_button);
	gtk_widget_show(popup_button);
	gtk_widget_show(popdown_button);
	gtk_widget_show(tmp_box);
	gtk_widget_show(home_button);
	gtk_widget_show(int_box3);
	gtk_widget_hide(linear_label);
	gtk_widget_show(int_box);
	gtk_widget_show(int_window);

}

// Creates the combobox in grid view
void create_combo_grid(void)
{

        int_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(int_window),10);
        gtk_widget_set_size_request(GTK_WIDGET(int_window),100,100);
	gtk_window_set_title(GTK_WINDOW(int_window),"ComboBox Grid");
        g_signal_connect(G_OBJECT(int_window),"destroy",G_CALLBACK(home_call),NULL);

        int_box=gtk_vbox_new(FALSE,2);
        gtk_container_add(GTK_CONTAINER(int_window),int_box);

	tmp_box=gtk_hbox_new(FALSE,2);
	gtk_box_pack_start(GTK_BOX(int_box),tmp_box,FALSE,FALSE,0);

	/*---------------------Displays the combobox as a 3x3 matrix------------------------*/
	grid_button=gtk_button_new_with_label("Grid");
	gtk_box_pack_start(GTK_BOX(tmp_box),grid_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(grid_button),"clicked",G_CALLBACK(setup_combo_grid),NULL);
	
	/*--------------------Row spans the combobox----------------------------------------*/
	row_button=gtk_button_new_with_label("Row");
	gtk_box_pack_start(GTK_BOX(tmp_box),row_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(row_button),"clicked",G_CALLBACK(setup_combo_grid_row),NULL);
	
	/*-------------------Column spans the combobox-------------------------------------*/
	col_button=gtk_button_new_with_label("Col");
	gtk_box_pack_start(GTK_BOX(tmp_box),col_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(col_button),"clicked",G_CALLBACK(setup_combo_grid_col),NULL);

        int_box3=gtk_hbox_new(FALSE,2);
        gtk_container_set_border_width(GTK_CONTAINER(int_box3),5);
        gtk_box_pack_end(GTK_BOX(int_box),int_box3,FALSE,FALSE,0);

        home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
        gtk_box_pack_start(GTK_BOX(int_box3),home_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(home_button),"clicked",G_CALLBACK(home_call),NULL);

        gtk_widget_show(grid_button);
        gtk_widget_show(row_button);
        gtk_widget_show(col_button);
	gtk_widget_show(tmp_box);
        gtk_widget_show(home_button);
        gtk_widget_show(int_box3);
        gtk_widget_show(int_box);
        gtk_widget_show(int_window);

}

//Creates an empty combobox
void create_combo_empty(void)
{
	GtkWidget *combo;

        int_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(int_window),10);
        gtk_widget_set_size_request(GTK_WIDGET(int_window),100,100);
	gtk_window_set_title(GTK_WINDOW(int_window),"ComboBox Empty");
        g_signal_connect(G_OBJECT(int_window),"destroy",G_CALLBACK(home_call),NULL);

	int_box=gtk_vbox_new(FALSE,2);
	gtk_container_add(GTK_CONTAINER(int_window),int_box);

        combo=gtk_combo_box_new();
	gtk_box_pack_start(GTK_BOX(int_box),combo,FALSE,FALSE,0);

        int_box3=gtk_hbox_new(FALSE,2);
        gtk_container_set_border_width(GTK_CONTAINER(int_box3),5);
        gtk_box_pack_end(GTK_BOX(int_box),int_box3,FALSE,FALSE,0);

        home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
        gtk_box_pack_start(GTK_BOX(int_box3),home_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(home_button),"clicked",G_CALLBACK(home_call),NULL);

        gtk_widget_show(combo);
	gtk_widget_show(home_button);
	gtk_widget_show(int_box);
	gtk_widget_show(int_box3);
        gtk_widget_show(int_window);

}
