/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

//Action on clicking 'Combobox text entry' button
void setup_combo_entry(GtkWidget *entrybox)
{
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"rose");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"lily");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"daisy");

	gtk_combo_box_insert_text(GTK_COMBO_BOX(entrybox),3,"lotus");
	gtk_combo_box_insert_text(GTK_COMBO_BOX(entrybox),2,"jasmine is the queen of flowers found in almost all the countries. It is very famous especially in India.");

	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"chrysanthemum");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test1");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test2");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test3");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test4");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test4");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test5");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test6");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test7");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test8");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test9");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test10");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test11");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test12");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test13");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test14");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test15");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test16");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test17");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test18");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test19");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test20");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test21");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test22");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test23");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test24");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test25");
	gtk_combo_box_append_text(GTK_COMBO_BOX(entrybox),"test26");

	
	gtk_combo_box_prepend_text(GTK_COMBO_BOX(entrybox),"tulip");

	gtk_combo_box_remove_text(GTK_COMBO_BOX(entrybox),2);

}

//Action on clicking 'Combobox Linear List' button
GtkWidget* setup_combo_linear()
{

        linear_combo=gtk_combo_box_new_with_model(GTK_TREE_MODEL(create_tree_model()));

	linear_cell=gtk_cell_renderer_pixbuf_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(linear_combo),linear_cell,FALSE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(linear_combo),linear_cell,"pixbuf",0,NULL);

        linear_cell=gtk_cell_renderer_text_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(linear_combo),linear_cell,TRUE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(linear_combo),linear_cell,"text",1,NULL);

        return linear_combo;

}

//Action on clicking 'ComboBox Grid' button
void setup_combo_grid(void)
{

	GtkWidget *back_button;

        grid_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(grid_window),10);
        gtk_widget_set_size_request(GTK_WIDGET(grid_window),100,100);
	gtk_window_set_title(GTK_WINDOW(grid_window),"ComboBox GridChild");
        g_signal_connect(G_OBJECT(grid_window),"destroy",G_CALLBACK(grid_call),NULL);

        grid_box=gtk_vbox_new(FALSE,2);
        gtk_container_add(GTK_CONTAINER(grid_window),grid_box);

        grid_box1=gtk_vbox_new(FALSE,2);
        gtk_box_pack_start(GTK_BOX(grid_box),grid_box1,FALSE,FALSE,0);

        grid_frame=gtk_frame_new("GtkComboBox Grid");
        gtk_box_pack_start(GTK_BOX(grid_box1),grid_frame,FALSE,FALSE,0);
        grid_box2=gtk_vbox_new(FALSE,0);
        gtk_container_set_border_width(GTK_CONTAINER(grid_box2),5);
        gtk_container_add(GTK_CONTAINER(grid_frame),grid_box2);

        grid_combo=call_combo_grid();
        gtk_box_pack_start(GTK_BOX(grid_box2),grid_combo,FALSE,FALSE,0);

        grid_box3=gtk_hbox_new(FALSE,2);
        gtk_container_set_border_width(GTK_CONTAINER(grid_box3),5);
        gtk_box_pack_end(GTK_BOX(grid_box),grid_box3,FALSE,FALSE,0);

        back_button=gtk_button_new_from_stock(GTK_STOCK_GO_BACK);
        gtk_box_pack_start(GTK_BOX(grid_box3),back_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(grid_call),NULL);

        gtk_widget_show(grid_combo);
        gtk_widget_show(grid_box1);
        gtk_widget_show(grid_frame);
        gtk_widget_show(grid_box2);
        gtk_widget_show(back_button);
        gtk_widget_show(grid_box3);
        gtk_widget_show(grid_box);
        gtk_widget_show(grid_window);

}

//Action on clicking 'Row' button in 'ComboBox GridChild' window
void setup_combo_grid_row(void)
{

        GtkWidget *back_button;

        grid_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(grid_window),10);
        gtk_widget_set_size_request(GTK_WIDGET(grid_window),100,100);
	gtk_window_set_title(GTK_WINDOW(grid_window),"ComboBox GridRow");
        g_signal_connect(G_OBJECT(grid_window),"destroy",G_CALLBACK(grid_call),NULL);

        grid_box=gtk_vbox_new(FALSE,2);
        gtk_container_add(GTK_CONTAINER(grid_window),grid_box);

        grid_box1=gtk_vbox_new(FALSE,2);
        gtk_box_pack_start(GTK_BOX(grid_box),grid_box1,FALSE,FALSE,0);

        grid_frame=gtk_frame_new("GtkComboBox GridRow");
        gtk_box_pack_start(GTK_BOX(grid_box1),grid_frame,FALSE,FALSE,0);
        grid_box2=gtk_vbox_new(FALSE,0);
        gtk_container_set_border_width(GTK_CONTAINER(grid_box2),5);
        gtk_container_add(GTK_CONTAINER(grid_frame),grid_box2);

        grid_combo=call_combo_grid_row();
        gtk_box_pack_start(GTK_BOX(grid_box2),grid_combo,FALSE,FALSE,0);

        grid_box3=gtk_hbox_new(FALSE,2);
        gtk_container_set_border_width(GTK_CONTAINER(grid_box3),5);
        gtk_box_pack_end(GTK_BOX(grid_box),grid_box3,FALSE,FALSE,0);

        back_button=gtk_button_new_from_stock(GTK_STOCK_GO_BACK);
        gtk_box_pack_start(GTK_BOX(grid_box3),back_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(grid_call),NULL);

        gtk_widget_show(grid_combo);
        gtk_widget_show(grid_box1);
        gtk_widget_show(grid_frame);
        gtk_widget_show(grid_box2);
        gtk_widget_show(back_button);
        gtk_widget_show(grid_box3);
        gtk_widget_show(grid_box);
        gtk_widget_show(grid_window);

}

//Action on clicking 'Column' button in 'ComboBox GridChild' window
void setup_combo_grid_col(void)
{

        GtkWidget *back_button;

        grid_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(grid_window),10);
        gtk_widget_set_size_request(GTK_WIDGET(grid_window),100,100);
	gtk_window_set_title(GTK_WINDOW(grid_window),"ComboBox GridCol");
        g_signal_connect(G_OBJECT(grid_window),"destroy",G_CALLBACK(grid_call),NULL);

        grid_box=gtk_vbox_new(FALSE,2);
        gtk_container_add(GTK_CONTAINER(grid_window),grid_box);

        grid_box1=gtk_vbox_new(FALSE,2);
        gtk_box_pack_start(GTK_BOX(grid_box),grid_box1,FALSE,FALSE,0);

        grid_frame=gtk_frame_new("GtkComboBox GridCol");
        gtk_box_pack_start(GTK_BOX(grid_box1),grid_frame,FALSE,FALSE,0);
        grid_box2=gtk_vbox_new(FALSE,0);
        gtk_container_set_border_width(GTK_CONTAINER(grid_box2),5);
        gtk_container_add(GTK_CONTAINER(grid_frame),grid_box2);

        grid_combo=call_combo_grid_col();
        gtk_box_pack_start(GTK_BOX(grid_box2),grid_combo,FALSE,FALSE,0);

        grid_box3=gtk_hbox_new(FALSE,2);
        gtk_container_set_border_width(GTK_CONTAINER(grid_box3),5);
        gtk_box_pack_end(GTK_BOX(grid_box),grid_box3,FALSE,FALSE,0);

        back_button=gtk_button_new_from_stock(GTK_STOCK_GO_BACK);
        gtk_box_pack_start(GTK_BOX(grid_box3),back_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(grid_call),NULL);

        gtk_widget_show(grid_combo);
        gtk_widget_show(grid_box1);
        gtk_widget_show(grid_frame);
        gtk_widget_show(grid_box2);
        gtk_widget_show(back_button);
        gtk_widget_show(grid_box3);
        gtk_widget_show(grid_box);
        gtk_widget_show(grid_window);
}

//Creates the combobox grid items
GtkWidget* call_combo_grid(void)
{
	
        grid_list=gtk_list_store_new(2,GDK_TYPE_PIXBUF,G_TYPE_STRING);

        grid_combo=gtk_combo_box_new_with_model(GTK_TREE_MODEL(grid_list));
        gtk_combo_box_set_wrap_width(GTK_COMBO_BOX(grid_combo),3);

        grid_cell=gtk_cell_renderer_pixbuf_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(grid_combo),grid_cell,TRUE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(grid_combo),grid_cell,"pixbuf",0,NULL);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("red"),1,"red",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("green"),1,"grn",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("blue"),1,"blu",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("yellow"),1,"yel",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("white"),1,"wht",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("black"),1,"blk",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("cyan"),1,"cyn",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("magenta"),1,"mag",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("none"),1,"non",-1);

        grid_cell=gtk_cell_renderer_text_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(grid_combo),grid_cell,FALSE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(grid_combo),grid_cell,"text",1,NULL);

        gtk_combo_box_set_active(GTK_COMBO_BOX(grid_combo),1);

        return grid_combo;

}

//Creates the combobox row span items
GtkWidget* call_combo_grid_row(void)
{

        grid_list=gtk_list_store_new(2,GDK_TYPE_PIXBUF,G_TYPE_STRING);

        grid_combo=gtk_combo_box_new_with_model(GTK_TREE_MODEL(grid_list));
//	gtk_combo_box_set_wrap_width(GTK_COMBO_BOX(grid_combo),3);
        gtk_combo_box_set_row_span_column(GTK_COMBO_BOX(grid_combo),0);

        grid_cell=gtk_cell_renderer_pixbuf_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(grid_combo),grid_cell,TRUE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(grid_combo),grid_cell,"pixbuf",0,NULL);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("red"),1,"red",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("green"),1,"grn",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("blue"),1,"blu",-1);


        grid_cell=gtk_cell_renderer_text_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(grid_combo),grid_cell,FALSE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(grid_combo),grid_cell,"text",1,NULL);

        gtk_combo_box_set_active(GTK_COMBO_BOX(grid_combo),1);

        return grid_combo;

}

//Creates the combobox column span items
GtkWidget* call_combo_grid_col(void)
{

        grid_list=gtk_list_store_new(2,GDK_TYPE_PIXBUF,G_TYPE_STRING);

        grid_combo=gtk_combo_box_new_with_model(GTK_TREE_MODEL(grid_list));
        gtk_combo_box_set_column_span_column(GTK_COMBO_BOX(grid_combo),1);

        grid_cell=gtk_cell_renderer_pixbuf_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(grid_combo),grid_cell,TRUE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(grid_combo),grid_cell,"pixbuf",0,NULL);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("red"),1,"red",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("green"),1,"grn",-1);

        gtk_list_store_append(grid_list,&grid_iter);
        gtk_list_store_set(grid_list,&grid_iter,0,create_color("blue"),1,"blu",-1);

        grid_cell=gtk_cell_renderer_text_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(grid_combo),grid_cell,FALSE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(grid_combo),grid_cell,"text",1,NULL);

        gtk_combo_box_set_active(GTK_COMBO_BOX(grid_combo),1);

        return grid_combo;

}

//Action on clicking 'Change Model' button 
void model_button_call(void)
{

	GtkTreeModel *temp;
	GtkListStore *store;
	GdkPixbuf *pixbuf;

	temp=gtk_combo_box_get_model(GTK_COMBO_BOX(linear_combo));
	gtk_list_store_clear(GTK_LIST_STORE(temp));

	store=gtk_list_store_new(2,GDK_TYPE_PIXBUF,G_TYPE_STRING);

	pixbuf=gtk_widget_render_icon(cellview,GTK_STOCK_DIALOG_WARNING,GTK_ICON_SIZE_BUTTON,NULL);
	gtk_list_store_append(store,&linear_iter);
	gtk_list_store_set(store,&linear_iter,0,pixbuf,1,"gtk-stock-dialog-warning",-1);

	pixbuf=gtk_widget_render_icon(cellview,GTK_STOCK_REDO,GTK_ICON_SIZE_BUTTON,NULL);
	gtk_list_store_append(store,&linear_iter);
	gtk_list_store_set(store,&linear_iter,0,pixbuf,1,"gtk-redo",-1);

	pixbuf=gtk_widget_render_icon(cellview,GTK_STOCK_QUIT,GTK_ICON_SIZE_BUTTON,NULL);
	gtk_list_store_append(store,&linear_iter);
	gtk_list_store_set(store,&linear_iter,0,pixbuf,1,"gtk-quit",-1);

	gtk_combo_box_set_model(GTK_COMBO_BOX(int_combo),GTK_TREE_MODEL(store));
	gtk_combo_box_set_active_iter(GTK_COMBO_BOX(int_combo),&linear_iter);
	
}

//Action on clicking 'Popup' button 
void popup_button_call(void)
{

	gtk_combo_box_popup(GTK_COMBO_BOX(linear_combo));

}

//Action on clicking 'Popdown' button
void popdown_button_call(void)
{

	gtk_combo_box_popdown(GTK_COMBO_BOX(linear_combo));

}

//Calback for text entries in the combobox	
void entry_combo_call(void)
{

	int sel;

	gtk_widget_hide(entry_label);       
	sel=gtk_combo_box_get_active(GTK_COMBO_BOX(int_combo));
        if(sel==0)
                entry_label=gtk_label_new("First item Selected");
        else if(sel==1)
                entry_label=gtk_label_new("Second item Selected");
	else if(sel==2)
		entry_label=gtk_label_new("Third item Selected");
	else if(sel==3)
		entry_label=gtk_label_new("Fourth item Selected");
	else if(sel==4)
		entry_label=gtk_label_new("Fifth item Selected");
	else
		entry_label=gtk_label_new("Default Selected");
        gtk_box_pack_start(GTK_BOX(int_box),entry_label,FALSE,FALSE,0);
	gtk_widget_show(entry_label);

}

//Callback for combobox linear list
void linear_combo_call(void)
{

	GtkTreeIter iter;

	gtk_widget_hide(linear_label);
	if(gtk_combo_box_get_active_iter(GTK_COMBO_BOX(linear_combo),&iter))
	{
		linear_label=gtk_label_new("U have selected an item");
		gtk_box_pack_start(GTK_BOX(int_box1),linear_label,FALSE,FALSE,0);
		gtk_widget_show(linear_label);
	}

}

//Action on clicking 'Home' button
void home_call(void)
{

	gtk_widget_destroy(int_window);
	gtk_widget_show(main_window);

}

//Action on clicking 'Back' button 
void grid_call(void)
{

	gtk_widget_destroy(grid_window);
	gtk_widget_show(int_window);

}
	
//Creates the color maps for the grid items	
GdkPixbuf* create_color(const char *color)
{

        GdkPixbuf *pixbuf;
        GdkColor col;

        int x,num,rowstride;
        guchar *pixels,*p;

        if(!gdk_color_parse(color,&col))
                return NULL;

        pixbuf=gdk_pixbuf_new(GDK_COLORSPACE_RGB,FALSE,8,16,16);

        rowstride=gdk_pixbuf_get_rowstride(pixbuf);
        p=pixels=gdk_pixbuf_get_pixels(pixbuf);

        num=gdk_pixbuf_get_width(pixbuf)*gdk_pixbuf_get_height(pixbuf);

        for(x=0;x<num;x++)
        {
                p[0]=col.red/65535*255;
                p[1]=col.green/65535*255;
                p[2]=col.blue/65535*255;
                p+=3;
        }

        return pixbuf;

}

//Creates the tree model for combobox linear list
GtkTreeModel* create_tree_model(void)
{

        GdkPixbuf *pixbuf;
        GtkListStore *store;

        cellview=gtk_cell_view_new();

        store=gtk_list_store_new(2,GDK_TYPE_PIXBUF,G_TYPE_STRING);

        pixbuf=gtk_widget_render_icon(cellview, GTK_STOCK_DIALOG_WARNING,GTK_ICON_SIZE_BUTTON, NULL);
        gtk_list_store_append(store, &linear_iter);
        gtk_list_store_set(store,&linear_iter,0,pixbuf,1,"gtk-stock-dialog-warning",-1);

        pixbuf=gtk_widget_render_icon(cellview,GTK_STOCK_STOP,GTK_ICON_SIZE_BUTTON, NULL);
        gtk_list_store_append(store,&linear_iter);
        gtk_list_store_set(store,&linear_iter,0, pixbuf,1, "gtk-stock-stop",-1);

        pixbuf=gtk_widget_render_icon(cellview,GTK_STOCK_NEW,GTK_ICON_SIZE_BUTTON, NULL);
        gtk_list_store_append(store,&linear_iter);
        gtk_list_store_set(store,&linear_iter,0, pixbuf,1, "gtk-stock-new",-1);

        pixbuf=gtk_widget_render_icon(cellview,GTK_STOCK_CLEAR,GTK_ICON_SIZE_BUTTON, NULL);
        gtk_list_store_append(store,&linear_iter);
        gtk_list_store_set(store,&linear_iter,0, pixbuf,1, "gtk-stock-clear",-1);

        gtk_widget_destroy(cellview);

        return GTK_TREE_MODEL(store);
}


//Action on clicking 'Add Items' Button
void add_items_call(void)
{
	gtk_combo_box_append_text(GTK_COMBO_BOX(test_combo3),"lasketchup");

}


				
