/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Action on clicking 'Return' button
void on_ret(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(win_2);
	gtk_widget_hide(win);
	gtk_widget_show(window);
}

//Action on selecting 'Test Functionality' from the 'Select' option menu
void win2()
{
	GtkWidget *hbox3, *hbox4, *vbox3, *cb1, *Bret;
	win_2=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(win_2), 20);
			
	frame2=gtk_frame_new(" ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame2), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame2), 0.5, 0.5);
        gtk_container_add(GTK_CONTAINER(win_2), frame2);

	hbox3=gtk_hbox_new(FALSE, 0);
	hbox4=gtk_hbox_new(FALSE, 0);
	vbox3=gtk_vbox_new(FALSE, 100);

	gint i;
        i=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu));
	/*----------------------Switch on selecting 'Checkbox with Mnemonic ' or 'Checkbox with label' from the 'Select' option menu*/
	if( i == 6)
	{
		cb1=gtk_check_button_new_with_mnemonic("Click _Here");
		gtk_box_pack_start(GTK_BOX(hbox3), cb1, TRUE, 0, 0);
		gtk_box_pack_start(GTK_BOX(vbox3), hbox3, FALSE, 0, 40);
		gtk_container_add(GTK_CONTAINER(frame2), vbox3);
	}
	else if ( i == 7)
	{
		cb1=gtk_check_button_new_with_label("Check box");
		gtk_box_pack_start(GTK_BOX(hbox3), cb1, TRUE, 0, 0);
		gtk_box_pack_start(GTK_BOX(vbox3), hbox3, FALSE, 0, 40);
                gtk_container_add(GTK_CONTAINER(frame2), vbox3);
	}

	Bret=gtk_button_new_with_label("Return");
	gtk_widget_set_usize(GTK_WIDGET(Bret), 250, 40);
	gtk_box_pack_start(GTK_BOX(hbox4), Bret, TRUE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox3), hbox4, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(Bret), "clicked", GTK_SIGNAL_FUNC(on_ret), NULL);
	gtk_widget_show_all(win_2);
		
}
				
//Action on selecting an item from 'Select' option menu
void on_options(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(win);
	gtk_widget_show(window);
	gint i;
	i=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu));
	
	/*----------Switch on selection of items from the option menu-----------*/
	if( i == 0 )
	{
		gtk_widget_set_sensitive(GTK_WIDGET(cb), TRUE);
		gtk_toggle_button_set_inconsistent(GTK_TOGGLE_BUTTON(cb), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), TRUE);
	}
	else if ( i == 1 )
	{	
		gtk_widget_set_sensitive(GTK_WIDGET(cb), TRUE);
                gtk_toggle_button_set_inconsistent(GTK_TOGGLE_BUTTON(cb), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), TRUE);
		gtk_widget_set_sensitive(GTK_WIDGET(cb), FALSE);
	}
	else if ( i == 2 )
	{
		gtk_widget_set_sensitive(GTK_WIDGET(cb), TRUE);
		gtk_toggle_button_set_inconsistent(GTK_TOGGLE_BUTTON(cb), TRUE);
	}
	else if ( i == 3 )
	{
		gtk_toggle_button_set_inconsistent(GTK_TOGGLE_BUTTON(cb), TRUE);
		gtk_widget_set_sensitive(GTK_WIDGET(cb), FALSE);
	}
	else if ( i == 4 )
	{
		gtk_toggle_button_set_inconsistent(GTK_TOGGLE_BUTTON(cb), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(cb), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), FALSE);	
	}
	else if ( i == 5 )
	{
		gtk_toggle_button_set_inconsistent(GTK_TOGGLE_BUTTON(cb), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(cb), FALSE);
	}
	else if ( i == 6 )
	{
		win2();
	}
	else if ( i == 7 )
	{
		win2();
	}
	else if ( i == 8 )
	{
		gtk_widget_hide(win);
		gtk_widget_show(window);
		gtk_widget_show(cb1);
		gtk_widget_show(cb2);
        }
}
	
//Action on clicking 'Properties' button in the main window
void on_prop(GtkWidget *button, gpointer data)
{
	win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(win), 20);

	hbox2=gtk_hbox_new(FALSE, 0);
	vbox1=gtk_vbox_new(FALSE, 20);

	frame1=gtk_frame_new(" ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame1), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame1), 0.5, 0.5);
        gtk_container_add(GTK_CONTAINER(win), frame1);

	Label=gtk_label_new("Select:");
	gtk_box_pack_start(GTK_BOX(hbox2), Label, FALSE, 0, 50);

	option_menu=gtk_option_menu_new();
	gtk_widget_set_usize(GTK_WIDGET(option_menu), 350, 50);
	menu=gtk_menu_new();
        menu_item=gtk_menu_item_new_with_label("Selected State");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Selected and Dimmed State");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Indeterminate State");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Indeterminate and Dimmed State");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);
		 

	menu_item=gtk_menu_item_new_with_label("Not Selected State");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Not Selected and Dimmed State");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Checkbox with Mnemonic");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Checkbox with label");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Test Functionality");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu),menu);
	gtk_box_pack_start(GTK_BOX(hbox2), option_menu, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox2, FALSE, 0, 10);
	gtk_container_add(GTK_CONTAINER(frame1), vbox1);

	/*-----------------------Signal Handler-----------------------------*/
	gtk_signal_connect(GTK_OBJECT(option_menu), "changed", GTK_SIGNAL_FUNC(on_options), NULL);
	gtk_widget_show_all(win);
}
	
	
		
