/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*---- This creates the main display window consisting of the test button ----------*/
GtkWidget* create_main_window(void)
{
	PangoFontDescription *smallfont;
	smallfont=pango_font_description_from_string("swissa 12");
	main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(main_window),60);
	        
        box1=gtk_vbox_new(FALSE,0);
	hbox1=gtk_hbox_new(FALSE,0);
	hbox2=gtk_hbox_new(FALSE,0);
	stk_hbox=gtk_hbox_new(FALSE,0);

	test_button=gtk_button_new();	
//	gtk_widget_set_sensitive(GTK_WIDGET(test_button), FALSE);
	gtk_button_set_label(GTK_BUTTON(test_button),"Test Button");
	gtk_widget_set_usize(GTK_WIDGET(test_button),170,40);
	label=gtk_label_new("");
	gtk_widget_modify_font(GTK_WIDGET(label),smallfont);
	property_button=gtk_button_new_with_mnemonic("Set & Get Properties");

	/*---------------To test button from stock-----------------------*/
	stk_button=gtk_button_new_from_stock(GTK_STOCK_HOME);

	close_button=gtk_button_new_with_label(" Quit ");

	g_signal_connect(G_OBJECT(close_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(property_button),"clicked",G_CALLBACK(properties_callback),NULL);
	g_signal_connect(G_OBJECT(test_button),"pressed",G_CALLBACK(press_callback),NULL);
	g_signal_connect(G_OBJECT(test_button),"clicked",G_CALLBACK(click_callback),NULL);
	g_signal_connect(G_OBJECT(test_button),"released",G_CALLBACK(release_callback),NULL);
	g_signal_connect(G_OBJECT(test_button),"enter",G_CALLBACK(enter_callback),NULL);
	g_signal_connect(G_OBJECT(test_button),"leave",G_CALLBACK(leave_callback),NULL);
	g_signal_connect(G_OBJECT(stk_button),"clicked",G_CALLBACK(view_test),NULL);

	/*-----insensitivity-------*/
	g_signal_connect(G_OBJECT(test_button), "insensitive_press", G_CALLBACK(insen), NULL);

	/*------------------------PACKING----------------------------*/
	gtk_box_pack_start(GTK_BOX(hbox1),test_button,FALSE,FALSE,15);
	gtk_box_pack_start(GTK_BOX(hbox1),label,FALSE,FALSE,15);
	gtk_box_pack_start(GTK_BOX(box1),hbox1,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(stk_hbox),stk_button,FALSE,FALSE,15);
	gtk_box_pack_start(GTK_BOX(box1),stk_hbox,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox2),property_button,FALSE,FALSE,15);
	gtk_box_pack_start(GTK_BOX(hbox2),close_button,FALSE,FALSE,15);
	gtk_box_pack_start(GTK_BOX(box1),hbox2,FALSE,FALSE,5);
		
	gtk_container_add(GTK_CONTAINER(main_window),box1);

	gtk_widget_show_all(main_window);
	pango_font_description_free(smallfont);
}
