/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

gint align_flag_tmp=0;
gint stock_flag=0;

void insen(GtkButton *button, gpointer data)
{
	g_print("Insensitive button");
	gtk_infoprint(main_window, "Insensitive button");
}

void properties_callback(GtkButton *b, gpointer user_data)
{

	PangoFontDescription *smallfont;
	smallfont=pango_font_description_from_string("swissa 14");

	back_button=gtk_button_new_with_mnemonic("_Back");
	gtk_widget_set_size_request(GTK_WIDGET(back_button),160,50);
	g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(back_callback),NULL);

	box2=gtk_vbox_new(FALSE,0);
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	box3=gtk_hbox_new(FALSE,0);
	box4=gtk_hbox_new(FALSE,0);
	box5=gtk_hbox_new(FALSE,0);
	box6=gtk_hbox_new(FALSE,0);

	set_label=gtk_label_new("Select:");

	/*OPTION MENU for setting the test button properties*/	
	
	set_menu=gtk_option_menu_new();
        gtk_widget_set_usize(GTK_WIDGET(set_menu), 200, 40); 
	menu=gtk_menu_new();
	
	menu_item=gtk_menu_item_new_with_label("Set Label");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Mnemonic");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Add Button to Stock");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Alignment");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set button Pressed");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Button Released");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Button Clicked");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Button Enter");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Button Leave");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Relief NONE");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Relief HALF");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Relief NORMAL");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	gtk_option_menu_set_menu(GTK_OPTION_MENU(set_menu),menu);


	set_button=gtk_button_new_with_label("Set");

	/*Callbacks for Set Properties*/
	g_signal_connect(G_OBJECT(set_menu),"changed",G_CALLBACK(set_menu_callback),NULL);
	g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_button_callback),NULL);


	get_label=gtk_label_new("Select:");

	/*OPTION MENU for getting the button properties*/
	
	get_menu=gtk_option_menu_new();
	menu=gtk_menu_new();
	gtk_widget_set_usize(GTK_WIDGET(get_menu),200,40);

        menu_item=gtk_menu_item_new_with_label("Get Label");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Get Mnemonic");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Is Button from Stock");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Check Focus on Click");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Get Alignment");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Get Relief Style");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	gtk_option_menu_set_menu(GTK_OPTION_MENU(get_menu),menu);

        get_button=gtk_button_new_with_label("Get");

	/* To check focus on click*/	
	gtk_button_set_focus_on_click(GTK_BUTTON(get_button),FALSE);

	get_entry=gtk_entry_new();
	gtk_widget_modify_font(GTK_WIDGET(get_entry),smallfont);

	gtk_option_menu_set_history(GTK_OPTION_MENU(set_menu),0);	
	gtk_option_menu_set_history(GTK_OPTION_MENU(get_menu),0);


	button_response_label=gtk_label_new("Button Response: ");
	result=gtk_label_new("");
	
	/*Callbacks for Get Properies*/
	g_signal_connect(G_OBJECT(get_menu),"changed",G_CALLBACK(get_menu_callback),NULL);
	g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_button_callback),NULL);


	gtk_box_pack_start(GTK_BOX(box2),box3,FALSE,FALSE,5);	
	gtk_box_pack_start(GTK_BOX(box3),set_label,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(box3),set_menu,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(box3),set_button,FALSE,FALSE,10);

	gtk_box_pack_start(GTK_BOX(box2),box4,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(box4),get_label,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(box4),get_menu,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(box4),get_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(box4),get_entry,FALSE,FALSE,10);
	
	gtk_box_pack_start(GTK_BOX(box2),box5,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(box5),back_button,FALSE,FALSE,20);

	gtk_box_pack_start(GTK_BOX(box2),box6,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(box6),button_response_label,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(box6),result,FALSE,FALSE,20);
	
	gtk_container_add(GTK_CONTAINER(window),box2);
	gtk_widget_show_all(window);
	gtk_widget_hide(main_window);
	
}

/*----Callback for the option menu of SET--------*/
void set_menu_callback(GtkOptionMenu *o,gpointer user_data)
{
	set_menu_index=gtk_option_menu_get_history(o);

}

/*------Callback for the button SET-------*/
void set_button_callback(GtkButton *b,gpointer user_data)
{
	gtk_label_set_text(GTK_LABEL(result),"");
	switch(set_menu_index)
	{
		case 0:	gtk_button_set_label(GTK_BUTTON(test_button),"C_lickMe");
			gtk_widget_hide(window);
			gtk_widget_show(main_window);
			 gtk_label_set_text(GTK_LABEL(label),"");
			break;
		case 1: gtk_button_set_use_underline(GTK_BUTTON(test_button),TRUE);
			gtk_widget_hide(window);
			gtk_widget_show(main_window);
         		gtk_label_set_text(GTK_LABEL(label),"");
			break;
		case 2: gtk_button_set_use_stock(GTK_BUTTON(test_button),TRUE);
			gtk_label_set_text(GTK_LABEL(label),"Button added to stock");
			gtk_widget_hide(window);
			gtk_widget_show(main_window);
			break;
		case 3: align_flag_tmp=1;
			gtk_button_set_alignment(GTK_BUTTON(test_button),0.0,0.0);
			gtk_widget_hide(window);
			gtk_widget_show(main_window);
        		gtk_label_set_text(GTK_LABEL(label),"");
			break;
		case 4: gtk_button_pressed(GTK_BUTTON(test_button));
			gtk_label_set_text(GTK_LABEL(result),"PRESSED");
	                gtk_label_set_text(GTK_LABEL(label),"");	
			gtk_widget_show(window);
			break;
		case 5: gtk_button_released(GTK_BUTTON(test_button));
			gtk_label_set_text(GTK_LABEL(result),"RELEASED");
			gtk_widget_show(window);
          		gtk_label_set_text(GTK_LABEL(label),"");
			break;
		case 6: gtk_button_clicked(GTK_BUTTON(test_button));
			gtk_label_set_text(GTK_LABEL(result),"CLICKED");
			gtk_widget_show(window);
			gtk_label_set_text(GTK_LABEL(label),"");
			break;
		case 7: gtk_button_enter(GTK_BUTTON(test_button));
			gtk_label_set_text(GTK_LABEL(result),"ENTER");
			gtk_widget_show(window);
			gtk_label_set_text(GTK_LABEL(label),"");
			break;
		case 8: gtk_button_leave(GTK_BUTTON(test_button));
			gtk_label_set_text(GTK_LABEL(result),"LEAVE");
			gtk_widget_show(window);
			gtk_label_set_text(GTK_LABEL(label),"");
			break;	
		case 9: gtk_button_set_relief(GTK_BUTTON(test_button),GTK_RELIEF_NONE);
			gtk_widget_hide(window);
			gtk_widget_show(main_window);
			gtk_label_set_text(GTK_LABEL(label),"");
                        break;
		case 10:gtk_button_set_relief(GTK_BUTTON(test_button),GTK_RELIEF_HALF);
			gtk_widget_hide(window);
			gtk_widget_show(main_window);
			gtk_label_set_text(GTK_LABEL(label),"");
			break;
		case 11:gtk_button_set_relief(GTK_BUTTON(test_button),GTK_RELIEF_NORMAL);
			gtk_widget_hide(window);
			gtk_widget_show(main_window);
			gtk_label_set_text(GTK_LABEL(label),"");
			break;
	}
}

/*----Callback for the option menu of GET--------*/
void get_menu_callback(GtkOptionMenu *o,gpointer user_data)
{
	get_menu_index=gtk_option_menu_get_history(o);
}

/*----Callback for the button GET---------*/
void get_button_callback(GtkButton *b,gpointer user_data)
{
	gchar *text;
	gboolean value;
	GtkReliefStyle g;
	gchar t[25]="x:";
	gfloat x,y;
	gfloat xalign,yalign;
	gchar str[10];
	switch(get_menu_index)
        {
                case 0: text=gtk_button_get_label(GTK_BUTTON(test_button));
			if(text!=NULL)
			gtk_entry_set_text(GTK_ENTRY(get_entry),text);
			else
			gtk_entry_set_text(GTK_ENTRY(get_entry),"");
                        break;
                case 1: value=gtk_button_get_use_underline(GTK_BUTTON(test_button));
			if(value==TRUE)
			gtk_entry_set_text(GTK_ENTRY(get_entry),"TRUE");
			else
			gtk_entry_set_text(GTK_ENTRY(get_entry),"FALSE");
                        break;
		case 2: value=gtk_button_get_use_stock(GTK_BUTTON(test_button));
			if(value==TRUE)
			gtk_entry_set_text(GTK_ENTRY(get_entry),"TRUE");
			else
			gtk_entry_set_text(GTK_ENTRY(get_entry),"FALSE");
			break;
		case 3: value=gtk_button_get_focus_on_click(GTK_BUTTON(get_button));
			if(value==TRUE)
                        gtk_entry_set_text(GTK_ENTRY(get_entry),"TRUE");
                        else
                        gtk_entry_set_text(GTK_ENTRY(get_entry),"FALSE");
                        break;
		case 4: if(align_flag_tmp==1)
			{
			gtk_button_get_alignment(GTK_BUTTON(test_button),&xalign,&yalign);
			gtk_entry_set_text(GTK_ENTRY(get_entry),t);
			sprintf(str,"%.1f",xalign);
			gtk_entry_append_text(GTK_ENTRY(get_entry),str);
			gtk_entry_append_text(GTK_ENTRY(get_entry)," y:");
			sprintf(str,"%.1f",yalign);
			gtk_entry_append_text(GTK_ENTRY(get_entry),str);
			break;
			}
			else
			{
			gtk_entry_set_text(GTK_ENTRY(get_entry),"Alignment not set!");
			break;
			}
		case 5: g=gtk_button_get_relief(GTK_BUTTON(test_button));
                        if(g==0)
                        gtk_entry_set_text(GTK_ENTRY(get_entry),"NORMAL");
                        else if(g==1)
                        gtk_entry_set_text(GTK_ENTRY(get_entry),"HALF");
                        else if(g==2)
                        gtk_entry_set_text(GTK_ENTRY(get_entry),"NONE");
                        break;
        }
}

/*----------Goes to the previous window-----------*/
void back_callback(GtkButton *b,gpointer user_data)
{
	gtk_widget_hide(window);
	gtk_widget_show(main_window);
	gtk_label_set_text(GTK_LABEL(label),"");
}

/*-------Callbacks for the signals associated with the button-------------*/

void press_callback(GtkButton *b,gpointer user_data)
{
	gtk_label_set_text(GTK_LABEL(label),"BUTTON PRESSED");
}

void release_callback(GtkButton *b,gpointer user_data)
{
	gtk_label_set_text(GTK_LABEL(label),"BUTTON RELEASED");
}

void click_callback(GtkButton *b,gpointer user_data)
{
	gtk_label_set_text(GTK_LABEL(label),"BUTTON CLICKED");
}

void enter_callback(GtkButton *b,gpointer user_data)
{
	gtk_label_set_text(GTK_LABEL(label),"ENTER EVENT CAPTURED");
}

void leave_callback(GtkButton *b,gpointer user_data)
{
 	gtk_label_set_text(GTK_LABEL(label),"LEAVE EVENT CAPTURED");
}

/*-------------To test the click on button from STOCK------------*/
void view_test(GtkButton *b,gpointer data)
{
	gtk_label_set_text(GTK_LABEL(label)," HOME CLICKED");
}
