/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

void main_window()
{
	
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(window), 10);

	vbox=gtk_vbox_new(FALSE, 20);
	hbox=gtk_hbox_new(FALSE, 0);


	frame=gtk_frame_new("");
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);

	/*------Creates Gdk PixbufAnimation-------*/
	gdk_animation=gdk_pixbuf_animation_new_from_file("Alligator-02.gif", error);
	image=gtk_image_new_from_animation(GDK_PIXBUF_ANIMATION(gdk_animation));
	gtk_box_pack_start(GTK_BOX(vbox), image, FALSE, 0, 100);

	Bprop=gtk_button_new_with_label("Properties");
	gtk_widget_set_usize(GTK_WIDGET(Bprop), 200, 40);
	gtk_box_pack_start(GTK_BOX(hbox), Bprop, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(Bprop), "clicked", GTK_SIGNAL_FUNC(on_prop), NULL);

	Bexit=gtk_button_new_with_label("Exit");
	gtk_widget_set_usize(GTK_WIDGET(Bexit), 200, 40);
        gtk_box_pack_end(GTK_BOX(hbox), Bexit, FALSE, 0, 0);
        gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, 0, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", GTK_SIGNAL_FUNC(on_exit), NULL);

	gtk_container_add(GTK_CONTAINER(window), frame);
	gtk_widget_show_all(window);
}
