/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

/*-----On clicking "BACK" button, you return to the main window-----*/
void on_back(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(sec_win);
	gtk_widget_show(window);
}
/*-----On clicking "Exit" button, quit the main funcationa and exit from the application-----*/
void on_exit(GtkWidget *button, gpointer data)
{
	gtk_main_quit();	
}

/*------On clicking "Properties" button, a window with properties assosiated with GdkPixbufanimation is diplayed-----*/
void on_prop(GtkWidget *button, gpointer data)
{
	gchar val[20];
	sec_win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(sec_win), 10);

	shbox=gtk_hbox_new(FALSE, 0);
	shbox1=gtk_hbox_new(FALSE, 0);
	shbox2=gtk_hbox_new(FALSE, 0);
	shbox3=gtk_hbox_new(FALSE, 0);
	shbox4=gtk_hbox_new(FALSE, 0);
	svbox=gtk_vbox_new(FALSE, 0);
	svbox1=gtk_vbox_new(FALSE, 0);
	svbox2=gtk_vbox_new(FALSE, 0);

	frame1=gtk_frame_new("Properties ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame1), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame1), 0.5, 0.5);
	gtk_container_add(GTK_CONTAINER(sec_win), frame1);

	Lwidth=gtk_label_new("Width         :");
	gtk_box_pack_start(GTK_BOX(shbox), Lwidth, FALSE, 0, 10);

	int i=gdk_pixbuf_animation_get_width(GDK_PIXBUF_ANIMATION(gdk_animation));
	sprintf(val, "%i", i);
	Lwidth_val=gtk_label_new(val);
	gtk_box_pack_start(GTK_BOX(shbox), Lwidth_val, FALSE, 0, 10);

	gchar first[20]="Height        :   ";
	i=gdk_pixbuf_animation_get_height(GDK_PIXBUF_ANIMATION(gdk_animation));
	sprintf(val, "%i", i);
	strcat(first, val);
	Lheight_val=gtk_label_new(first);
	gtk_box_pack_start(GTK_BOX(shbox3), Lheight_val, FALSE, 0, 10);

	Ldelay=gtk_label_new("Delay Time:");
        gtk_box_pack_start(GTK_BOX(shbox4), Ldelay, FALSE, 0, 10);
		
	iter=gdk_pixbuf_animation_get_iter(GDK_PIXBUF_ANIMATION(gdk_animation), NULL);
	i=gdk_pixbuf_animation_iter_get_delay_time(iter);
	sprintf(val, "%i", i);
	Ldelay_val=gtk_label_new(val);
	gtk_box_pack_start(GTK_BOX(shbox4), Ldelay_val, FALSE, 0, 10);

	int j=gdk_pixbuf_animation_iter_advance(iter, NULL);
	if(j == 0)
		Liter=gtk_label_new("Iter Advance? FALSE");
	else
		Liter=gtk_label_new("Iter Advance? TRUE");
	gtk_box_pack_end(GTK_BOX(shbox), Liter, FALSE, 0, 10);

	j=gdk_pixbuf_animation_iter_on_currently_loading_frame(iter);
	if(j == 0)
		Lload=gtk_label_new("Currently Loading Frame? FALSE");
	else
		Lload=gtk_label_new("Currently Loading Frame? TRUE");
	gtk_box_pack_end(GTK_BOX(shbox3), Lload, FALSE, 0, 10);

	pixbuf=gdk_pixbuf_animation_get_static_image(GDK_PIXBUF_ANIMATION(gdk_animation));
	pixbuf_image=gtk_image_new_from_pixbuf(pixbuf);
	gtk_box_pack_start(GTK_BOX(svbox1), pixbuf_image, FALSE, 0, 0);

	Lpixbuf=gtk_label_new("Static Image");
	gtk_box_pack_start(GTK_BOX(svbox1), Lpixbuf, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(shbox2), svbox1, FALSE, 0, 0);

	first[20]="Is the image static?";
	i=gdk_pixbuf_animation_is_static_image(GDK_PIXBUF_ANIMATION(gdk_animation));
	if( i == 0 )
		Limage=gtk_label_new("Is the image static? FALSE");
	else
		Limage=gtk_label_new("Is the image static? TRUE");
		
	gtk_box_pack_end(GTK_BOX(shbox4), Limage, FALSE, 0, 10);

	pixbuf=gdk_pixbuf_animation_iter_get_pixbuf(iter);
	pixbuf_image2=gtk_image_new_from_pixbuf(pixbuf);
	gtk_box_pack_start(GTK_BOX(svbox2), pixbuf_image2, FALSE, 0, 0);

	Lpix=gtk_label_new("Pixbuf  ");
	gtk_box_pack_start(GTK_BOX(svbox2),Lpix, FALSE, 0, 0);
	gtk_box_pack_end(GTK_BOX(shbox2), svbox2, FALSE, 0, 0);

	Bback=gtk_button_new_with_label("BACK");
	gtk_widget_set_usize(Bback, 200, 40);
	gtk_box_pack_end(GTK_BOX(shbox1), Bback, FALSE, 0, 0);
	gtk_box_pack_end(GTK_BOX(svbox), shbox1, FALSE, 0, 0);	
	gtk_signal_connect(GTK_OBJECT(Bback), "clicked", GTK_SIGNAL_FUNC(on_back), NULL);
	
	
	

	
	gtk_box_pack_start(GTK_BOX(svbox), shbox, FALSE, 0, 10);
	gtk_box_pack_start(GTK_BOX(svbox), shbox3, FALSE, 0, 10);
	gtk_box_pack_start(GTK_BOX(svbox), shbox4, FALSE, 0, 10);
	gtk_box_pack_start(GTK_BOX(svbox), shbox2, FALSE, 0, 10);
	gtk_container_add(GTK_CONTAINER(frame1), svbox);

	g_object_unref(iter);
	gtk_widget_show_all(sec_win);
	
}


