#include <config.h>
#include <string.h>
#include <stdlib.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-volume.h>
#include <libgnomevfs/gnome-vfs-volume-monitor.h>

static void
volume_mounted_cb (GnomeVFSVolumeMonitor *monitor,
		   GnomeVFSVolume        *volume,
		   gpointer              user_data)
{
	g_print ("Volume mounted: %s\n",
		 gnome_vfs_volume_get_display_name (volume));
}

static void
volume_unmounted_cb (GnomeVFSVolumeMonitor *monitor,
		     GnomeVFSVolume        *volume,
		     gpointer              user_data)
{
	g_print ("Volume unmounted: %s\n",
		 gnome_vfs_volume_get_display_name (volume));
}

static void
drive_connected_cb (GnomeVFSVolumeMonitor *monitor,
		    GnomeVFSDrive         *drive,
		    gpointer               user_data)
{
	g_print ("Drive connected: %s\n",
		 gnome_vfs_drive_get_display_name (drive));
}

static void
drive_disconnected_cb (GnomeVFSVolumeMonitor *monitor,
		       GnomeVFSDrive         *drive,
		       gpointer               user_data)
{
	g_print ("Drive disconnected: %s\n",
		 gnome_vfs_drive_get_display_name (drive));
}

static void
mount_cb (gboolean  succeeded,
	  gchar    *error,
	  gchar    *detailed_error,
	  gpointer  data)
{
	GMainLoop *loop;

	loop = data;
	
	if (!succeeded) {
		g_print ("Error (un)mounting: %s\n", error);
	}

	g_main_loop_quit (loop);
}

int
main (int argc, char *argv[])
{
	GnomeVFSVolumeMonitor *monitor;
	GList                 *volumes, *l;
	GList                 *drives;
	GnomeVFSVolume        *volume;
	GnomeVFSDrive         *drive;
	GMainLoop             *loop;
	const char            *mount_dev;

	gnome_vfs_init ();

	loop = g_main_loop_new (NULL, FALSE);

	mount_dev = NULL;
	if (argc > 1) {
		mount_dev = argv[1];

		if (strncmp (mount_dev, "/dev/", 5) != 0) {
			mount_dev = NULL;
		}
	}
	
	monitor = gnome_vfs_get_volume_monitor ();	

	if (1) {
		drives = gnome_vfs_volume_monitor_get_connected_drives (monitor);
		g_print ("%d connected drives:\n", g_list_length (drives));
		
		for (l = drives; l; l = l->next) {
			drive = l->data;

			g_print ("  %s\n", gnome_vfs_drive_get_display_name (drive));
		}
		if (drives) {
			g_print ("---\n");
		}
		
		volumes = gnome_vfs_volume_monitor_get_mounted_volumes (monitor);
		g_print ("%d mounted volumes:\n", g_list_length (volumes));
		
		for (l = volumes; l; l = l->next) {
			volume = l->data;
			
			g_print ("  %s\n", gnome_vfs_volume_get_display_name (volume));
		}
		if (volumes) {
			g_print ("---\n");
		}
	}

	g_signal_connect (monitor,
			  "volume_mounted",
			  G_CALLBACK (volume_mounted_cb),
			  NULL);

	g_signal_connect (monitor,
			  "volume_unmounted",
			  G_CALLBACK (volume_unmounted_cb),
			  NULL);

	g_signal_connect (monitor,
			  "drive_connected",
			  G_CALLBACK (drive_connected_cb),
			  NULL);

	g_signal_connect (monitor,
			  "drive_disconnected",
			  G_CALLBACK (drive_disconnected_cb),
			  NULL);

	drives = gnome_vfs_volume_monitor_get_connected_drives (monitor);
	for (l = drives; l; l = l->next) {
		gboolean mounted;

		drive = l->data;

		if (mount_dev && strcmp (gnome_vfs_drive_get_device_path (drive), mount_dev) == 0) {
			mounted = gnome_vfs_drive_is_mounted (drive);

			g_print ("Drive: %s %s\n", gnome_vfs_drive_get_display_name (drive),
				 mounted ? "(mounted)" : "(unmounted)");

			if (!mounted) {
				gnome_vfs_drive_mount (drive, mount_cb, loop);
				g_main_loop_run (loop);
			} else {
				gnome_vfs_drive_unmount (drive, mount_cb, loop);
				g_main_loop_run (loop);
			}
			
			break;
		}
	}

	g_print ("Listening to drive/volume signals.\n");
	
	g_main_loop_run (loop);
	
	g_object_unref (monitor);

	return 0;
}

