/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2004 Nokia. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __DBUS_UTILS_H__
#define __DBUS_UTILS_H__

#include <libgnomevfs/gnome-vfs.h>

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus-glib-lowlevel.h>


#define DVD_DAEMON_SERVICE                          "com.nokia.GnomeVFS.Daemon"
#define DVD_DAEMON_OBJECT                           "/com/nokia/GnomeVFS/Daemon"
#define DVD_DAEMON_INTERFACE                        "com.nokia.GnomeVFS.Daemon"

/* File monitoring signal. */
#define DVD_DAEMON_MONITOR_SIGNAL                   "MonitorSignal"

#define DVD_DAEMON_METHOD_GET_CONNECTION            "GetConnection"

/* File ops methods. */
#define DVD_DAEMON_METHOD_OPEN                      "Open"
#define DVD_DAEMON_METHOD_CREATE                    "Create"
#define DVD_DAEMON_METHOD_READ                      "Read"
#define DVD_DAEMON_METHOD_WRITE                     "Write"
#define DVD_DAEMON_METHOD_CLOSE                     "Close"

#define DVD_DAEMON_METHOD_SEEK                      "Seek"
#define DVD_DAEMON_METHOD_TELL                      "Tell"

#define DVD_DAEMON_METHOD_TRUNCATE_HANDLE           "TruncateHandle"

#define DVD_DAEMON_METHOD_OPEN_DIRECTORY            "OpenDirectory"
#define DVD_DAEMON_METHOD_CLOSE_DIRECTORY           "CloseDirectory"
#define DVD_DAEMON_METHOD_READ_DIRECTORY            "ReadDirectory"

#define DVD_DAEMON_METHOD_GET_FILE_INFO             "GetFileInfo"
#define DVD_DAEMON_METHOD_GET_FILE_INFO_FROM_HANDLE "GetFileInfoFromHandle"

#define DVD_DAEMON_METHOD_IS_LOCAL                  "IsLocal"
#define DVD_DAEMON_METHOD_MAKE_DIRECTORY            "MakeDirectory"
#define DVD_DAEMON_METHOD_REMOVE_DIRECTORY          "RemoveDirectory"

#define DVD_DAEMON_METHOD_MOVE                      "Move"
#define DVD_DAEMON_METHOD_UNLINK                    "Unlink"
#define DVD_DAEMON_METHOD_CHECK_SAME_FS             "CheckSameFs"
#define DVD_DAEMON_METHOD_SET_FILE_INFO             "SetFileInfo"
#define DVD_DAEMON_METHOD_TRUNCATE                  "Truncate"
#define DVD_DAEMON_METHOD_FIND_DIRECTORY            "FindDirectory"
#define DVD_DAEMON_METHOD_CREATE_SYMBOLIC_LINK      "CreateSymbolicLink"

#define DVD_DAEMON_METHOD_MONITOR_ADD               "MonitorAdd"
#define DVD_DAEMON_METHOD_MONITOR_CANCEL            "MonitorCancel"

#define DVD_DAEMON_METHOD_CANCEL                    "Cancel"

/* Volume monitor methods. */
#define DVD_DAEMON_METHOD_REGISTER_VOLUME_MONITOR   "RegisterVolumeMonitor"
#define DVD_DAEMON_METHOD_DEREGISTER_VOLUME_MONITOR "DeregisterVolumeMonitor"
#define DVD_DAEMON_METHOD_GET_VOLUMES               "GetVolumes"
#define DVD_DAEMON_METHOD_GET_DRIVES                "GetDrives"
#define DVD_DAEMON_METHOD_EMIT_PRE_UNMOUNT_VOLUME   "EmitPreUnmountVolume"
#define DVD_DAEMON_METHOD_FORCE_PROBE               "ForceProbe"

/* Volume monitor signals. */
#define DVD_DAEMON_VOLUME_MOUNTED_SIGNAL            "VolumeMountedSignal"
#define DVD_DAEMON_VOLUME_UNMOUNTED_SIGNAL          "VolumeUnmountedSignal"
#define DVD_DAEMON_VOLUME_PRE_UNMOUNT_SIGNAL        "VolumePreUnmountSignal"
#define DVD_DAEMON_DRIVE_CONNECTED_SIGNAL           "DriveConnectedSignal"
#define DVD_DAEMON_DRIVE_DISCONNECTED_SIGNAL        "DriveDisconnectedSignal"


/* Errors. */
#define DVD_ERROR_FAILED            "com.nokia.GnomeVFS.Daemon.Error.Failed"
#define DVD_ERROR_SOCKET_FAILED     "com.nokia.GnomeVFS.Error.SocketFailed"


/* Note: It could make sense to have DVD_TYPE_FILE_SIZE and FILE_OFFSET instead
 * of the 64 bits variants.
 */
typedef enum {
	DVD_TYPE_LAST = -1,
	DVD_TYPE_URI,
	DVD_TYPE_STRING,
	DVD_TYPE_INT32,
	DVD_TYPE_INT64,
	DVD_TYPE_UINT64,
	DVD_TYPE_FILE_INFO,
	DVD_TYPE_BOOL,
	DVD_TYPE_BYTE_ARRAY
} DvdArgumentType;


gboolean 
dbus_utils_message_iter_append_file_info       (DBusMessageIter        *iter,
						const GnomeVFSFileInfo *info);
gboolean dbus_utils_message_append_file_info   (DBusMessage            *message,
						const GnomeVFSFileInfo *info);
GnomeVFSFileInfo *
dbus_utils_message_iter_get_file_info          (DBusMessageIter        *dict);
GList *  dbus_utils_message_get_file_info_list (DBusMessage            *message);


void dbus_utils_message_append_volume_list (DBusMessage *message, GList *volumes);
void dbus_utils_message_append_drive_list  (DBusMessage *message, GList *drives);

void dbus_utils_message_append_volume      (DBusMessage *message, GnomeVFSVolume *volume);
void dbus_utils_message_append_drive       (DBusMessage *message, GnomeVFSDrive  *drive);


#endif /* __DBUS_UTILS_H__ */
