/**************************************************************************************
Project:                OSSO

File Name:              osso_case_in.h

Version:                1.0

Date:                   28/04/2004

Author / Copyright:     NOKIA

**************************************************************************************/

#ifndef __OSSO_CASE_IN_H__
#define __OSSO_CASE_IN_H__

#define DELIMITER '/'
#define DELIMITERSTR "/"
#define CURRENT_DIR "."
#define PARENT_DIR ".."
#define MAX_LEN 256 

enum {
	OSSO_CASE_PATH_EXIST,
	OSSO_CASE_PATH_DOESNOT_EXIST,
	OSSO_CASE_DELIMITERSTR_ERROR,
	OSSO_CASE_CURRENTDIR_ERROR
} OSSO_Error;

int osso_get_existing_file (gchar *file, 
		const gchar *directorypath);

int osso_get_existing_path (gchar* path);

int osso_get_existing_path_offset (gchar* path, 
		gchar *existing_path, 
		int *offset);

int osso_file_list_validate (const GList *filelist, 
		const gchar *directorypath);

void debug_print(const gchar *format, ...);

void get_substring(gchar *source, 
		gchar *destination, 
		gint index, gint count);

int osso_fetch_path(gchar* path);

/*! Method to check if the path specified exist.
 *  \param path path of file/folder
 *  \return true if file exist
 * */
gboolean
osso_is_path_exists (const gchar *file, const gchar* directorypath);

int 
osso_get_existing_file2 (gchar *file, 
		const gchar *directorypath);

int osso_get_existing_path2 (gchar* path);

int osso_get_existing_path3 (gchar* path);

#endif

