/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2004 Nokia. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GNOME_VFS_DBUS_UTILS_H
#define GNOME_VFS_DBUS_UTILS_H

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS

/* Note: Temporary, there will only be one copy of these when the daemon is
 * moved into gnome-vfs.
 */

#define DVD_DAEMON_SERVICE                          "com.nokia.GnomeVFS.Daemon"
#define DVD_DAEMON_OBJECT                           "/com/nokia/GnomeVFS/Daemon"
#define DVD_DAEMON_INTERFACE                        "com.nokia.GnomeVFS.Daemon"

/* Volume monitor methods. */
#define DVD_DAEMON_METHOD_REGISTER_VOLUME_MONITOR   "RegisterVolumeMonitor"
#define DVD_DAEMON_METHOD_DEREGISTER_VOLUME_MONITOR "DeregisterVolumeMonitor"
#define DVD_DAEMON_METHOD_GET_VOLUMES               "GetVolumes"
#define DVD_DAEMON_METHOD_GET_DRIVES                "GetDrives"
#define DVD_DAEMON_METHOD_EMIT_PRE_UNMOUNT_VOLUME   "EmitPreUnmountVolume"
#define DVD_DAEMON_METHOD_FORCE_PROBE               "ForceProbe"

/* Volume monitor signals. */
#define DVD_DAEMON_VOLUME_MOUNTED_SIGNAL            "VolumeMountedSignal"
#define DVD_DAEMON_VOLUME_UNMOUNTED_SIGNAL          "VolumeUnmountedSignal"
#define DVD_DAEMON_VOLUME_PRE_UNMOUNT_SIGNAL        "VolumePreUnmountSignal"
#define DVD_DAEMON_DRIVE_CONNECTED_SIGNAL           "DriveConnectedSignal"
#define DVD_DAEMON_DRIVE_DISCONNECTED_SIGNAL        "DriveDisconnectedSignal"

G_END_DECLS

#endif /* GNOME_VFS_DBUS_UTILS_H */
