USER_NAME=bijjal
BIN=/usr/bin
TEST_APP=$BIN/gtk_infoprint
XNEE=$BIN/xnee


echo "Running valgrind once ..."
valgrind -v --leak-check=yes --num-callers=50 --logfile=/home/$USER_NAME/test/logs/autom $TEST_APP&
sleep 45s
echo "Running xnee once..."
$XNEE --replay --display :1 -f /home/bijjal/test/recordings/reg2.xnee
LATEST1=`ls autom.pid* --sort=time | head -n 1 | cut -d " " -f 1`
mv /home/$USER_NAME/$LATEST1 /home/$USER_NAME/test/logs/autom.reference
echo "Running valgrind twice..."
valgrind -v --leak-check=yes --num-callers=50 --logfile=/home/$USER_NAME/autom $TEST_APP&
sleep 45s
echo "Running xnee twice.."
$XNEE --replay --display :1 -f /home/bijjal/test/recordings/reg2.xnee
LATEST2=`ls autom.pid* --sort=time | head -n 1 | cut -d " " -f 1`
mv /home/$USER_NAME/$LATEST2 /home/$USER_NAME/test/logs/
echo "Comparing log files..."
python /home/$USER_NAME/teema4/teema4-tools/valdiff/valdiff.py -s --no-unfreed-fatal /home/$USER_NAME/test/logs/autom.reference /home/$USER_NAME/test/logs/$LATEST2 >> /home/$USER_NAME/test/valdiff_output

echo "COMPLETE. Result in /test/valdiff_output"




