#include <glib.h>
#include <config.h>
#include <libgnomevfs/gnome-vfs-init.h>
#include <libgnomevfs/gnome-vfs-ops.h>

#include <stdio.h>
#include <stdlib.h>

#include <string.h>


static gboolean
show_if_error (GnomeVFSResult result, const char *what, const char *what2)
{
	if (result != GNOME_VFS_OK) {
		fprintf (stderr, "%s%s `%s'\n",
				what, what2, gnome_vfs_result_to_string (result));
		return TRUE;
	} else
		return FALSE;
}

static void
show_result (GnomeVFSResult result, const gchar *what, const gchar *text_uri)
{
	fprintf (stderr, "%s `%s': %s\n",
			what, text_uri, gnome_vfs_result_to_string (result));
		
	if (result != GNOME_VFS_OK)
		exit (1);
}

int
create (gchar *file)
{

	GnomeVFSResult   result;
	GnomeVFSHandle   *handle;

	GnomeVFSFileSize  bytes_written;
	const gchar      *buf;
	        
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}
         
	printf ("\nEnter the file Name (to create): ");
	scanf ("%s", file);

	result = gnome_vfs_create (&handle,
				       file,
				       GNOME_VFS_OPEN_WRITE,
				       FALSE, 0600);
	show_result (result, "create", file);

	buf = "test create";
	
	result = gnome_vfs_write (handle,
				  buf,
				  strlen (buf),
				  &bytes_written);
	show_result (result, "write", file);

	result = gnome_vfs_close (handle);
	show_result (result, "close_write", file);


        result = gnome_vfs_open (&handle, file, GNOME_VFS_OPEN_READ);
	show_result (result, "open_read", file);

	while (1) {
		GnomeVFSFileSize bytes_read;
		guint8           data [1025];
		
		result = gnome_vfs_read (handle, data, 1024, &bytes_read);
		
		if (show_if_error (result, "read ", file))
			break;
		
		if (bytes_read == 0)
			break;
		
		if (bytes_read >  0 &&
				bytes_read <= 1024)
			data [bytes_read] = '\0';
		else {
			data [1024] = '\0';
			g_warning ("Wierd error from vfs_read");
		}
		fprintf (stdout, "\n%s\n", data);
	}
          
	result = gnome_vfs_close (handle);
	show_result (result, "close", file);
	
	gnome_vfs_shutdown ();

	return 0;
	
}

int
open_read (gchar *file)
{

	GnomeVFSResult   result;
	GnomeVFSHandle   *handle;

	        
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}

         
	printf ("\nEnter the file Name (to read): ");
	scanf ("%s", file);
		
        result = gnome_vfs_open (&handle, file, GNOME_VFS_OPEN_READ);
	show_result (result, "open_read", file);

	while (1) {
		GnomeVFSFileSize bytes_read;
		guint8           data [1025];
		
		result = gnome_vfs_read (handle, data, 1024, &bytes_read);
		
		if (show_if_error (result, "read ", file))
			break;
		
		if (bytes_read == 0)
			break;
		
		if (bytes_read >  0 &&
				bytes_read <= 1024)
			data [bytes_read] = '\0';
		else {
			data [1024] = '\0';
			g_warning ("Wierd error from vfs_read");
		}
		fprintf (stdout, "\n%s\n", data);
	}
	          
	result = gnome_vfs_close (handle);
	show_result (result, "close", file);
	
	gnome_vfs_shutdown ();

	return 0;
	
}

int
open_write (gchar *file)
{

	GnomeVFSResult   result;
	GnomeVFSHandle   *handle;

	GnomeVFSFileSize  bytes_written;
	const gchar      *buf;

	        
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}

         
	printf ("\nEnter the file Name (to write): ");
	scanf ("%s", file);
		
        result = gnome_vfs_open (&handle, file, GNOME_VFS_OPEN_WRITE);
	show_result (result, "open_write", file);

	buf = "Jing test write";
	
	result = gnome_vfs_write (handle,
				  buf,
				  strlen (buf),
				  &bytes_written);
	show_result (result, "write", file);

	result = gnome_vfs_close (handle);
	show_result (result, "close_write", file);

        result = gnome_vfs_open (&handle, file, GNOME_VFS_OPEN_READ);
	show_result (result, "open_read", file);

	while (1) {
		GnomeVFSFileSize bytes_read;
		guint8           data [1025];
		
		result = gnome_vfs_read (handle, data, 1024, &bytes_read);
		
		if (show_if_error (result, "read ", file))
			break;
		
		if (bytes_read == 0)
			break;
		
		if (bytes_read >  0 &&
				bytes_read <= 1024)
			data [bytes_read] = '\0';
		else {
			data [1024] = '\0';
			g_warning ("Wierd error from vfs_read");
		}
		fprintf (stdout, "\n%s\n", data);
	}
	
         
	result = gnome_vfs_close (handle);
	show_result (result, "close", file);

	gnome_vfs_shutdown ();

	return 0;
	
}

int
rename_file (gchar *file)
{

	GnomeVFSFileInfo  info;
	GnomeVFSResult    result;

	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}

	printf ("\nEnter the file Name (to rename): ");
	scanf ("%s", file);

	info.name = "jingjing";
	info.valid_fields = GNOME_VFS_FILE_INFO_FIELDS_NONE;
	

	result = gnome_vfs_set_file_info (file,
					  &info,
					  GNOME_VFS_SET_FILE_INFO_NAME);
	show_result (result, "rename_file", file);

	gnome_vfs_shutdown ();

	return 0;
}


int
truncate (gchar *file)
{

	GnomeVFSResult   result;
	        
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}
         
	printf ("\nEnter the full file Name to truncate(file:///): ");
	scanf ("%s", file);
		
	result = gnome_vfs_truncate (file, 4);
	show_result (result, "truncate", file);

	gnome_vfs_shutdown ();

	return 0;
}


int
delete (gchar *file)
{

	GnomeVFSResult   result;
	        
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}

         
	printf ("\nEnter the file Name (to delete): ");
	scanf ("%s", file);
	
	result = gnome_vfs_unlink (file);
	show_result (result, "delete", file);

	gnome_vfs_shutdown ();

	return 0;
	
}

int
move_file (gchar *file)
{
	GnomeVFSResult   result;
     	gchar            target[50];
	
	puts("Welcome to move file!");
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}

	printf("Enter source file name :");
	scanf("%s",file);
	printf("Enter target file name :");
	scanf("%s",target);
	
	result = gnome_vfs_move (file, target, FALSE);
	show_result (result, "move", file);
	printf ("ALL DONE!");
	gnome_vfs_shutdown ();

	return 0;
}

int
same_fs (gchar *file)
{
	GnomeVFSResult   result;
     	gchar            target[50];
	gboolean         same_fs_return;
	
	puts("Welcome to same_fs!");
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}

	printf("Enter source file name :");
	scanf("%s",file);
	printf("Enter target file name :");
	scanf("%s",target);
	
	result = gnome_vfs_check_same_fs (file, target, &same_fs_return);
	show_result (result, "same_fs", target);
	printf ("ALL DONE!");
	gnome_vfs_shutdown ();

	return 0;
}


int
open_directory (gchar *dir)
{
	GnomeVFSResult   result;
	GnomeVFSHandle   *handle;

	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}
         
	printf ("\nEnter the directory Name (existing): ");
	scanf ("%s", dir);

        result = gnome_vfs_directory_open (&handle, dir, GNOME_VFS_FILE_INFO_GET_MIME_TYPE);
	show_result (result, "open_directory", dir);

	items_directory(dir);

	result = gnome_vfs_directory_close (handle);
	show_result (result, "close", dir);

	gnome_vfs_shutdown ();

	return 0;
}

int
items_directory(gchar *dir)
{
  GnomeVFSResult  result; 
  GList *items = NULL;
  GList *tmp = NULL;
  guint length = 0;
  
  result = gnome_vfs_directory_list_load(&items, dir, 0);

  show_result (result, "directory_list_load", dir);

  printf("This dir contains: \n");
  tmp = g_list_first(items);

  for(length=g_list_length(items); length != 0; length--)
    {
      puts(((GnomeVFSFileInfo *) tmp->data)->name);
      tmp = tmp->next;
    }
  printf("\n");
  g_list_free(tmp);
  g_list_free(items);
  return 0;
}


int
mk_directory (gchar *dir)
{

	GnomeVFSResult  result; 
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}
       
	printf ("\nEnter the full (with file:///) dir Name: ");
	scanf ("%s", dir);
	
	result = gnome_vfs_make_directory(dir, 0600);
	show_result (result, "mk_directory", dir);

	gnome_vfs_shutdown ();

	return 0;
}

rm_directory (gchar *dir)
{

	GnomeVFSResult   result;
	if (! gnome_vfs_init ()) {
		fprintf (stderr, "Cannot initialize gnome-vfs.\n");
		return 1;
	}
       
	printf ("\nEnter the full (with file:///) dir Name: ");
	scanf ("%s", dir);
	
	result = gnome_vfs_remove_directory(dir);
	show_result (result, "rm_directory", dir);

	gnome_vfs_shutdown ();

	return 0;
}

int
main (int argc, char **argv)
{
	GnomeVFSResult   result;
	gchar            file[100];
//	gchar            dir[100];

	puts("Welcome to testing!");
	
	result = create (file);
	show_result (result, "create", file);

//	result = open_read (file);
//	show_result (result, "open_read", file);

//	result = open_write (file);
//	show_result (result, "open_write", file);

//	result = delete (file);
//	show_result (result, "delete", file);
	
//	result = truncate (file);
//	show_result (result, "truncate", file);
	
//	result = rename_file (file);
//	show_result (result, "rename_file", file);
	
//	result = mk_directory(dir);
//	show_result(result, "mk_directory",dir);

//	result = open_directory(dir);
//	show_result(result, "open and read directory", dir);
	
//	result = rm_directory(dir);
//	show_result(result, "rm_direcotry",dir);
	
//	result = move_file(file);
//	show_result (result, "move", file);

//	result = same_fs(file);
//	show_result (result, "check same_fs", file);

	return 0;
}
					
