/**
  @file utils.c

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "log.h"
#include "utils.h"

#ifdef DEBUG
char *bytestr(const uint8_t *uuid, int len) {
    int i;
    char *str = g_malloc((len << 1) + 1);
    for (i = 0; i < len; i++) {
        sprintf(str + (2*i), "%02X", uuid[i]);
    }
    return str;
}
#endif

glong get_uname(gunichar2 **uname, const gchar *name) {
    glong uname_len;

    *uname = g_utf8_to_utf16(name, -1, NULL, &uname_len, NULL);

    if (*uname == NULL) {
        uname_len = -1;
    }
    else {
        int i;
        /* g_utf8_to_utf16 produces host-byteorder UTF-16,
         * but OBEX requires network byteorder (big endian) */
        for (i = 0; i < uname_len; i++) {
            (*uname)[i] = g_htons((*uname)[i]);
        }
        uname_len = (uname_len + 1) << 1;
    }

    return uname_len;
}
