/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2004 Nokia. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-method.h>

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus-glib.h>

#include "dbus-utils.h"

int
main (int argc, char *argv[])
{
	GnomeVFSResult           result;
	GnomeVFSDirectoryHandle *handle;
	GnomeVFSFileInfo        *info;
	GList                   *list, *l;
	GList                   *list2, *l2;
	DBusMessage             *message;
	
	gnome_vfs_init ();
	
	result = gnome_vfs_directory_open (&handle,
					   "/tmp",
					   GNOME_VFS_FILE_INFO_DEFAULT);
	if (result != GNOME_VFS_OK) {
		g_error ("Couldn't open directory.");
	}

	list = NULL;
	while (1) {
		info = gnome_vfs_file_info_new ();
		result = gnome_vfs_directory_read_next (handle, info);
		if (result == GNOME_VFS_OK) {
			list = g_list_append (list, info);
		} else {
			break;
		}
	}

	if (result != GNOME_VFS_ERROR_EOF) {
		g_error ("Couldn't read directory.");
	}
	
	result = gnome_vfs_directory_close (handle);
	if (result != GNOME_VFS_OK) {
		g_error ("Couldn't close directory.");
	}

	/* Convert to dbus message and back, then compare. */

	message = dbus_message_new (DBUS_MESSAGE_TYPE_METHOD_CALL);

	/* Append the result code. */
	dbus_message_append_args (message,
				  DBUS_TYPE_INT32, 0,
				  DBUS_TYPE_INVALID);
	
	for (l = list; l; l = l->next) {
		if (!dbus_utils_message_append_file_info (message, l->data)) {
			g_error ("Couldn't %s append to message.",
				 ((GnomeVFSFileInfo *)l->data)->name);
		}
	}

	list2 = dbus_utils_message_get_file_info_list (message);

	g_print ("Compare lists\n");

	if (g_list_length (list) != g_list_length (list2)) {
		g_error ("Not same length, %d, %d.",
			 g_list_length (list),
			 g_list_length (list2));
	}
	
	for (l = list, l2 = list2; l; l = l->next, l2 = l2->next) {
		if (!gnome_vfs_file_info_matches (l->data, l2->data)) {
			g_error ("File %s doesn't match file %s\n",
				 ((GnomeVFSFileInfo *)l->data)->name,
				 ((GnomeVFSFileInfo *)l2->data)->name);
		}
	}
	
	g_print ("OK, file info lists matched.\n");
	
	return 0;
}

