/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2004 Nokia. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* Tests for the GnomeVFS async API with the dbus daemon. */

#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-cancellable-ops.h>

#define d(x)

static GMainLoop *loop;
static gint num_files = 0;

static void
async_dir_load_cb (GnomeVFSAsyncHandle *handle,
		   GnomeVFSResult       result,
		   GList               *list,
		   guint                entries_read,
		   gpointer             data)
{
	GList *l;

	if (result == GNOME_VFS_ERROR_EOF) {
		return;
	}
	
	if (result != GNOME_VFS_OK) {
		g_print ("async_dir_load_cb(): %s\n", 
			 gnome_vfs_result_to_string (result));
		return;
	}

	for (l = list; l; l = l->next) {
		GnomeVFSFileInfo *info;

		info = (GnomeVFSFileInfo *) l->data;

		num_files++;
		
#if 1
		if (info->type == GNOME_VFS_FILE_TYPE_DIRECTORY) {
			g_print ("%d [%s]\n", num_files, info->name);
		} else {
			g_print ("%d -%s-\n", num_files, info->name);
		}
#endif
	}
}

static gboolean
cancel_func (gpointer data)
{
	GnomeVFSAsyncHandle *handle = data;

	g_print ("Cancelling after %d files...\n", num_files);
	gnome_vfs_async_cancel (handle);

	g_main_loop_quit (loop);

	return FALSE;
}

int 
main (int argc, char **argv)
{
	GnomeVFSAsyncHandle *handle;

	gnome_vfs_init ();
	
	loop = g_main_loop_new (NULL, FALSE);

	g_print ("Testing cancellation\n");

	gnome_vfs_async_load_directory (&handle,
					"dbus-test:///tmp/",
					GNOME_VFS_FILE_INFO_DEFAULT,
					1,
					GNOME_VFS_PRIORITY_DEFAULT,
					async_dir_load_cb,
					NULL);

	g_timeout_add (3000, cancel_func, handle);

	g_main_loop_run (loop);

	g_print ("num_files: %d\n", num_files);

	g_print ("\nAll tests passed\n");
	
	gnome_vfs_shutdown ();

	return 0;
}


