#include <config.h>
#include "osso-mime.h"

int
main (int argc, char** argv)
{
	DBusConnection *conn;
	gint            ret;

	if (argc < 2) {
		g_printerr ("Usage: %s <URI>\n", argv[0]);
		return 1;
	}
	
	conn = dbus_bus_get (DBUS_BUS_SESSION, NULL);
	g_assert (conn != NULL);

	ret = osso_mime_open (conn, argv[1], NULL);
	if (ret != 1) {
		g_print ("Error\n");
	} else {
		g_print ("Success\n");
	}

	return 0;
}
