/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2005 Nokia. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * @author Johan Hedberg <johan.hedberg@nokia.com>
 */

#include <config.h>
#include "osso-mime.h"
#include "eggdesktopentries.h"

#define MIME_TYPES "MimeType"

static gchar *
desktop_file_get_mime_types (const char *id)
{
	OmoDesktopEntries *entries;
	gchar             *filename;
	gchar             *service_name;

	service_name = NULL;

	filename = g_build_filename ("applications", id, NULL);

	entries = omo_desktop_entries_new_from_file (
		NULL,
		OMO_DESKTOP_ENTRIES_GENERATE_LOOKUP_MAP |
		OMO_DESKTOP_ENTRIES_DISCARD_COMMENTS,
		filename,
		NULL);

	g_free (filename);
	
	if (entries == NULL) {
		return NULL;
	}

	service_name = omo_desktop_entries_get_string (
		entries,
		omo_desktop_entries_get_start_group (entries),
		MIME_TYPES, NULL);

	omo_desktop_entries_free (entries);

	return service_name;
}

GList *
osso_mime_application_get_mime_types (const gchar *application_id)
{
	GList  *list;
	gchar  *mime_types;
	gchar **strv;
	gint    i;
	
	g_return_val_if_fail (application_id != NULL, NULL);

	mime_types = desktop_file_get_mime_types (application_id); 
	if (!mime_types) {
		return NULL;
	}
	
	strv = g_strsplit (mime_types, ";", -1);

	i = 0;
	list = NULL;
	while (strv[i] && strv[i][0] != '\0') {
		list = g_list_prepend (list, strv[i]);
		i++;
	}

	g_free (mime_types);

	/* Just free the array, not the contents. */
	g_free (strv);
	
	return g_list_reverse (list);
}

void
osso_mime_application_mime_types_list_free (GList *list)
{
	g_list_foreach (list, (GFunc) g_free, NULL);
	g_list_free (list);
}
