/* eggdesktopentries.h - desktop entry file parser
 *
 *  Copyright 2004  Ray Strode <halfline@hawaii.rr.com>
 *
 * GLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GLib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GLib; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *   Boston, MA 02111-1307, USA.
 */

#ifndef __OMO_DESKTOP_ENTRIES_H__
#define __OMO_DESKTOP_ENTRIES_H__

#include <glib/gerror.h>

G_BEGIN_DECLS

typedef enum
{
  OMO_DESKTOP_ENTRIES_ERROR_UNKNOWN_ENCODING,
  OMO_DESKTOP_ENTRIES_ERROR_BAD_START_GROUP,
  OMO_DESKTOP_ENTRIES_ERROR_PARSE,
  OMO_DESKTOP_ENTRIES_ERROR_NO_FILE,
  OMO_DESKTOP_ENTRIES_ERROR_KEY_NOT_FOUND,
  OMO_DESKTOP_ENTRIES_ERROR_GROUP_NOT_FOUND,
  OMO_DESKTOP_ENTRIES_ERROR_INVALID_VALUE
} OmoDesktopEntriesError;

#define OMO_DESKTOP_ENTRIES_ERROR omo_desktop_entries_error_quark()

GQuark omo_desktop_entries_error_quark (void);

typedef struct _OmoDesktopEntries OmoDesktopEntries;

typedef enum
{
  OMO_DESKTOP_ENTRIES_NONE                     = 0,
  OMO_DESKTOP_ENTRIES_DISCARD_COMMENTS         = 1 << 0,
  OMO_DESKTOP_ENTRIES_DISCARD_TRANSLATIONS     = 1 << 1,
  OMO_DESKTOP_ENTRIES_GENERATE_LOOKUP_MAP      = 1 << 2
} OmoDesktopEntriesFlags;

OmoDesktopEntries         *omo_desktop_entries_new           (gchar **legal_start_groups,
                                                              OmoDesktopEntriesFlags flags);
OmoDesktopEntries         *omo_desktop_entries_new_from_file (gchar **legal_start_groups,
                                                              OmoDesktopEntriesFlags   flags,
                                                              const gchar         *file,
                                                              GError             **error);
void                   omo_desktop_entries_free            (OmoDesktopEntries  *entries);

void                   omo_desktop_entries_keep_locales    (OmoDesktopEntries *entries,
						            gchar **locales);

void                   omo_desktop_entries_parse_data (OmoDesktopEntries  *entries,
	                                             const gchar    *data,
						     gsize          length,
						     GError        **error);  
void                   omo_desktop_entries_flush_parse_buffer (OmoDesktopEntries  *entries,
		 		                             GError          **error);

gchar                 *omo_desktop_entries_to_data   (OmoDesktopEntries   *entries,
	                                            gsize             *length,
						    GError           **error);

const gchar           *omo_desktop_entries_get_start_group (OmoDesktopEntries *entries);

gchar                **omo_desktop_entries_get_groups (OmoDesktopEntries  *entries,
	                                           gsize          *length);
gchar                **omo_desktop_entries_get_keys   (OmoDesktopEntries  *entries,
				                   const gchar    *group_name,
						   gsize            *length,
						   GError        **error);
gboolean               omo_desktop_entries_has_group  (OmoDesktopEntries  *entries,
	                                           const gchar     *group);

gboolean               omo_desktop_entries_has_key  (OmoDesktopEntries  *entries,
	                                           const gchar     *group,
                                                   const gchar     *key);

gchar                 *omo_desktop_entries_get_value         (OmoDesktopEntries  *entries,
				                          const gchar    *group,
				                          const gchar    *key,
						          GError        **error);
gchar                 *omo_desktop_entries_get_string        (OmoDesktopEntries  *entries,
				                          const gchar    *group,
				                          const gchar    *key,
						          GError        **error);
gchar                 *omo_desktop_entries_get_locale_string (OmoDesktopEntries  *entries,
					                  const gchar    *group,
					                  const gchar    *key,
					                  const gchar    *locale,
					                  GError        **error);
gboolean               omo_desktop_entries_get_boolean       (OmoDesktopEntries  *entries,
				                          const gchar    *group,
				                          const gchar    *key,
							  GError        **error);
gint                   omo_desktop_entries_get_integer       (OmoDesktopEntries  *entries,
				                          const gchar    *group,
				                          const gchar    *key,
							  GError        **error);

gchar                **omo_desktop_entries_get_string_list        (OmoDesktopEntries  *entries,
					                       const gchar    *group,
					                       const gchar    *key,
					                       gsize          *length,
					                       GError        **error);
gchar                **omo_desktop_entries_get_locale_string_list (OmoDesktopEntries  *entries,
						               const gchar    *group,
						               const gchar    *key,
						               const gchar    *locale,
						               gsize          *length,
						               GError        **error);
gboolean              *omo_desktop_entries_get_boolean_list       (OmoDesktopEntries  *entries,
					                       const gchar    *group,
					                       const gchar    *key,
					                       gsize          *length,
							       GError        **error);
gint                  *omo_desktop_entries_get_integer_list       (OmoDesktopEntries  *entries,
					                       const gchar    *group,
					                       const gchar    *key,
					                       gsize          *length,
							       GError        **error);

void                    omo_desktop_entries_add_entry (OmoDesktopEntries *entries,
				                     const gchar   *group,
				                     const gchar   *key,
				                     const gchar   *value);

void                    omo_desktop_entries_remove_entry (OmoDesktopEntries *entries,
				                        const gchar   *group,
				                        const gchar   *key);
					      
void                    omo_desktop_entries_add_group  (OmoDesktopEntries *entries,
				                      const gchar     *group_name);

void                    omo_desktop_entries_remove_group (OmoDesktopEntries *entries,
		 		                        const gchar     *group_name);

G_END_DECLS
#endif /* __OMO_DESKTOP_ENTRIES_H__ */
