/*
NOKIA RESEARCH CENTER                                             CONFIDENTIAL
Southwood
Roumen Popov










            DSP SW Include Code Document - ANSI C







%full_name: video_socket_node.h%

%full_filespec: Video socket node header file%

%date_created: 02.08.2004%

%created by: Roumen Popov%



Main features:
- LEAD3 assembler compatible
- supports Continuus automatic fields
- ?[]? brackets indicate fields to be edited
- ?[[]]? brackets indicate notes that can be removed
]]?


Copyright (c) Nokia Research Center. All rights reserved.


Change History:

NOTE: Duplicate the first block between the lines below and 
change the # signs of the lower one to % signs before checking 
the file into Continuus/CM.

Latest version is on top of the list
------------------------------------------------------------------------
Version: #version#
Date modified: #date_modified#
Derived by: #derived_by#
Status: -
Version notes:
-
------------------------------------------------------------------------
Version: %0.1%
Date modified: %02.08.2004%
Derived by: %Roumen Popov%
Status: -
Version notes:
-
------------------------------------------------------------------------
Version: 0.1
Date modified: -
Derived by: -
Status: -
Version notes:
-
------------------------------------------------------------------------
*/

/*  CONTENTS

    1  ABSTRACT
        1.1  Description
        1.2  Notes

    2  INCLUDE FILES

    3  COMPILER FLAGS

    4  CONSTANTS

    5  MACROS

    6  DATA TYPES

    7  EXTERNAL DATA STRUCTURES

    8  FUNCTION PROTOTYPES
*/

/*  1  ABSTRACT

    1.1 Description

	Provides common constants and data types for the MPEG4 socket node


    1.2 Notes

    ?[notes]?
    ?[[Any notes that may be relevant, open items, optimizations, etc.]]?
*/

/*  2  INCLUDE FILES */

/*  3 COMPILER FLAGS */

/*  4  CONSTANTS */

#ifndef __video_socket_node_h__
#define __video_socket_node_h__

/* sets locked ratio to 'yes' */
#define DSP_CMD_VIDEO_SET_LOCKEDRATIO       0x100
/* sets locked ratio to 'no' */
#define DSP_CMD_VIDEO_RESET_LOCKEDRATIO     0x101
/* sets mirror to 'yes'*/
#define DSP_CMD_VIDEO_SET_MIRROR            0x102
/* sets mirror to 'no'*/
#define DSP_CMD_VIDEO_RESET_MIRROR          0x103
/* sets rotation to 0 degrees */
#define DSP_CMD_VIDEO_ROTATION_0            0x104
/* sets rotation to 90 degrees */
#define DSP_CMD_VIDEO_ROTATION_90           0x105
/* sets rotation to 180 degrees */
#define DSP_CMD_VIDEO_ROTATION_180          0x106
/* sets rotation to 270 degrees */
#define DSP_CMD_VIDEO_ROTATION_270          0x107


/* stream is not compliant with supported format */
#define DSP_ERROR_VIDEO_NON_COMPLIANT       0x100
/* Fault in video object sequence */
#define DSP_ERROR_VIDEO_FAULT_IN_VOS        0x101
/* Frame size is not supported */
#define DSP_ERROR_VIDEO_SIZE_NOT_SUPPORTED  0x102
/* End of video object sequence code reached */
#define DSP_ERROR_VIDEO_VOS_END_CODE        0x103

/*  5  MACROS */

/*  6  DATA TYPES */

/* video init status */
typedef struct video_init_status
{
	unsigned short int dsp_cmd;
	unsigned short int init_status;
	unsigned short int bridge_buffer_size;
	unsigned short int mmap_buffer_size;
}VIDEO_INIT_STATUS;

/*
 * VIDEO Socket Node state machine
 */
enum VIDEO_SN_STATE {
	VIDEO_RESET_STATE,
	VIDEO_PLAY_STATE,		
	VIDEO_END_STATE,			
	VIDEO_PAUSE_STATE,		
	VIDEO_STOP_STATE,			
	VIDEO_LOAD_STATE,
	VIDEO_UNINITIALISED_STATE		
};

/*
 * VIDEO Socket Node video data formats
 */
enum VIDEO_DSP_VFMT {
	DSP_VFMT_RGB444,
	DSP_VFMT_RGB565,
	DSP_VFMT_YUV420P,
	DSP_VFMT_YUV420,
	DSP_VFMT_YUV422,
	DSP_VFMT_MPEG4,
	DSP_VFMT_H263
};

/* video socket node initialisation data */
typedef struct video_params_data
{
	unsigned short int dsp_cmd;
	unsigned long int fbuf_address;
	unsigned short int fbuf_height;
	unsigned short int fbuf_width;
	unsigned short int fbuf_bpp;
	unsigned short int fbuf_orientation;
	unsigned short int outImagePos_x;
	unsigned short int outImagePos_y;
	unsigned short int outImageHeight;
	unsigned short int outImageWidth;
	unsigned short int inImageHeight;
	unsigned short int inImageWidth;
	unsigned short int input_video_fmt;
	unsigned short int output_video_fmt;
	unsigned short int audio_strm_ID;
} VIDEO_PARAMS_DATA;

/* video socket node status data */
typedef struct video_status_data
{
	unsigned short int dsp_cmd;
	unsigned short int node_state;
	unsigned short int input_video_fmt;
	unsigned short int output_video_fmt;
	unsigned long int  frame_count;
	unsigned short int outImagePos_x;
	unsigned short int outImagePos_y;
	unsigned short int outImageHeight;
	unsigned short int outImageWidth;
	unsigned short int inImageHeight;
	unsigned short int inImageWidth;
	unsigned short int locked_ratio;
	unsigned short int mirror;
	unsigned short int rotation;
	unsigned short int zoom_factor;
	unsigned short int frames_per_second;
	unsigned short int audio_strm_ID;
	unsigned long int  skipped_frame_count;
} VIDEO_STATUS_DATA;

/* data write structure for */
typedef struct video_data_write
{
	unsigned short int dsp_cmd;
	unsigned short int mmap_buf_info;
	unsigned long int time_stamp;
}VIDEO_DATA_WRITE;

/* data write status structure */
typedef struct video_write_status
{
	unsigned short int dsp_cmd;
	unsigned short int status;
	unsigned short int mmap_buf_info;
}VIDEO_WRITE_STATUS;

/*  7  EXTERNAL DATA STRUCTURES */

/*  8  FUNCTION PROTOTYPES */
#endif
/* End of File */


