/*
NOKIA RESEARCH CENTER                                             CONFIDENTIAL
Southwood
Roumen Popov










            DSP SW Include Code Document - ANSI C







%full_name: interface_common.h%

%full_filespec: Interface common header file%

%date_created: 08.03.2004%

%created by: Roumen Popov%



Main features:
- LEAD3 assembler compatible
- supports Continuus automatic fields
- ?[]? brackets indicate fields to be edited
- ?[[]]? brackets indicate notes that can be removed
]]?


Copyright (c) Nokia Research Center. All rights reserved.


Change History:

NOTE: Duplicate the first block between the lines below and 
change the # signs of the lower one to % signs before checking 
the file into Continuus/CM.

Latest version is on top of the list
------------------------------------------------------------------------
Version: #version#
Date modified: #date_modified#
Derived by: #derived_by#
Status: -
Version notes:
-
------------------------------------------------------------------------
Version: %0.1%
Date modified: %08.03.2004%
Derived by: %Roumen Popov%
Status: -
Version notes:
-
------------------------------------------------------------------------
Version: 0.1
Date modified: -
Derived by: -
Status: -
Version notes:
-
------------------------------------------------------------------------
*/

/*  CONTENTS

    1  ABSTRACT
        1.1  Description
        1.2  Notes

    2  INCLUDE FILES

    3  COMPILER FLAGS

    4  CONSTANTS

    5  MACROS

    6  DATA TYPES

    7  EXTERNAL DATA STRUCTURES

    8  FUNCTION PROTOTYPES
*/

/*  1  ABSTRACT

    1.1 Description

	Provides common constants and data types for the interface between ARM and DSP


    1.2 Notes

    ?[notes]?
    ?[[Any notes that may be relevant, open items, optimizations, etc.]]?
*/

/*  2  INCLUDE FILES */

/*  3 COMPILER FLAGS */

/*  4  CONSTANTS */
#ifndef __interface_common_h__
#define __interface_common_h__

#define BRIDGE_BUFFER_SIZE 512

/* Request data write command */
#define DSPCTL_WRITEREQ    0x81

/* No command */
#define DSP_CMD_NONE         0x00
/* Identifies initialisation data */
#define DSP_CMD_INIT         0x01
/* Sets the audio socket node parameters */
#define DSP_CMD_SET_PARAMS   0x02
/* Identifies general stream data */
#define DSP_CMD_DATA_WRITE   0x03
/* Sets the socket node into a play state */
#define DSP_CMD_PLAY         0x04
/* Sets the socket node into a pause state */
#define DSP_CMD_PAUSE        0x05
/* Sets the socket node into a stop state */
#define DSP_CMD_STOP         0x06
/* Identifies volume data */
#define DSP_CMD_SET_VOLUME   0x07
/* Identifies audio socket node state information data */
#define DSP_CMD_STATE        0x08
/* Identifies set presentation time data */
#define DSP_CMD_SET_TIME     0x09
/* Identifies get presentation time data */
#define DSP_CMD_GET_TIME     0x0A
/* Identifies post-processing data data */
#define DSP_CMD_SET_POSTPROC 0x0B
/* Identifies video socket node state information data */
#define DSP_CMD_VIDEO_INFO   0x0C
/* Identifies panning data */
#define DSP_CMD_SET_PANNING  0x0D
/* Informs the DSP socket node about a discontinuity in the stream */
#define DSP_CMD_DISCONT      0x0E
/* Mutes the audio stream */
#define DSP_CMD_MUTE         0x0F
/* Unmutes the audio stream */
#define DSP_CMD_UNMUTE       0x10
/* tells the DSP to register a new video stream in the a/v sync node */
#define DSP_CMD_REG_VDSTRM   0x11
/* deletes a registered stream entry in the Sync clock task node */
#define DSP_CMD_ENDSTREAM    0x12
/* resets the time value for the corresponding stream */
#define DSP_CMD_STRM_RESET   0x13
/* closes the socket node */
#define DSP_CMD_CLOSE        0x14

#define DSP_CMD_SET_POSTPROC_INIT_PARAMS	0x15 
#define DSP_CMD_SET_POSTPROC_EQ_PARAMS	0x16 
#define DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS	0x17 
#define DSP_CMD_CHANGE_MUSICDRC_HPFILT_COEFFS	0x18 
#define DSP_CMD_GET_POSTPROC_PARAMS	0x19 
#define DSP_CMD_BYPASS_POSTPROCCESSING	0x20

#define DSP_CMD_SET_MODE     0x21  /* SK: Used in AMR Decoder */

/* Signifies end-of-file */
#define DSP_CMD_EOF          0x22

/* Operation successful */
#define DSP_OK               0x01
/* Unrecognised command identifier */
#define DSP_ERROR_CMD        0x02
/* Unrecognised stream format */
#define DSP_ERROR_FMT        0x03
/* Unrecognised sampling rate */
#define DSP_ERROR_RATE       0x04
/* Unrecognised number of channels */
#define DSP_ERROR_CHANNELS   0x05
/* Source/destination stream ID out of range */
#define DSP_ERROR_DS_ID      0x06
/* Insufficient memory to perform operation */
#define DSP_ERROR_MEMORY     0x07
/* General DSP error */
#define DSP_ERROR_GENERAL    0x08
/* Error in stream */
#define DSP_ERROR_STREAM     0x09
/* Wrong socket node state for command */
#define DSP_ERROR_STATE      0x0A
/* Error finding sync marker in MP3 stream */
#define DSP_ERROR_SYNC       0x0B

/* socket node is in an initialised state */
#define STATE_INITIALISED    0x00
/* socket node is in a playing state */
#define STATE_PLAYING        0x01
/* socket node is in a stopped state */
#define STATE_STOPPED        0x02
/* socket node is in a paused state */
#define STATE_PAUSED         0x03
/* socket node is in a uninitialised state */
#define STATE_UNINITIALISED  0x04
/* socket node is in a reset state */
#define STATE_RESET          0x05

/*  5  MACROS */

/*  6  DATA TYPES */

typedef struct dsp_cmd_status
{
	unsigned short int dsp_cmd;
	unsigned short int status;
}DSP_CMD_STATUS;

/* data write status structure */
typedef struct write_status
{
	unsigned short int dsp_cmd;
	unsigned short int status;
	unsigned short int buffer_bytes_free;
}WRITE_STATUS;

/* get time data structure */
typedef struct time_data
{
	unsigned short int dsp_cmd;
	unsigned short int status;
	unsigned short int stream_ID;
	long int time_ms;
}TIME_DATA;

/* general stream command data structure */
typedef struct stream_cmd_data
{
	unsigned short int dsp_cmd;
	unsigned short int stream_ID;
}STREAM_CMD_DATA;
/*  7  EXTERNAL DATA STRUCTURES */

/*  8  FUNCTION PROTOTYPES */

#endif
/* End of File */

