/*
NOKIA RESEARCH CENTER                                             CONFIDENTIAL
Southwood
Roumen Popov










            DSP SW Include Code Document - ANSI C







%full_name: audio_socket_node.h%

%full_filespec: Audio socket node header file%

%date_created: 08.03.2004%

%created by: Roumen Popov%



Main features:
- LEAD3 assembler compatible
- supports Continuus automatic fields
- ?[]? brackets indicate fields to be edited
- ?[[]]? brackets indicate notes that can be removed
]]?


Copyright (c) Nokia Research Center. All rights reserved.


Change History:

NOTE: Duplicate the first block between the lines below and 
change the # signs of the lower one to % signs before checking 
the file into Continuus/CM.

Latest version is on top of the list
------------------------------------------------------------------------
Version: #version#
Date modified: #date_modified#
Derived by: #derived_by#
Status: -
Version notes:
-
------------------------------------------------------------------------
Version: %0.1%
Date modified: %08.03.2004%
Derived by: %Roumen Popov%
Status: -
Version notes:
-
------------------------------------------------------------------------
Version: 0.1
Date modified: -
Derived by: -
Status: -
Version notes:
-
------------------------------------------------------------------------
*/

/*  CONTENTS

    1  ABSTRACT
        1.1  Description
        1.2  Notes

    2  INCLUDE FILES

    3  COMPILER FLAGS

    4  CONSTANTS

    5  MACROS

    6  DATA TYPES

    7  EXTERNAL DATA STRUCTURES

    8  FUNCTION PROTOTYPES
*/

/*  1  ABSTRACT

    1.1 Description

	Provides data types and constants for audio socket nodes interface


    1.2 Notes

    ?[notes]?
    ?[[Any notes that may be relevant, open items, optimizations, etc.]]?
*/

/*  2  INCLUDE FILES */

/*  3 COMPILER FLAGS */

/*  4  CONSTANTS */
#ifndef __audio_socket_node_h__
#define __audio_socket_node_h__

/* one channel */
#define CHANNELS_1   0x01
/* two channels */
#define CHANNELS_2   0x02
/* recording stream */
#define STRM_RECORD     0x01
/* playback stream */
#define STRM_PLAYBACK   0x02
/* PCM sample format unsigned 8 bits/sample */
#define DSP_AFMT_U8	         0x01
/* PCM sample format signed 16 bits/sample little endian*/
#define DSP_AFMT_S16_LE	     0x02
/* PCM sample format signed 16 bits/sample big endian */
#define DSP_AFMT_S16_BE	     0x03
/* PCM sample format signed 8 bits/sample */
#define DSP_AFMT_S8	         0x04
/* PCM sample format unsigned 16 bits/sample little endian */
#define DSP_AFMT_U16_LE	     0x05
/* PCM sample format unsigned 16 bits/sample big endian */
#define DSP_AFMT_U16_BE	     0x06
/* PCM sample format A-law companded */
#define DSP_AFMT_ALAW        0x07
/* PCM sample format u-law companded */
#define DSP_AFMT_ULAW        0x08

/* different sample rates */
#define SAMPLE_RATE_96KHZ     0x00
#define SAMPLE_RATE_88_2KHZ   0x01
#define SAMPLE_RATE_64KHZ     0x02
#define SAMPLE_RATE_48KHZ     0x03
#define SAMPLE_RATE_44_1KHZ   0x04
#define SAMPLE_RATE_32KHZ     0x05
#define SAMPLE_RATE_24KHZ     0x06
#define SAMPLE_RATE_22_05KHZ  0x07
#define SAMPLE_RATE_16KHZ     0x08
#define SAMPLE_RATE_12KHZ     0x09
#define SAMPLE_RATE_11_025KHZ 0x0A
#define SAMPLE_RATE_8KHZ      0x0B

/*  6  DATA TYPES */

/* volume data */
typedef struct volume_data
{
     unsigned short int dsp_cmd;
     unsigned short int scale;
     short int power2;
}VOLUME_DATA;

/* panning data */
typedef struct panning_data
{
     unsigned short int dsp_cmd;
     unsigned short int left_gain;
     unsigned short int right_gain;
     unsigned short int steps;
}PANNING_DATA;

/* audio status information */
typedef struct audio_status_info
{
	unsigned short int dsp_cmd;
	unsigned short int stream_ID;
	unsigned short int ds_stream_ID;
	unsigned short int bridge_buffer_size;
	unsigned short int mmap_buffer_size;
	unsigned short int status;
	unsigned long int num_frames;
	unsigned short int sample_rate;
	unsigned short int number_channels;
	unsigned short int vol_scale;
	short int vol_power2;
	short int left_gain;
	short int right_gain;
	short int dsp_audio_fmt;
}AUDIO_STATUS_INFO;

/* audio init status */
typedef struct audio_init_status
{
	unsigned short int dsp_cmd;
	unsigned short int init_status;
	unsigned short int stream_ID;
	unsigned short int bridge_buffer_size;
	unsigned short int mmap_buffer_size;
}AUDIO_INIT_STATUS;

/* audio socket node initialisation data */
typedef struct audio_params_data
{
	unsigned short int dsp_cmd;
	unsigned short int audio_fmt;
	unsigned short int sample_rate;
	unsigned short int number_channels;
	unsigned short int ds_stream_ID;
	unsigned short int stream_priority;
} AUDIO_PARAMS_DATA;

#endif
/* End of File */
