/**
  @file log.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _LOG_H_
#define _LOG_H_

#include <stdlib.h>

/** Log error message */
#define error(...) g_printerr(__VA_ARGS__)

/** Log informational message */
#define report(...) g_print(__VA_ARGS__)

#ifdef DEBUG
# define debug(...) g_print(__VA_ARGS__)
#else
# define debug(...) ((void)(0))
#endif

/** Setup logging functionality
 * @param name Identifier for this program
 * @param use_syslog Use syslog instead of stdout & stderr
 */
void open_log(const char *name, gboolean use_syslog);

/** Print error message and exit */
#define die(...) do {   \
    error(__VA_ARGS__); \
    exit(EXIT_FAILURE); \
} while (0)

#endif /* _LOG_H_ */
