/**
  @file btpin-stack.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BTPIN_STACK_H_
#define _BTPIN_STACK_H_

/** Register a PIN-handler
 * @param service D-BUS service of handler
 * @param path    D-BUS object path of handler
 * @param bda     Specific BDA to catch (NULL for any)
 * @returns FALSE on failure, TRUE on success
 */
gboolean btpin_stack_register(const gchar *service,
                              const gchar *path,
                              const gchar *bda);

/** Unregister a PIN-handler
 * @param service D-BUS service of handler
 * @param path    D-BUS object path of handler (NULL for any)
 * @param bda     Specific BDA to catch (NULL for any)
 * @returns FALSE on failure TRUE on success
 */
gboolean btpin_stack_unregister(const gchar *service,
                                const gchar *path,
                                const gchar *bda);

/** Get handler for specified BDA */
gboolean btpin_stack_get_handler(const gchar *bda,
                                 gchar **service,
                                 gchar **path);

#endif /* _BTPIN_STACK_H_ */
