/**
  @file btpair-error.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BTPAIR_ERROR_H_
#define _BTPAIR_ERROR_H_

#include <stdint.h>
#include <glib.h>
#include <dbus/dbus.h>

const char *bt_pair_dbus_error(GError *err);

gboolean bt_pair_set_g_error(GError **err, DBusError *derr);

gint bt_pair_bt_error(uint8_t err, gint fallback);

GQuark bt_pair_error_quark(void);

#define BT_PAIR_ERROR bt_pair_error_quark()

typedef enum {
    BT_PAIR_ERROR_CONNECT_FAILED,
    BT_PAIR_ERROR_DISCONNECTED,
    BT_PAIR_ERROR_TIMEOUT,
    BT_PAIR_ERROR_REFUSED,
    BT_PAIR_ERROR_AUTH_FAILED,
    BT_PAIR_ERROR_TOO_FREQUENT,
    BT_PAIR_ERROR_RESOURCE_LIMIT,
    BT_PAIR_ERROR_CANCELED,
    BT_PAIR_ERROR_IN_PROGRESS,
    BT_PAIR_ERROR_FAILED
} BtPairError;

#endif /* _PAIR_ERROR_H_ */

