/**
  @file btname.c

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <glib.h>

#include "log.h"
#include "dbus.h"
#include "bttools-dbus.h"
#include "btname-dbus.h"
#include "btname-op.h"

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#define TIMEOUT (1000 * 5)

GMainLoop *event_loop = NULL;

static gboolean dbus_timeout(GMainLoop *event_loop) {
    error("No D-BUS messages received within %d seconds", TIMEOUT/1000);
    g_main_loop_quit(event_loop);
    return FALSE;
}

int main(int argc, char *argv[]) {
    int c;

    open_log("btname", TRUE);

    report("BTName %s started.", VERSION);

    if (!setup_dbus_connection(BTNAME_SERVICE, init_dbus_handlers)) {
        die("D-BUS connection setup failed!");
    }

    c = getopt (argc, argv, "s:gr");
    if (c == -1) {
        /* Assume that we were activated by D-BUS */
        event_loop = g_main_loop_new(NULL, FALSE);

        g_timeout_add(TIMEOUT, (GSourceFunc)dbus_timeout, event_loop);

        g_main_loop_run(event_loop);
    }
    else {
        char name[MAXNAMELEN];

        switch (c) {
            case 'g':
                get_name(name, sizeof(name));
                printf("%s\n", name);
                break;

            case 's':
                if (!set_name(optarg)) {
                    error("Setting name failed!");
                    exit(EXIT_FAILURE);
                }
                else {
                    send_name_changed_signal(get_dbus_connection(), optarg);
                }
                break;

            case 'r':
                if (!get_name(name, sizeof(name))) {
                    error("Getting name failed!");
                    exit(EXIT_FAILURE);
                }
                if (!set_name(name)) {
                    error("Setting name failed!");
                    exit(EXIT_FAILURE);
                }
                else {
                    send_name_changed_signal(get_dbus_connection(), name);
                }
                break;

            default:
                error("Invalid arguments!");
                error("Usage: %s [-g] [-s <name>] [-r]", argv[0]);
                exit(EXIT_FAILURE);
        }
    }

    exit(EXIT_SUCCESS);
}

