/**
	@file callbacks.h

	Function definitions for user interface callbacks
*/

/* 
 *
 * This file is part of Application Installer
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Marius Vollmer <marius.vollmer@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/* GTK */
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "../appdata.h"
#include "../applicationinstaller-i18n.h"


/**
Callback for install button

@param button Button widget
@param app_ui_data AppUIData pointer to application UI data structure
*/
void on_button_install_clicked(GtkButton *button, AppUIData *app_ui_data);



/**
Call back for uninstall button

@param button Button widget
@param app_ui_data AppUIData pointer to application UI data structure
*/
void on_button_uninstall_clicked(GtkButton *button, AppUIData *app_ui_data);



/**
Callback for treeview double-click for description

@param view GtkTreeView that was activated
@param path Path that is selected
@param col Column
@param app_ui_data AppUIData
*/
void on_treeview_activated(GtkTreeView *view, GtkTreePath *path, 
			   GtkTreeViewColumn *col, AppUIData *app_ui_data);


/**
Callback for cancel operation button

@param button Button that got toggled
@param button_yes Dialog to kill
*/
void on_button_cancel_operation(GtkButton *button, gpointer dialog);


/**
Callback for progressbar updating timeout callback

@param app_ui_data AppUIData pointer
@return Returns always TRUE as a sign to keep going
*/
gboolean progressbar_timeout_cb(AppUIData *app_ui_data);


/**
Callback for hw key presses

@param widget What widget was pressed
@param event  What event happened
@param data pointer to AppUIData
*/
gboolean key_press(GtkWidget *widget, GdkEventKey *event, gpointer data);



/**
Callback for hw key releases

@param widget What widget was released
@param event  What event happened
@param data pointer to AppUIData
*/
gboolean key_release(GtkWidget * widget, GdkEventKey * event, gpointer data);
