/**
  @file ailauncher.c

*/
/* 
 *
 * This file is part of Application Installer
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Marius Vollmer <marius.vollmer@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/*
#include <glib.h>

*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <sys/types.h>
#include <pwd.h>

#include <config.h>

/*
#include <libosso.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <osso-log.h>
*/

#define APP_NAME "osso_application_installer"
#define INSTALL_USER "install"


int main(int argc, char **argv)
{
   int i;
   uid_t ruid;
   uid_t euid;
   char *args[2];
   struct passwd *pentry;
   
   
 /*  args[0]="printenv"; */
  args[0]=APP_NAME;
   args[1]=(char *)NULL;

   ruid=getuid();
fprintf(stderr, "Launcher process initial RUID: %i\n", ruid);
   euid=geteuid();
fprintf(stderr, "Launcher process initial EUID: %i\n", ruid);


/* use getpwent() here..*/

   pentry=getpwnam(INSTALL_USER);
   ruid=(uid_t)pentry->pw_uid;
   euid=ruid;
   

   fprintf(stderr, "Tried to set proper ids::ruid:value: %i\n", ruid);
   if(setreuid(ruid, ruid)) {fprintf(stderr,"**Failed to set euid to install\n"); exit(1);}

fprintf(stderr, "Tried to change RUID for install::value: %i\n", ruid);

  
fprintf (stderr,"Trying to launch AI... \n");
fprintf (stderr,"Arguments:\n");

   i=0;
   while (args[i]!=NULL)    
   {     
     fprintf (stderr,"arg[%i]: %s\n",i,args[i]);
     i++;
   }


   fprintf(stderr, "OK exit\n");         
  

 
   execvp(args[0], args);
   

   return 0;
}




