/* 
 *
 * This file is part of Application Installer
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Marius Vollmer <marius.vollmer@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#include <glib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <sys/types.h>
#include <pwd.h>

#include <config.h>
#include <libosso.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <osso-log.h>

#define APP_NAME "/usr/bin/osso_application_installer"
#define INSTALL_USER "install"

extern char **environ;

int main(int argc, char **argv)
{
   gint i;
   uid_t ruid;
   uid_t euid;
   gchar *args[2];
   struct passwd *pentry;
   osso_context_t *osso; 
  

   args[0]="APP_NAME"; 
   args[1]=(gchar *)NULL;

   ruid=getuid();
   fprintf(stderr, "Launcher process initial RUID: %i\n", ruid);
   euid=geteuid();
   fprintf(stderr, "Launcher process initial EUID: %i\n", ruid);


   /* use getpwent() here..*/
   pentry=getpwnam(INSTALL_USER);
   ruid=(uid_t)pentry->pw_uid;
   euid=ruid;

   fprintf(stderr, "Trying to set proper ids::ruid:value: %i\n", ruid);
   gint ret = 0;
   if((ret = setreuid(ruid, euid)) == -1) {
     fprintf(stderr,"**Failed to set euid to install (ret=%d)\n",
	     ret); 
     exit(1);
   }

    fprintf(stderr, "Success (with ret=%d) on RUID for install::value: %i\n", 
	ret, ruid);

    fprintf (stderr,"Trying to launch AI... \n");


   g_spawn_command_line_sync(APP_NAME, NULL, NULL, NULL, NULL);
 

   return 0;
}




