#!/bin/sh

if [ $# -lt 3 ]; then
  echo "Usage: $0 {start|stop|restart} servicename cmd [params]"
  exit 1
fi

STOP=FALSE
START=FALSE

case "$1" in
start)  START=TRUE
        ;;
stop)   STOP=TRUE
        ;;
restart)
        STOP=TRUE
        START=TRUE
        ;;
*)      echo "Usage: $0 {start|stop|restart} servicename cmd [params]"
        exit 1
        ;;
esac

shift
SVC="$1"
shift
CMD=$1
BASENAME=`basename $CMD`
PIDFILE=$AF_PIDDIR/$BASENAME.pid
shift
PARAMS=$@

if [ $STOP = TRUE ]; then
  echo "Stopping $SVC"
  /sbin/start-stop-daemon --stop -p $PIDFILE -R TERM/1/KILL -q &
fi

if [ $START = TRUE ]; then
  echo "Starting $SVC"
  /sbin/start-stop-daemon --start -x $CMD -p $PIDFILE -o -m -q -- $PARAMS &
fi
