#!/bin/sh
# Application Framework environment variable defines for all AF programs,
# programs started by AF startup scripts and the D-BUS session bus.

# Global things
export AF_PIDDIR=/tmp/af-piddir
if [ ! -d $AF_PIDDIR ]; then
  # note, no write to flash involved here
  mkdir $AF_PIDDIR
fi

if [ "x$DISPLAY" = "x" ]; then
  export DISPLAY=:0.0
fi
export DBUS_SESSION_BUS_ADDRESS=unix:path=/tmp/session_bus_socket
export LAUNCHWRAPPER=/etc/osso-af-init/launch-wrapper.sh
if [ -x /usr/sbin/dsmetool ]; then
  export LAUNCHWRAPPER_NICE=/etc/osso-af-init/nice-launch-wrapper.sh
  export LAUNCHWRAPPER_NICE_TRYRESTART=/etc/osso-af-init/nice-launch-wrapper-tryrestart.sh
else
  export LAUNCHWRAPPER_NICE=$LAUNCHWRAPPER
  export LAUNCHWRAPPER_NICE_TRYRESTART=$LAUNCHWRAPPER
fi

export TMPDIR=/tmp
export STATESAVEDIR=$TMPDIR/osso-appl-states
if [ ! -d $STATESAVEDIR ]; then
  mkdir $STATESAVEDIR
fi

# no existence check because user does not have rights to delete the file
source /etc/osso-af-init/locale

# The MyDocs directory
export MYDOCSDIR=$HOME/MyDocs

# Mount point of the MMC
export MMC_MOUNTPOINT=/media/mmc1 MMC_DEVICE_FILE=/dev/mmcblk0p1
export ILLEGAL_FAT_CHARS=\\\/\:\*\?\<\>\| MAX_FILENAME_LENGTH=255
