/*
 * This file is part of lessertunjo
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Kuisma Salonen <kuisma.salonen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/**
 * @file shadowappd.h
 * 
 * shadow application library, daemon side header
 * <p>
 *
 * @author Kuisma Salonen <kuisma.salonen@nokia.com>
 */

#ifndef _SAPP_DEE_HEADER_JEE_
#define _SAPP_DEE_HEADER_JEE_

#ifdef __cplusplus
extern "C" {
#endif

/* uncomment next line to compile in SAPPD_DEBUG mode */
/* #define SAPPD_DEBUG */

#define SAPP_DEBUG_FILENAME             "/tmp/.gamewrapper/debug/general.debug"

/**
 * \defgroup libshadowappd libshadowapp daemon side user functions
 *
 * @{
 */

/**
 * @brief Main shadowapp daemon context. This should be
 * considered as private and be modified only through
 * libshadowappd functions.
 */
typedef struct 
{
  char *appname, *versionstring;
  char *executable;
  char *launcherapp;

  int state, connstate;

  struct osso_af_context_t *osso_context;

  GConfClient *gconf_client;

  int listener_sd, connection_sd, gcq_sd;
  struct sockaddr_un *our_addr, *incoming_addr;
  struct sockaddr_un *alt_addr, *in_alter_addr;
  socklen_t socket_lenght;

  int child_pid;

  GIOChannel *channel, *confchan;

  GMainLoop* mainloop;

  int realbuflen;
  char inbuf[16], realbuf[256];

  void (*quit_callback)(void);
} sapp_d_data;

/*struct osso_af_context_t {
  DBusConnection *conn;
  DBusConnection *sys_conn;
  gchar *application;
  gchar *version;
  gchar *object_path;
  GArray *ifs;
  _osso_autosave_t *autosave;
  guint log_handler;
  _osso_hw_cb_t *hw;
  osso_hw_state_t *hw_state;
  int environment_set;
};*/


extern int sappd_error;
extern int sappd_crashed;
extern sapp_d_data *main_cont;


/**
 * @brief This function initializes shadow application daemon
 * side library and sets up framework
 * @param filename A filename to a file, which contains game
 * @param gctx GMainContext to work with, NULL for GTK+ applications
 * @param loopie GMainLoop which we may have to quit
 * specific information (what to launch and so on)
 * @return NULL if failed, if succeeded returns a valid pointer
 * to sapp_d_data storage type
 */
sapp_d_data *sappd_initialize(char *filename, GMainContext *gctx, GMainLoop *loopie);

/**
 * @brief This function inits SICHLD handling to certain main context,
 * note that this can be set only to one
 * @param context main context to set up with
 * @return SAPP_ERROR_NONE if succesful, if context is NULL returns
 * SAPP_ERROR_INVALIDPARAMS
 */
int sappd_init_sigchld(sapp_d_data *context);

/**
 * @brief If command is SAPPD_COMMAND_RUN this function executes game,
 * or stops pausemode, depending whether game is running or not. This
 * can also kill gamestate if command is SAPPD_COMMAND_RESET.
 * @param context main context, returned by sappd_initialize
 * @param command SAPPD_COMMAND_RUN or SAPPD_COMMAND_RESET depending if
 * user wants to launch/continue game or reset state data
 * @return SAPP_ERROR_NONE if succesful. If given invalid arguments to
 * current state return SAPP_ERROR_INVALIDPARAMS or if command argument
 * is invalid.
 */
int sappd_spawn(sapp_d_data *context, int command);

/**
 * @brief RPC running function, similar to osso_rpc_run_with_defaults,
 * except has certain D-BUS flag that activates application if not
 * active. This function should be considered as private.
 * @param context shadowappd context
 * @param mthd method argument send to destination
 * @param destapp name of destination application
 * @return SAPP_ERROR_NONE if everything went OK
 */
int sappd_rpc(sapp_d_data *context, char *mthd, char *destapp);

/**
 * @brief Cleans up sapp_d_data context, which is usually main context.
 * @param context sapp_d_data type to clean up
 * @param flags flags to pass, SAPPD_DEINIT_STATESAVE to remember state
 * on next launch, HIGHLY RECOMMENDED
 * @return Never fails, always returns SAPP_ERROR_NONE.
 */
int sappd_deinitialize(sapp_d_data *context, int flags);

/** @} */

/* SIGCHLD callback function */
void sigchld_handler(int signal);

/* socket callback function */
gboolean sappd_socket_callback(GIOChannel *channel, GIOCondition cond,
                               gpointer data);

/* alt socket callback function */
gboolean sappd_confsock_callback(GIOChannel *channel, GIOCondition cond,
                               gpointer data);

/* osso callback functions */
void sappd_osso_callback_top(const gchar *arguments, gpointer data);
gint sappd_osso_callback_rpc(const gchar *interface, const gchar *method,
                             GArray *arguments, gpointer data,
                             osso_rpc_t *retval);

void sappd_flush_socket(sapp_d_data *context);

int sappd_parse_realbuf(sapp_d_data *context);

#ifdef SAPPD_DEBUG
int _sd_debugprint(char *text);
#endif

#define SAPPD_STATE_NONE        0
#define SAPPD_STATE_INACTIVE    1
#define SAPPD_STATE_ACTIVE      2
#define SAPPD_STATE_RUNNING     3
#define SAPPD_STATE_PAUSED      4

#define SAPPD_CONNSTATE_NONE    0
#define SAPPD_CONNSTATE_ACTIVE  1

#define SAPPD_COMMAND_NONE      0
#define SAPPD_COMMAND_RUN       1
#define SAPPD_COMMAND_RESET     2
#define SAPPD_COMMAND_RESTART	3

#define SAPPD_DEINIT_STATESAVE  0x00000001
#define SAPPD_DEINIT_REPORT     0x00000002
#define SAPPD_DEINIT_CRASHED    0x00000004

#define SAPP_ERROR_NONE            0
#define SAPP_ERROR_NOMEMORY       -1
#define SAPP_ERROR_INVALIDPARAMS  -2
#define SAPP_ERROR_SOCKET         -3
#define SAPP_ERROR_CONNECTION     -4
#define SAPP_ERROR_CONNANOTHER    -5
#define SAPP_ERROR_WRONGID        -6
#define SAPP_ERROR_BYE            -7
#define SAPP_ERROR_BYESEND        -8
#define SAPP_ERROR_CONNECTIONLOST -9
#define SAPP_ERROR_FILEOPEN       -10
#define SAPP_ERROR_FILEFORMAT     -11
#define SAPP_ERROR_OSSOINIT       -12
#define SAPP_ERROR_EXECUTION      -13
#define SAPP_ERROR_INVALIDARGS    -14
#define SAPP_ERROR_QUIT           -15
#define SAPP_ERROR_SYSTEM         -16

#ifdef __cplusplus
}
#endif
#endif
