/* This is a module which is used for setting
 * the NFC_TRACE flag in the nfcache field of an skb. 
 */
#include <linux/module.h>
#include <linux/skbuff.h>

#include <linux/netfilter_ipv6/ip6_tables.h>

MODULE_LICENSE("GPL");

static unsigned int
target(struct sk_buff **pskb,
	unsigned int hooknum,
	const struct net_device *in,
	const struct net_device *out,
	const void *targinfo,
	void *userinfo)
{
	(*pskb)->nfcache |= NFC_TRACE;
	return IP6T_CONTINUE;
}

static int 
checkentry(const char *tablename,
       	   const struct ip6t_entry *e,
           void *targinfo,
           unsigned int targinfosize,
           unsigned int hook_mask)
{
	if (targinfosize != 0) {
		printk(KERN_WARNING "TRACE: targinfosize %u != 0\n",
		       targinfosize);
		return 0;
	}

	if (strcmp(tablename, "raw") != 0) {
		printk(KERN_WARNING "TRACE: can only be called from \"raw\" table, not \"%s\"\n", tablename);
		return 0;
	}

	return 1;
}

static struct ip6t_target ip6t_trace_reg = { 
	.name = "TRACE",
	.target = target, 
	.checkentry = checkentry, 
	.me = THIS_MODULE
};

static int __init init(void)
{
	if (ip6t_register_target(&ip6t_trace_reg))
		return -EINVAL;

	return 0;
}

static void __exit fini(void)
{
	ip6t_unregister_target(&ip6t_trace_reg);
}

module_init(init);
module_exit(fini);
