/* -*- mode: C; c-file-style: "stroustrup"; indent-tabs-mode: nil; -*- */


/*
 * This file is part of hildon-status-bar
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef HILDON_STATUR_BAR_LIB_FUNCTIONS_H
#define HILDON_STATUR_BAR_LIB_FUNCTIONS_H

#include <glib.h>

G_BEGIN_DECLS

typedef void (*dialog_closed_cb)( gint type, gpointer data );

void hildon_status_bar_lib_prepare_dialog( gint type, const gchar *icon, 
                                           const gchar *msg, gint int_type, 
                                           dialog_closed_cb cb, gpointer data );
void hildon_status_bar_lib_queue_dialog( const gchar *icon,  /* stock icon */
                                         const gchar *msg,   /* msg to show */
                                         gint int_type,     /* plugin's internal
                                                              * msg type */
                                         dialog_closed_cb cb,/* cb to be called
                                                              * after the dialog
                                                              * is closed */
                                         gpointer data );    /* data passed to 
                                                              * cb */


G_END_DECLS

#endif /* HILDON_STATUR_BAR_LIB_FUNCTIONS_H */
