#!/bin/sh

STOP=FALSE
START=FALSE
DIR=/etc/osso-af-init
GDB=

if [ $# = 0 ]; then
  echo "Usage: $0 {start|stop|restart} [--valgrind cmd] [--gdb appname]"
  exit 0
fi

case "$1" in
start)  START="TRUE"
        ;;
stop)   STOP="TRUE"
        ;;
restart|force-reload)
        STOP="TRUE"
        START="TRUE"
        ;;
*)      echo "Usage: $0 {start|stop|restart} [--valgrind cmd] [--gdb cmd]"
        exit 0
        ;;
esac
shift

while [ $# != 0 ]; do
  if [ "$1" = "--valgrind" ]; then
    shift
    export VALGRINDCMD=$1
    export VALGRIND="valgrind --leak-check=yes --trace-children=yes --num-callers=100 --logfile=/tmp/valgrind-$VALGRINDCMD.log"
  fi
  if [ "$1" = "--gdb" ]; then
    shift
    export GDB=$1
  fi
  shift
done

AF_DEFS=$DIR/af-defines.sh

if [ ! -r $AF_DEFS ]; then
  echo "$0: Error, $AF_DEFS does not exist or is not readable"
  exit 2
fi

source $AF_DEFS

# let's use /var/run as pid dir and make sure it is not a link
export AF_PIDDIR=/var/run
if [ -L $AF_PIDDIR ]; then
  rm $AF_PIDDIR
fi

if [ ! -d $AF_PIDDIR ]; then
  mkdir $AF_PIDDIR
fi

# dbus want's this, so let's make sure it is found.
mkdir -p /var/run/dbus

# overriding some variables
export HOME="/home/$USER"
export MYDOCSDIR=$HOME/MyDocs

source $DIR/osso-gtk.defs

# Let's use SB launcher wrapper
export LAUNCHWRAPPER=/usr/bin/scratchbox-launcher.sh

# Check our environment
if [ -e /targets/links/scratchbox.config ]; then
  source /targets/links/scratchbox.config
  if echo $SBOX_CPUTRANSPARENCY_METHOD | grep "sbrsh$" >/dev/null; then
    if [ -z "$SBOX_TARGET_NAME" ]; then
      echo "$0: SBOX_CPUTRANSPARENCY_METHOD defined but SBOX_TARGET_NAME not!"
      exit 1
    fi

    # we are using Scratchbox and sbrsh
    SBRSH="sbrsh $SBOX_TARGET_NAME"
  fi

  # Modify the DBUS session bus socket so that it is different for each user.
  if [ -e /etc/dbus-1/session.conf ]; then
      if grep 'session_bus_socket</listen>' /etc/dbus-1/session.conf; then
	  cp -f /etc/dbus-1/session.conf /tmp/session.conf-$USER && \
	      cat /tmp/session.conf-$USER | sed -e "s|session_bus_socket</listen>|session_bus_socket-$USER</listen>|" > \
	      /etc/dbus-1/session.conf
      fi
  fi
  # we need also to modify the env. variable in af-defines.sh
  if [ -e /etc/osso-af-init/af-defines.sh ]; then
      if grep 'session_bus_socket$' /etc/osso-af-init/af-defines.sh; then
	  cp -f /etc/osso-af-init/af-defines.sh /tmp/af-defines.sh-$USER && \
	      cat /tmp/af-defines.sh-$USER | sed -e "s|DBUS_SESSION_BUS_ADDRESS=unix:path=/tmp/session_bus_socket|DBUS_SESSION_BUS_ADDRESS=unix:path=/tmp/session_bus_socket-$USER|" > \
	      /etc/osso-af-init/af-defines.sh
      fi
  fi

  
fi

# we need to save these, because the source commands below messes them up
TMPSTART=$START
TMPSTOP=$STOP
if [ "$STOP" = "TRUE" ]; then

  for svc in \
      statusbar \
      home \
      tasknav \
      keyboard \
      matchbox \
      sapwood-server \
      dbus-sessionbus \
      dbus-systembus;
  do
    if [ -e $DIR/$svc.defs ]; then
      source $DIR/$svc.defs
    fi
    if [ -e $DIR/$svc.sh ]; then
      source $DIR/$svc.sh stop
    fi
  done

  # stop
  if [ -r /usr/bin/osso-connectivity-ui.sh ]; then
    source /usr/bin/osso-connectivity-ui.sh stop
  fi

  # remove dbus own dbus pid file
  rm -rf /var/run/dbus/pid
fi

START=$TMPSTART
STOP=$TMPSTOP
if [ "$START" = "TRUE" ]; then

  # if we are restarting, give some time for the programs to shutdown
  if [ "$STOP" = "TRUE" ]; then
    # if we are not using sbrsh sleep just a seconds, otherwise a bit longer
    if [ -z "$SBRSH" ]; then
      sleep 1
    else
      sleep 5
    fi
  fi

  if [ "x$MYDOCSDIR" = "x" ]; then
      echo "$0: Error, MYDOCSDIR is not defined"
      exit 2
  fi

  if [ "x$DISPLAY" = "x" ]; then
      echo "$0: Error, DISPLAY is not defined"
      echo "DISPLAY must be host:display when using sbrsh in Scratchbox and "
      echo "X forwarding will be used. Set display to :0 (the display number "
      echo "of your Desktop X) to launch Xephyr."
      exit 1
  fi

  host=`echo $DISPLAY | cut -f 1 -d ':'`
  if [ -z "$host" ]; then
      echo "DISPLAY must contain hostname!"
      exit 1
  fi

  # Create some files to play with
  if [ -e $MYDOCSDIR/foo.txt ]; then
    echo "Sample files present."
  else
    touch $MYDOCSDIR/foo.txt
    touch $MYDOCSDIR/.videos/video1.mpg $MYDOCSDIR/.videos/video2.avi
    touch $MYDOCSDIR/.sounds/clip1.wav $MYDOCSDIR/.sounds/clip2.mp3
    touch $MYDOCSDIR/.documents/sheet1.xls $MYDOCSDIR/.documents/document.doc
    touch $MYDOCSDIR/.images/image1.png $MYDOCSDIR/.images/image2.jpg
  fi

  # remove dbus own dbus pid file
  rm -rf /var/run/dbus/pid

  # start other things
  for svc in \
      dbus-systembus \
      dbus-sessionbus \
      sapwood-server \
      matchbox \
      keyboard \
      tasknav \
      home \
      statusbar;
  do
    if [ -e $DIR/$svc.defs ]; then
      source $DIR/$svc.defs
    fi
    if [ -e $DIR/$svc.sh ]; then
      source $DIR/$svc.sh start
    fi
  done

  if [ -e /usr/bin/osso-connectivity-ui.sh ]; then
    source /usr/bin/osso-connectivity-ui.sh start
  fi
fi
