#!/bin/sh
# Home startup/shutdown script

if [ "x$AF_PIDDIR" = "x" ]; then
  echo "$0: Error, AF_PIDDIR is not defined"
  exit 2
fi
if [ ! -w $AF_PIDDIR ]; then
  echo "$0: Error, directory $AF_PIDDIR is not writable"
  exit 2
fi
PROG=/usr/bin/home
SVC="Home"

case "$1" in
start)  START=TRUE
        ;;
stop)   START=FALSE
        ;;
*)      echo "Usage: $0 {start|stop}"
        exit 1
        ;;
esac

if [ $START = TRUE ]; then
  # check that required environment is defined
  if [ "x$DISPLAY" = "x" ]; then
    echo "$0: Error, DISPLAY is not defined"
    exit 2
  fi
  if [ "x$HOME" = "x" ]; then
    echo "$0: Error, HOME is not defined"
    exit 2
  fi

  $LAUNCHWRAPPER start "$SVC" $PROG
else
  $LAUNCHWRAPPER stop "$SVC" $PROG
fi
