/* -*- mode: C; c-file-style: "stroustrup"; indent-tabs-mode: nil; -*- */

/*
 * This file is part of hildon-control-panel
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef DBUS_API_SUBJECT_TO_CHANGE
#define DBUS_API_SUBJECT_TO_CHANGE
#endif /* dbus_api_subject_to_change */

#ifndef HILDON_CLOCKAPP_CP_MAIN_H
#define HILDON_CLOCKAPP_CP_MAIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <locale.h>
#include <libintl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <linux/limits.h> /* not portable. see comments in hildon-desk source code */

#include <gtk/gtk.h>
#include <glib.h>



#include <dbus/dbus.h>

#include <hildon-widgets/hildon-get-password-dialog.h>
#include <hildon-widgets/hildon-app.h>
#include <hildon-widgets/hildon-note.h>
#include <hildon-widgets/hildon-grid.h>
#include <hildon-base-lib/hildon-base-dnotify.h>

#include <libmb/mbdotdesktop.h>
#include <libmb/mbutil.h>

#include <libosso.h>
#include <osso-helplib.h>

#include <unistd.h>

#include "hildon-cp-applist.h"


#define _(a) gettext(a)

#define APP_NAME "controlpanel"
#define APP_VERSION "0.1"

/* max length of state save file */

#define HILDON_CONTROL_PANEL_STATEFILE_MAX 1024
#define OSSO_HELP_ID_CONTROL_PANEL "Connectivity_connectionmanager_mainview"

#endif
