/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import com.nwalsh.xalan.Callout;
import org.apache.xml.utils.AttList;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class FormatCallout {
    protected static final String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static final String xhURI = "http://www.w3.org/1999/xhtml";
    protected boolean stylesheetFO = false;
    protected DOMHelper dh = null;

    public String areaLabel(Element area) {
        NamedNodeMap domAttr = area.getAttributes();
        AttList attr = new AttList(domAttr, this.dh);
        String label = null;
        if (attr.getValue("label") != null) {
            label = attr.getValue("label");
        } else {
            Element parent = (Element)area.getParentNode();
            NamedNodeMap pdomAttr = parent.getAttributes();
            AttList pAttr = new AttList(pdomAttr, this.dh);
            if (parent != null && parent.getNodeName().equals("areaset") && pAttr.getValue("label") != null) {
                label = pAttr.getValue("label");
            }
        }
        return label;
    }

    public void startSpan(DOMBuilder rtf) throws SAXException {
        if (!this.stylesheetFO) {
            AttributesImpl spanAttr = new AttributesImpl();
            spanAttr.addAttribute("", "class", "class", "CDATA", "co");
            rtf.startElement("", "span", "span", (Attributes)spanAttr);
        }
    }

    public void endSpan(DOMBuilder rtf) throws SAXException {
        if (!this.stylesheetFO) {
            rtf.endElement("", "span", "span");
        }
    }

    public void formatTextCallout(DOMBuilder rtf, Callout callout) {
        Element area = callout.getArea();
        int num = callout.getCallout();
        String userLabel = this.areaLabel(area);
        String label = "(" + num + ")";
        if (userLabel != null) {
            label = userLabel;
        }
        char[] chars = label.toCharArray();
        try {
            this.startSpan(rtf);
            rtf.characters(chars, 0, label.length());
            this.endSpan(rtf);
        }
        catch (SAXException e) {
            System.out.println("SAX Exception in text formatCallout");
        }
    }

    public abstract void formatCallout(DOMBuilder var1, Callout var2);
}

