/*
 * This file is part of DSP Gateway version 3.3.1
 *
 * Copyright (C) 2005-2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Toshihiro Kobayashi <toshihiro.kobayashi@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <string.h>
#include <malloc.h>
#include "dsp_dld.h"
#include "dld_daemon.h"

void *dld_malloc(size_t size, char *msg)
{
	void *p = malloc(size);

#ifdef DEBUG_MALLOC
	prmsg("alloc %s: %p\n", msg, p);
#endif
	if (p == NULL)
		prmsg("out of memory! %s allocation failed.\n", msg);
	return p;
}

char *dld_strdup(char *s, char *msg)
{
	char *p = strdup(s);

#ifdef DEBUG_MALLOC
	prmsg("alloc %s: %p\n", msg, p);
#endif
	if (p == NULL)
		prmsg("out of memory! %s allocation failed.\n", msg);
	return p;
}

void dld_free(void *p, char *msg)
{
#ifdef DEBUG_MALLOC
	prmsg("free %s: %p\n", msg, p);
#endif
	free(p);
}
