/*
 * Copyright  2003 Eric Anholt
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Eric Anholt not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Eric Anholt makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * ERIC ANHOLT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL ERIC ANHOLT BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
/* $Header: /cvs/xserver/xserver/hw/kdrive/ati/ati_reg.h,v 1.18 2005/02/28 20:45:15 keithp Exp $ */

/* Many of the Radeon and Rage 128 registers are the same.
 * ATI_ should denote registers and values that are common for R128 and Radeon.
 *
 * The information in this file comes from many sources, including the Rage 128
 * DDK, Rage 128 register reference, the XFree86 and kernel Rage 128 and Radeon
 * register definition headers, and bits from the Radeon DDK and RV200 register
 * specs supplied by others.
 */

#define ATI_REG_CLOCK_CNTL_INDEX		0x0008
# define ATI_PLL_WR_EN				(1 << 7)
# define ATI_PLL_DIV_SEL			(3 << 8)

#define ATI_REG_CLOCK_CNTL_DATA			0x000c

#define ATI_REG_BUS_CNTL			0x0030
# define ATI_BUS_MASTER_DIS			(1 << 6)

#define ATI_REG_GEN_INT_CNTL			0x0040

#define ATI_REG_GEN_CNTL			0x0050
# define ATI_CRTC_DBL_SCAN_EN			(1 <<  0)   /* 0x00000001 */
# define ATI_CRTC_INTERLACE_EN			(1 <<  1)   /* 0x00000002 */
# define ATI_CRTC_CSYNC_EN			(1 <<  4)   /* 0x00000010 */
# define ATI_CRTC_PIX_WIDTH_MASK		(7 << 8)    /* 0x00000700 */
# define ATI_CRTC_CUR_EN			(1 << 16)   /* 0x00010000 */
# define ATI_CRTC_CUR_MODE_MASK			(7 << 17)   /* 0x000e0000 */
# define ATI_CRTC_ICON_EN			(1 << 20)   /* 0x00100000 */
# define ATI_CRTC_ARGB_EN			(2 << 20)   /* 0x00200000 */
# define ATI_CRTC_EXT_DISP_EN			(1 << 24)   /* 0x01000000 */
# define ATI_CRTC_EN				(1 << 25)   /* 0x02000000 */
# define ATI_CRTC_DISP_REQ_EN_B			(1 << 26)   /* 0x04000000 */

#define ATI_REG_CRTC_EXT_CNTL			0x0054
# define ATI_CRTC_EN				(1 << 25)
# define ATI_CRTC_VGA_XOVERSCAN			(1 <<  0)
# define ATI_VGA_ATI_LINEAR			(1 <<  3)
# define ATI_XCRT_CNT_EN			(1 <<  6)
# define ATI_CRTC_HSYNC_DIS			(1 <<  8)
# define ATI_CRTC_VSYNC_DIS			(1 <<  9)
# define ATI_CRTC_DISPLAY_DIS			(1 << 10)
# define RADEON_CRTC_SYNC_TRISTAT		(1 << 11)
# define ATI_CRTC_CRT_ON			(1 << 15)
# define R128_FP_OUT_EN				(1 << 22)
# define R128_FP_ACTIVE				(1 << 23)

#define ATI_REG_DAC_CNTL			0x0058
# define ATI_DAC_RANGE_CNTL			(3 <<  0)
# define ATI_DAC_BLANKING			(1 <<  2)
# define R128_DAC_CRT_SEL_CRTC2			(1 <<  4)
# define ATI_DAC_CMP_EN				(1 <<  3)
# define R128_DAC_PALETTE_ACC_CTL		(1 <<  5)
# define ATI_DAC_CMP_OUTPUT			(1 <<  7)
# define ATI_DAC_8BIT_EN			(1 <<  8)
# define ATI_DAC_VGA_ADR_EN			(1 << 13)
# define ATI_DAC_PDWN				(1 << 15)
# define ATI_DAC_MASK_ALL			(0xff << 24)

#define ATI_REG_I2C_CNTL_1			0x0094

#define R128_REG_GEN_RESET_CNTL			0x00f0
# define R128_SOFT_RESET_GUI			(1 <<  0)
# define R128_SOFT_RESET_VCLK			(1 <<  8)
# define R128_SOFT_RESET_PCLK			(1 <<  9)
# define R128_SOFT_RESET_DISPENG_XCLK		(1 << 11)
# define R128_SOFT_RESET_MEMCTLR_XCLK		(1 << 12)

#define RADEON_REG_RBBM_SOFT_RESET		0x00f0
# define RADEON_SOFT_RESET_CP			(1 <<  0)
# define RADEON_SOFT_RESET_HI			(1 <<  1)
# define RADEON_SOFT_RESET_SE			(1 <<  2)
# define RADEON_SOFT_RESET_RE			(1 <<  3)
# define RADEON_SOFT_RESET_PP			(1 <<  4)
# define RADEON_SOFT_RESET_E2			(1 <<  5)
# define RADEON_SOFT_RESET_RB			(1 <<  6)
# define RADEON_SOFT_RESET_HDP			(1 <<  7)

#define RADEON_REG_HOST_PATH_CNTL		0x0130
# define RADEON_HDP_SOFT_RESET			(1 << 26)

#define ATI_REG_AGP_BASE			0x0170

#define ATI_REG_AGP_CNTL			0x0174
# define R128_AGP_APER_SIZE_256MB		(0x00 << 0)
# define R128_AGP_APER_SIZE_128MB		(0x20 << 0)
# define R128_AGP_APER_SIZE_64MB		(0x30 << 0)
# define R128_AGP_APER_SIZE_32MB		(0x38 << 0)
# define R128_AGP_APER_SIZE_16MB		(0x3c << 0)
# define R128_AGP_APER_SIZE_8MB			(0x3e << 0)
# define R128_AGP_APER_SIZE_4MB			(0x3f << 0)
# define R128_AGP_APER_SIZE_MASK		(0x3f << 0)
# define RADEON_PENDING_SLOTS_VAL		0x00060000
# define RADEON_PENDING_SLOTS_SEL		0x00080000

#define R128_REG_PCI_GART_PAGE			0x017c

#define R128_REG_PC_NGUI_CTLSTAT		0x0184
# define R128_PC_FLUSH_GUI			(3 << 0)
# define R128_PC_RI_GUI				(1 << 2)
# define R128_PC_FLUSH_ALL			0x00ff
# define R128_PC_BUSY				(1 << 31)

#define R128_REG_VIPH_CONTROL			0x01d0

#define ATI_REG_CRTC_H_TOTAL_DISP		0x0200
#define ATI_REG_CRTC2_H_TOTAL_DISP		0x0300
# define ATI_CRTC_H_TOTAL			(0x01ff << 0)
# define ATI_CRTC_H_TOTAL_SHIFT			0
# define ATI_CRTC_H_DISP			(0x00ff << 16)
# define ATI_CRTC_H_DISP_SHIFT			16

#define ATI_REG_CRTC_H_SYNC_STRT_WID		0x0204
#define ATI_REG_CRTC2_H_SYNC_STRT_WID		0x0304
# define RADEON_CRTC_H_SYNC_STRT_PIX		(0x07  <<  0)
# define RADEON_CRTC_H_SYNC_STRT_CHAR		(0x3ff <<  3)
# define RADEON_CRTC_H_SYNC_STRT_CHAR_SHIFT	3
# define RADEON_CRTC_H_SYNC_WID			(0x3f  << 16)
# define RADEON_CRTC_H_SYNC_WID_SHIFT		16
# define RADEON_CRTC_H_SYNC_POL			(1     << 23)

#define ATI_REG_CRTC_OFFSET			0x0224
#define ATI_REG_CRTC2_OFFSET			0x0324
#define ATI_REG_CRTC_OFFSET_CNTL		0x0228
#define ATI_REG_CRTC2_OFFSET_CNTL		0x0328
#define ATI_REG_CRTC_PITCH			0x022c
#define ATI_REG_CRTC2_PITCH			0x032c

#define ATI_REG_OVR_CLR				0x0230
#define ATI_REG_OVR_WID_LEFT_RIGHT		0x0234
#define ATI_REG_OVR_WID_TOP_BOTTOM		0x0238

#define ATI_REG_CUR_OFFSET			0x0260
#define ATI_REG_CUR_HORZ_VERT_POSN		0x0264
#define ATI_REG_CUR_HORZ_VERT_OFF		0x0268
# define ATI_CUR_LOCK				(1 << 31)
# define ATI_CURSOR_WIDTH			64
# define ATI_CURSOR_HEIGHT			64
# define ATI_CURSOR_PITCH			16

#define ATI_REG_CUR_CLR0			0x026c
#define ATI_REG_CUR_CLR1			0x0270
#define ATI_REG_OV0_SCALE_CNTL			0x0420
#define ATI_REG_SUBPIC_CNTL			0x0540
#define ATI_REG_CAP0_TRIG_CNTL			0x0950
#define RADEON_REG_VIPH_CONTROL			0x0c50

#define RADEON_REG_RBBM_STATUS			0x0e40
# define RADEON_RBBM_FIFOCNT_MASK		0x007f
# define RADEON_RBBM_ACTIVE			(1 << 31)

#define ATI_REG_CCE_RB_BASE			0x0700

#define R128_REG_PM4_BUFFER_CNTL		0x0704
# define R128_PM4_IN_FRAME_BUFFER		(1  << 26)
# define R128_PM4_BUFFER_CNTL_NOUPDATE		(1  << 27)
# define R128_PM4_NONPM4			(0  << 28)
# define R128_PM4_192PIO			(1  << 28)
# define R128_PM4_192BM				(2  << 28)
# define R128_PM4_128PIO_64INDBM		(3  << 28)
# define R128_PM4_128BM_64INDBM			(4  << 28)
# define R128_PM4_64PIO_128INDBM		(5  << 28)
# define R128_PM4_64BM_128INDBM			(6  << 28)
# define R128_PM4_64PIO_64VCBM_64INDBM		(7  << 28)
# define R128_PM4_64BM_64VCBM_64INDBM		(8  << 28)
# define R128_PM4_64PIO_64VCPIO_64INDPIO	(15 << 28)

#define RADEON_REG_CP_RB_CNTL			0x0704

#define R128_REG_PM4_BUFFER_WM_CNTL		0x0708
# define R128_WMA_SHIFT				0
# define R128_WMB_SHIFT				8
# define R128_WMC_SHIFT				16
# define R128_WB_WM_SHIFT			24

#define ATI_REG_CCE_RPTR_ADDR			0x070c
#define ATI_REG_CCE_RPTR			0x0710
#define ATI_REG_CCE_WPTR			0x0714
# define R128_PM4_BUFFER_DL_DONE		(1 << 31)

#define R128_REG_PM4_VC_FPU_SETUP		0x071c
# define R128_FRONT_DIR_CW			(0 <<  0)
# define R128_FRONT_DIR_CCW			(1 <<  0)
# define R128_FRONT_DIR_MASK			(1 <<  0)
# define R128_BACKFACE_CULL			(0 <<  1)
# define R128_BACKFACE_POINTS			(1 <<  1)
# define R128_BACKFACE_LINES			(2 <<  1)
# define R128_BACKFACE_SOLID			(3 <<  1)
# define R128_BACKFACE_MASK			(3 <<  1)
# define R128_FRONTFACE_CULL			(0 <<  3)
# define R128_FRONTFACE_POINTS			(1 <<  3)
# define R128_FRONTFACE_LINES			(2 <<  3)
# define R128_FRONTFACE_SOLID			(3 <<  3)
# define R128_FRONTFACE_MASK			(3 <<  3)
# define R128_FPU_COLOR_SOLID			(0 <<  5)
# define R128_FPU_COLOR_FLAT			(1 <<  5)
# define R128_FPU_COLOR_GOURAUD			(2 <<  5)
# define R128_FPU_COLOR_GOURAUD2		(3 <<  5)
# define R128_FPU_COLOR_MASK			(3 <<  5)
# define R128_FPU_SUB_PIX_2BITS			(0 <<  7)
# define R128_FPU_SUB_PIX_4BITS			(1 <<  7)
# define R128_FPU_MODE_2D			(0 <<  8)
# define R128_FPU_MODE_3D			(1 <<  8)
# define R128_TRAP_BITS_DISABLE			(1 <<  9)
# define R128_EDGE_ANTIALIAS			(1 << 10)
# define R128_SUPERSAMPLE			(1 << 11)
# define R128_XFACTOR_2				(0 << 12)
# define R128_XFACTOR_4				(1 << 12)
# define R128_YFACTOR_2				(0 << 13)
# define R128_YFACTOR_4				(1 << 13)
# define R128_FLAT_SHADE_VERTEX_D3D		(0 << 14)
# define R128_FLAT_SHADE_VERTEX_OGL		(1 << 14)
# define R128_FPU_ROUND_TRUNCATE		(0 << 15)
# define R128_FPU_ROUND_NEAREST			(1 << 15)
# define R128_WM_SEL_8DW			(0 << 16)
# define R128_WM_SEL_16DW			(1 << 16)
# define R128_WM_SEL_32DW			(2 << 16)

#define R128_REG_PM4_IW_INDOFF			0x0738
#define R128_REG_PM4_IW_INDSIZE			0x073c

#define RADEON_REG_CP_CSQ_CNTL			0x0740
# define RADEON_CSQ_CNT_PRIMARY_MASK		0x000000ff
# define RADEON_CSQ_CNT_INDIRECT_MASK		0x0000ff00
# define R200_CSQ_CNT_PRIMARY_MASK		0x000001ff
# define R200_CSQ_CNT_INDIRECT_MASK		0x0003fe00
# define RADEON_CSQ_PRIDIS_INDDIS		(0 << 28)
# define RADEON_CSQ_PRIPIO_INDDIS		(1 << 28)
# define RADEON_CSQ_PRIBM_INDDIS		(2 << 28)
# define RADEON_CSQ_PRIPIO_INDBM		(3 << 28)
# define RADEON_CSQ_PRIBM_INDBM			(4 << 28)
# define RADEON_CSQ_PRIPIO_INDPIO		(15 << 28)

#define R128_REG_PM4_STAT			0x07b8
# define R128_PM4_FIFOCNT_MASK			0x00000fff
# define R128_PM4_BUSY				(1 << 16)
# define R128_PM4_GUI_ACTIVE			(1 << 31)

#define RADEON_REG_CP_STAT			0x07c0
# define RADEON_CSQ_PRIMARY_BUSY		(1 << 10)
# define RADEON_CSQ_INDIRECT_BUSY		(1 << 11)

#define RADEON_REG_ME_CNTL			0x07d0
# define RADEON_ME_MODE_FREE_RUN		(1 << 30)

#define ATI_REG_MICROCODE_RAM_ADDR		0x07d4
#define ATI_REG_MICROCODE_RAM_RADDR		0x07d8
#define ATI_REG_MICROCODE_RAM_DATAH		0x07dc
#define ATI_REG_MICROCODE_RAM_DATAL		0x07e0
#define R128_REG_PM4_BUFFER_ADDR		0x07f0

#define RADEON_REG_CP_CSQ_STAT			0x07f8
# define RADEON_CSQ_RPTR_PRIMARY_MASK		(0xff <<  0)
# define RADEON_CSQ_WPTR_PRIMARY_MASK		(0xff <<  8)
# define RADEON_CSQ_RPTR_INDIRECT_MASK		(0xff << 16)
# define RADEON_CSQ_WPTR_INDIRECT_MASK		(0xff << 24)
# define R200_CSQ_RPTR_PRIMARY_MASK		(0x1ff <<  0)
# define R200_CSQ_WPTR_PRIMARY_MASK		(0x1ff <<  9)

#define R128_REG_PM4_MICRO_CNTL			0x07fc
# define R128_PM4_MICRO_FREERUN			(1 << 30)

#define RADEON_TV_MASTER_CNTL                    0x0800
# define RADEON_TV_MACROVISION			(1 << 5)
# define RADEON_TVCLK_ALWAYS_ON           	(1 << 30)

#define R128_REG_BM_CHUNK_0_VAL			0x0a18
# define R128_BM_PTR_FORCE_TO_PCI		(1 << 21)
# define R128_BM_PM4_RD_FORCE_TO_PCI		(1 << 22)
# define R128_BM_GLOBAL_FORCE_TO_PCI		(1 << 23)

/* Offset of the PCI config space mirror */
#define ATI_PCI_CFG_OFFSET			0x0f00

#define ATI_REG_PCI_CFG_STATUS			0x0f06
# define ATI_CAP_LIST				0x0010

#define ATI_REG_PCI_CFG_CAPABILITIES_PTR	0x0f34
# define ATI_CAP_PTR_MASK			0x00fc
# define ATI_CAP_ID_NULL			0x0000 /* End of capability list */
# define ATI_CAP_ID_AGP				0x0002 /* AGP capability ID */

#define R128_REG_AGP_STATUS			0x0f54 /* PCI */
# define R128_AGP_1X_MODE			0x01
# define R128_AGP_2X_MODE			0x02
# define R128_AGP_4X_MODE			0x04
# define R128_AGP_MODE_MASK			0x07

#define R128_REG_AGP_COMMAND			0x0f58
# define R128_AGP_ENABLE			(1 << 8)

#define RADEON_REG_AGP_STATUS			0x0f5c /* PCI */
# define RADEON_AGP_1X_MODE			0x01
# define RADEON_AGP_2X_MODE			0x02
# define RADEON_AGP_4X_MODE			0x04
# define RADEON_AGP_FW_MODE			0x10
# define RADEON_AGP_MODE_MASK			0x17

#define RADEON_REG_AGP_COMMAND			0x0f60
# define RADEON_AGP_ENABLE			(1 << 8)

#define R128_REG_PM4_FIFO_DATA_EVEN		0x1000
#define R128_REG_PM4_FIFO_DATA_ODD		0x1004

#define RADEON_REG_CSQ_APER_PRIMARY		0x1000
#define RADEON_REG_CSQ_APER_PRIMARY_END		0x11fc
#define RADEON_REG_CSQ_APER_INDIRECT		0x1300
#define RADEON_REG_CSQ_APER_INDIRECT_END	0x13fc
#define ATI_REG_SRC_PITCH_OFFSET		0x1428
#define ATI_REG_DST_PITCH_OFFSET		0x142c
#define ATI_REG_SRC_Y_X				0x1434
#define ATI_REG_DST_Y_X				0x1438
#define ATI_REG_DST_HEIGHT_WIDTH		0x143c

#define ATI_REG_DP_GUI_MASTER_CNTL		0x146c
# define ATI_GMC_SRC_PITCH_OFFSET_CNTL		(1  <<  0)
# define ATI_GMC_DST_PITCH_OFFSET_CNTL		(1  <<  1)
# define ATI_GMC_SRC_CLIPPING			(1  <<  2)
# define ATI_GMC_DST_CLIPPING			(1  <<  3)
# define ATI_GMC_BRUSH_SOLID_COLOR		(13 <<  4)
# define ATI_GMC_BRUSH_NONE			(15 <<  4)
# define ATI_GMC_BRUSH_MASK			(15 <<  4)
# define ATI_GMC_DST_DATATYPE_MASK		(0xf <<  8)
# define ATI_GMC_SRC_DATATYPE_COLOR		(3  << 12)
# define R128_GMC_CONVERSION_TEMP		(1  << 15)
# define R128_GMC_CONVERSION_TEMP_6500		(0  << 15)
# define R128_GMC_CONVERSION_TEMP_9300		(1  << 15)
# define ATI_GMC_ROP3_MASK			(0xff << 16)
# define ATI_DP_SRC_SOURCE_MEMORY		(2  << 24)
# define ATI_DP_SRC_SOURCE_HOST_DATA		(3  << 24)
# define R128_GMC_3D_FCN_EN			(1  << 27)
# define ATI_GMC_CLR_CMP_CNTL_DIS		(1  << 28)
# define R128_GMC_AUX_CLIP_DIS			(1  << 29)
# define ATI_GMC_WR_MSK_DIS			(1  << 30)
# define R128_GMC_LD_BRUSH_Y_X			(1  << 31)

#define ATI_REG_DP_BRUSH_FRGD_CLR		0x147c
#define ATI_REG_DST_WIDTH_HEIGHT		0x1598
#define ATI_REG_CLR_CMP_CNTL			0x15c0

#define R128_REG_AUX_SC_CNTL			0x1660
# define R128_AUX1_SC_ENB			(1 << 0)
# define R128_AUX1_SC_MODE_SUB			(1 << 1)
# define R128_AUX2_SC_ENB			(1 << 0)
# define R128_AUX2_SC_MODE_SUB			(1 << 1)
# define R128_AUX3_SC_ENB			(1 << 0)
# define R128_AUX3_SC_MODE_SUB			(1 << 1)

#define R128_REG_AUX1_SC_LEFT			0x1664
#define R128_REG_AUX1_SC_RIGHT			0x1668
#define R128_REG_AUX1_SC_TOP			0x166c
#define R128_REG_AUX1_SC_BOTTOM			0x1670
#define R128_REG_AUX2_SC_LEFT			0x1674
#define R128_REG_AUX2_SC_RIGHT			0x1678
#define R128_REG_AUX2_SC_TOP			0x167c
#define R128_REG_AUX2_SC_BOTTOM			0x1680
#define R128_REG_AUX3_SC_LEFT			0x1684
#define R128_REG_AUX3_SC_RIGHT			0x1688
#define R128_REG_AUX3_SC_TOP			0x168c
#define R128_REG_AUX3_SC_BOTTOM			0x1690

#define ATI_REG_DP_CNTL				0x16c0
# define ATI_DST_X_LEFT_TO_RIGHT		(1 <<  0)
# define ATI_DST_Y_TOP_TO_BOTTOM		(1 <<  1)

#define ATI_REG_DP_MIX				0x16c8
#define ATI_REG_DP_WRITE_MASK			0x16cc
#define ATI_REG_DEFAULT_OFFSET			0x16e0
#define ATI_REG_DEFAULT_PITCH			0x16e4

#define ATI_REG_DEFAULT_SC_BOTTOM_RIGHT		0x16e8
# define ATI_DEFAULT_SC_RIGHT_MAX		0x00001fff
# define ATI_DEFAULT_SC_BOTTOM_MAX		0x1fff0000

#define ATI_REG_SC_TOP_LEFT			0x16ec
#define ATI_REG_SC_BOTTOM_RIGHT			0x16f0

#define ATI_REG_WAIT_UNTIL			0x1720
# define ATI_WAIT_CRTC_PFLIP			(1 << 0)
# define ATI_WAIT_RE_CRTC_VLINE			(1 << 1)
# define ATI_WAIT_FE_CRTC_VLINE			(1 << 2)
# define ATI_WAIT_CRTC_VLINE			(1 << 3)
# define ATI_WAIT_DMA_VIPH0_IDLE		(1 << 4)
# define ATI_WAIT_DMA_VIPH1_IDLE		(1 << 5)
# define ATI_WAIT_DMA_VIPH2_IDLE		(1 << 6)
# define ATI_WAIT_DMA_VIPH3_IDLE		(1 << 7)
# define ATI_WAIT_DMA_VID_IDLE			(1 << 8)
# define ATI_WAIT_DMA_GUI_IDLE			(1 << 9)
# define ATI_WAIT_CMDFIFO			(1 << 10)
# define ATI_WAIT_OV0_FLIP			(1 << 11)
# define RADEON_WAIT_OV0_SLICEDONE		(1 << 12)
# define RADEON_WAIT_2D_IDLE			(1 << 14)
# define RADEON_WAIT_3D_IDLE			(1 << 15)
# define RADEON_WAIT_2D_IDLECLEAN		(1 << 16)
# define RADEON_WAIT_3D_IDLECLEAN		(1 << 17)
# define RADEON_WAIT_HOST_IDLECLEAN		(1 << 18)
# define ATI_WAIT_CMDFIFO_ENTRIES		(0x07f00000)
# define RADEON_WAIT_BOTH_CRTC_PFLIP		(1 << 30)
# define RADEON_ENG_DISPLAY_SELECT		(1 << 31)

#define RADEON_REG_ISYNC_CNTL			0x1724
#define ISYNC_ANY2D_IDLE3D			0x1
#define ISYNC_ANY3D_IDLE2D			0x2

#define R128_REG_GUI_STAT			0x1740
# define R128_GUI_ACTIVE			(1 << 31)

#define R128_REG_PC_GUI_MODE			0x1744
#define R128_PC_GUI_PRIORITY			(1 << 0)
#define R128_PC_RISE_DF_EN			(1 << 1)
#define R128_PC_FALL_DF_EN			(1 << 2)
#define R128_PC_BYPASS_EN			(1 << 3)
#define R128_PC_CACHE_SIZE			(1 << 4)
#define R128_PC_IGNORE_UNIFY			(1 << 5)
#define R128_PC_IGNORE_WRHINT			(1 << 6)
#define R128_PC_IGNORE_RDHINT			(1 << 7)
#define R128_PC_RISE_DP_EN			(1 << 8)

#define R128_REG_PC_GUI_CTLSTAT			0x1748
/* bits match R128_REG_PC_NGUI_CTLSTAT */

#define R128_REG_TEX_CNTL			0x1800
#define R128_REG_SECONDARY_SCALE_OFFSET		0x1980
#define R128_REG_SECONDARY_SCALE_PITCH		0x1980
#define R128_REG_SECONDARY_SCALE_X_INC		0x1984
#define R128_REG_SECONDARY_SCALE_Y_INC		0x1988
#define R128_REG_SECONDARY_SCALE_HACC		0x198c
#define R128_REG_SECONDARY_SCALE_VACC		0x1990
#define R128_REG_SCALE_SRC_HEIGHT_WIDTH		0x1994
#define R128_REG_SCALE_OFFSET_0			0x1998
#define R128_REG_SCALE_PITCH			0x199c
#define R128_REG_SCALE_X_INC			0x19a0
#define R128_REG_SCALE_Y_INC			0x19a4
#define R128_REG_SCALE_HACC			0x19a8
#define R128_REG_SCALE_VACC			0x19ac
#define R128_REG_SCALE_DST_X_Y			0x19b0
#define R128_REG_SCALE_DST_HEIGHT_WIDTH		0x19b4

#define R128_REG_SCALE_3D_CNTL			0x1a00
# define R128_SCALE_DITHER_ERR_DIFF		(0  <<  1)
# define R128_SCALE_DITHER_TABLE		(1  <<  1)
# define R128_TEX_CACHE_SIZE_FULL		(0  <<  2)
# define R128_TEX_CACHE_SIZE_HALF		(1  <<  2)
# define R128_DITHER_INIT_CURR			(0  <<  3)
# define R128_DITHER_INIT_RESET			(1  <<  3)
# define R128_ROUND_24BIT			(1  <<  4)
# define R128_TEX_CACHE_DISABLE			(1  <<  5)
# define R128_SCALE_3D_NOOP			(0  <<  6)
# define R128_SCALE_3D_SCALE			(1  <<  6)
# define R128_SCALE_3D_TEXMAP_SHADE		(2  <<  6)
# define R128_SCALE_PIX_BLEND			(0  <<  8)
# define R128_SCALE_PIX_REPLICATE		(1  <<  8)
# define R128_TEX_CACHE_SPLIT			(1  <<  9)
# define R128_APPLE_YUV_MODE			(1  << 10)
# define R128_TEX_CACHE_PALLETE_MODE		(1  << 11)
# define R128_ALPHA_COMB_ADD_CLAMP		(0  << 12)
# define R128_ALPHA_COMB_ADD_NCLAMP		(1  << 12)
# define R128_ALPHA_COMB_SUB_DST_SRC_CLAMP	(2  << 12)
# define R128_ALPHA_COMB_SUB_DST_SRC_NCLAMP	(3  << 12)
# define R128_FOG_TABLE				(1  << 14)
# define R128_SIGNED_DST_CLAMP			(1  << 15)
/* Alpha bits from R128_REG_MISC_3D_CNTL */
# define R128_COMPOSITE_SHADOW_CMP_EQUAL	(0  << 28)
# define R128_COMPOSITE_SHADOW_CMP_NEQUAL	(1  << 28)
# define R128_COMPOSITE_SHADOW			(1  << 29)
# define R128_TEX_MAP_ALPHA_IN_TEXTURE		(1  << 30)
# define R128_TEX_CACHE_LINE_SIZE_8QW		(0  << 31)
# define R128_TEX_CACHE_LINE_SIZE_4QW		(1  << 31)

#define R128_REG_SCALE_3D_DATATYPE		0x1a20

#define R128_REG_SETUP_CNTL			0x1bc4
# define R128_DONT_START_TRIANGLE		(1 <<  0)
# define R128_Z_BIAS				(0 <<  1)
# define R128_DONT_START_ANY_ON			(1 <<  2)
# define R128_COLOR_SOLID_COLOR			(0 <<  3)
# define R128_COLOR_FLAT_VERT_1			(1 <<  3)
# define R128_COLOR_FLAT_VERT_2			(2 <<  3)
# define R128_COLOR_FLAT_VERT_3			(3 <<  3)
# define R128_COLOR_GOURAUD			(4 <<  3)
# define R128_PRIM_TYPE_TRI			(0 <<  7)
# define R128_PRIM_TYPE_LINE			(1 <<  7)
# define R128_PRIM_TYPE_POINT			(2 <<  7)
# define R128_PRIM_TYPE_POLY_EDGE		(3 <<  7)
# define R128_TEXTURE_ST_MULT_W			(0 <<  9)
# define R128_TEXTURE_ST_DIRECT			(1 <<  9)
# define R128_STARTING_VERTEX_1			(1 << 14)
# define R128_STARTING_VERTEX_2			(2 << 14)
# define R128_STARTING_VERTEX_3			(3 << 14)
# define R128_ENDING_VERTEX_1			(1 << 16)
# define R128_ENDING_VERTEX_2			(2 << 16)
# define R128_ENDING_VERTEX_3			(3 << 16)
# define R128_SU_POLY_LINE_LAST			(0 << 18)
# define R128_SU_POLY_LINE_NOT_LAST		(1 << 18)
# define R128_SUB_PIX_2BITS			(0 << 19)
# define R128_SUB_PIX_4BITS			(1 << 19)
# define R128_SET_UP_CONTINUE			(1 << 31)

#define R128_REG_WINDOW_XY_OFFSET		0x1bcc

#define RADEON_REG_RB3D_BLENDCNTL		0x1c20
# define RADEON_COMB_FCN_MASK			(3  << 12)
# define RADEON_COMB_FCN_ADD_CLAMP		(0  << 12)
# define RADEON_COMB_FCN_ADD_NOCLAMP		(1  << 12)
# define RADEON_COMB_FCN_SUB_CLAMP		(2  << 12)
# define RADEON_COMB_FCN_SUB_NOCLAMP		(3  << 12)
# define R200_COMB_FCN_MIN			(4  << 12)
# define R200_COMB_FCN_MAX			(5  << 12)
# define R200_COMB_FCN_RSUB_CLAMP		(6  << 12)
# define R200_COMB_FCN_RSUB_NOCLAMP		(7  << 12)
# define RADEON_SBLEND_GL_ZERO			(32 << 16)
# define RADEON_SBLEND_GL_ONE			(33 << 16)
# define RADEON_SBLEND_GL_SRC_COLOR		(34 << 16)
# define RADEON_SBLEND_GL_INV_SRC_COLOR		(35 << 16)
# define RADEON_SBLEND_GL_DST_COLOR		(36 << 16)
# define RADEON_SBLEND_GL_INV_DST_COLOR		(37 << 16)
# define RADEON_SBLEND_GL_SRC_ALPHA		(38 << 16)
# define RADEON_SBLEND_GL_INV_SRC_ALPHA		(39 << 16)
# define RADEON_SBLEND_GL_DST_ALPHA		(40 << 16)
# define RADEON_SBLEND_GL_INV_DST_ALPHA		(41 << 16)
# define RADEON_SBLEND_GL_SRC_ALPHA_SATURATE	(42 << 16)
# define R200_SBLEND_GL_CONST_COLOR		(43 << 16)
# define R200_SBLEND_GL_ONE_MINUS_CONST_COLOR	(44 << 16)
# define R200_SBLEND_GL_CONST_ALPHA		(45 << 16)
# define R200_SBLEND_GL_ONE_MINUS_CONST_ALPHA	(46 << 16)
# define RADEON_SBLEND_MASK			(63 << 16)
# define RADEON_DBLEND_GL_ZERO			(32 << 24)
# define RADEON_DBLEND_GL_ONE			(33 << 24)
# define RADEON_DBLEND_GL_SRC_COLOR		(34 << 24)
# define RADEON_DBLEND_GL_INV_SRC_COLOR		(35 << 24)
# define RADEON_DBLEND_GL_DST_COLOR		(36 << 24)
# define RADEON_DBLEND_GL_INV_DST_COLOR		(37 << 24)
# define RADEON_DBLEND_GL_SRC_ALPHA		(38 << 24)
# define RADEON_DBLEND_GL_INV_SRC_ALPHA		(39 << 24)
# define RADEON_DBLEND_GL_DST_ALPHA		(40 << 24)
# define RADEON_DBLEND_GL_INV_DST_ALPHA		(41 << 24)
# define R200_DBLEND_GL_CONST_COLOR		(43 << 24)
# define R200_DBLEND_GL_ONE_MINUS_CONST_COLOR	(44 << 24)
# define R200_DBLEND_GL_CONST_ALPHA		(45 << 24)
# define R200_DBLEND_GL_ONE_MINUS_CONST_ALPHA	(46 << 24)
# define RADEON_DBLEND_MASK			(63 << 24)

#define RADEON_REG_PP_CNTL			0x1c38
# define RADEON_STIPPLE_ENABLE			(1 <<  0)
# define RADEON_SCISSOR_ENABLE			(1 <<  1)
# define RADEON_PATTERN_ENABLE			(1 <<  2)
# define RADEON_SHADOW_ENABLE			(1 <<  3)
# define RADEON_TEX_ENABLE_MASK			(0xf << 4)
# define RADEON_TEX_0_ENABLE			(1 <<  4)
# define RADEON_TEX_1_ENABLE			(1 <<  5)
# define RADEON_TEX_2_ENABLE			(1 <<  6)
# define RADEON_TEX_3_ENABLE			(1 <<  7)
# define R200_TEX_4_ENABLE			(1 <<  8)
# define R200_TEX_5_ENABLE			(1 <<  9)
# define RADEON_TEX_BLEND_ENABLE_MASK		(0xf << 12)
# define RADEON_TEX_BLEND_0_ENABLE		(1 << 12)
# define RADEON_TEX_BLEND_1_ENABLE		(1 << 13)
# define RADEON_TEX_BLEND_2_ENABLE		(1 << 14)
# define RADEON_TEX_BLEND_3_ENABLE		(1 << 15)
# define R200_TEX_BLEND_4_ENABLE		(1 << 16)
# define R200_TEX_BLEND_5_ENABLE		(1 << 17)
# define R200_TEX_BLEND_6_ENABLE		(1 << 18)
# define RADEON_PLANAR_YUV_ENABLE		(1 << 20)
# define RADEON_SPECULAR_ENABLE			(1 << 21)
# define RADEON_FOG_ENABLE			(1 << 22)
# define RADEON_ALPHA_TEST_ENABLE		(1 << 23)
# define RADEON_ANTI_ALIAS_NONE			(0 << 24)
# define RADEON_ANTI_ALIAS_LINE			(1 << 24)
# define RADEON_ANTI_ALIAS_POLY			(2 << 24)
# define RADEON_ANTI_ALIAS_LINE_POLY		(3 << 24)
# define RADEON_BUMP_MAP_ENABLE			(1 << 26)
# define RADEON_BUMPED_MAP_T0			(0 << 27)
# define RADEON_BUMPED_MAP_T1			(1 << 27)
# define RADEON_BUMPED_MAP_T2			(2 << 27)
# define RADEON_TEX_3D_ENABLE_0			(1 << 29)
# define RADEON_TEX_3D_ENABLE_1			(1 << 30)
# define RADEON_MC_ENABLE			(1 << 31)

#define RADEON_REG_RB3D_CNTL			0x1c3c
# define RADEON_ALPHA_BLEND_ENABLE		(1  <<  0)
# define RADEON_PLANE_MASK_ENABLE		(1  <<  1)
# define RADEON_DITHER_ENABLE			(1  <<  2)
# define RADEON_ROUND_ENABLE			(1  <<  3)
# define RADEON_SCALE_DITHER_ENABLE		(1  <<  4)
# define RADEON_DITHER_INIT			(1  <<  5)
# define RADEON_ROP_ENABLE			(1  <<  6)
# define RADEON_STENCIL_ENABLE			(1  <<  7)
# define RADEON_Z_ENABLE			(1  <<  8)
# define RADEON_DEPTH_XZ_OFFEST_ENABLE		(1  <<  9)
# define RADEON_COLOR_FORMAT_ARGB1555		(3  << 10)
# define RADEON_COLOR_FORMAT_RGB565		(4  << 10)
# define RADEON_COLOR_FORMAT_ARGB8888		(6  << 10)
# define RADEON_COLOR_FORMAT_RGB332		(7  << 10)
# define RADEON_COLOR_FORMAT_Y8			(8  << 10)
# define RADEON_COLOR_FORMAT_RGB8		(9  << 10)
# define RADEON_COLOR_FORMAT_YUV422_VYUY	(11 << 10)
# define RADEON_COLOR_FORMAT_YUV422_YVYU	(12 << 10)
# define RADEON_COLOR_FORMAT_aYUV444		(14 << 10)
# define RADEON_COLOR_FORMAT_ARGB4444		(15 << 10)
# define RADEON_CLRCMP_FLIP_ENABLE		(1  << 14)

#define RADEON_REG_RB3D_COLOROFFSET		0x1c40
# define RADEON_COLOROFFSET_MASK		0xfffffff0

#define RADEON_REG_RE_WIDTH_HEIGHT		0x1c44

#define RADEON_REG_RB3D_COLORPITCH		0x1c48
# define RADEON_COLORPITCH_MASK			0x000001ff8
# define RADEON_COLOR_TILE_ENABLE		(1 << 16)
# define RADEON_COLOR_MICROTILE_ENABLE		(1 << 17)
# define RADEON_COLOR_ENDIAN_NO_SWAP		(0 << 18)
# define RADEON_COLOR_ENDIAN_WORD_SWAP		(1 << 18)
# define RADEON_COLOR_ENDIAN_DWORD_SWAP		(2 << 18)

#define RADEON_REG_SE_CNTL			0x1c4c
# define RADEON_FFACE_CULL_CW			(0 <<  0)
# define RADEON_FFACE_CULL_CCW			(1 <<  0)
# define RADEON_FFACE_CULL_DIR_MASK		(1 <<  0)
# define RADEON_BFACE_CULL			(0 <<  1)
# define RADEON_BFACE_SOLID			(3 <<  1)
# define RADEON_FFACE_CULL			(0 <<  3)
# define RADEON_FFACE_SOLID			(3 <<  3)
# define RADEON_FFACE_CULL_MASK			(3 <<  3)
# define RADEON_BADVTX_CULL_DISABLE		(1 <<  5)
# define RADEON_FLAT_SHADE_VTX_0		(0 <<  6)
# define RADEON_FLAT_SHADE_VTX_1		(1 <<  6)
# define RADEON_FLAT_SHADE_VTX_2		(2 <<  6)
# define RADEON_FLAT_SHADE_VTX_LAST		(3 <<  6)
# define RADEON_DIFFUSE_SHADE_SOLID		(0 <<  8)
# define RADEON_DIFFUSE_SHADE_FLAT		(1 <<  8)
# define RADEON_DIFFUSE_SHADE_GOURAUD		(2 <<  8)
# define RADEON_DIFFUSE_SHADE_MASK		(3 <<  8)
# define RADEON_ALPHA_SHADE_SOLID		(0 << 10)
# define RADEON_ALPHA_SHADE_FLAT		(1 << 10)
# define RADEON_ALPHA_SHADE_GOURAUD		(2 << 10)
# define RADEON_ALPHA_SHADE_MASK		(3 << 10)
# define RADEON_SPECULAR_SHADE_SOLID		(0 << 12)
# define RADEON_SPECULAR_SHADE_FLAT		(1 << 12)
# define RADEON_SPECULAR_SHADE_GOURAUD		(2 << 12)
# define RADEON_SPECULAR_SHADE_MASK		(3 << 12)
# define RADEON_FOG_SHADE_SOLID			(0 << 14)
# define RADEON_FOG_SHADE_FLAT			(1 << 14)
# define RADEON_FOG_SHADE_GOURAUD		(2 << 14)
# define RADEON_FOG_SHADE_MASK			(3 << 14)
# define RADEON_ZBIAS_ENABLE_POINT		(1 << 16)
# define RADEON_ZBIAS_ENABLE_LINE		(1 << 17)
# define RADEON_ZBIAS_ENABLE_TRI		(1 << 18)
# define RADEON_WIDELINE_ENABLE			(1 << 20)
# define RADEON_VPORT_XY_XFORM_ENABLE		(1 << 24)
# define RADEON_VPORT_Z_XFORM_ENABLE		(1 << 25)
# define RADEON_VTX_PIX_CENTER_D3D		(0 << 27)
# define RADEON_VTX_PIX_CENTER_OGL		(1 << 27)
# define RADEON_ROUND_MODE_TRUNC		(0 << 28)
# define RADEON_ROUND_MODE_ROUND		(1 << 28)
# define RADEON_ROUND_MODE_ROUND_EVEN		(2 << 28)
# define RADEON_ROUND_MODE_ROUND_ODD		(3 << 28)
# define RADEON_ROUND_PREC_16TH_PIX		(0 << 30)
# define RADEON_ROUND_PREC_8TH_PIX		(1 << 30)
# define RADEON_ROUND_PREC_4TH_PIX		(2 << 30)
# define RADEON_ROUND_PREC_HALF_PIX		(3 << 30)

#define R200_REG_RE_CNTL			0x1c50 

#define RADEON_REG_SE_COORD_FMT			0x1c50
# define RADEON_VTX_XY_PRE_MULT_1_OVER_W0	(1 <<  0)
# define RADEON_VTX_Z_PRE_MULT_1_OVER_W0	(1 <<  1)
# define RADEON_VTX_ST0_NONPARAMETRIC		(1 <<  8)
# define RADEON_VTX_ST1_NONPARAMETRIC		(1 <<  9)
# define RADEON_VTX_ST2_NONPARAMETRIC		(1 << 10)
# define RADEON_VTX_ST3_NONPARAMETRIC		(1 << 11)
# define RADEON_VTX_W0_NORMALIZE		(1 << 12)
# define RADEON_VTX_W0_IS_NOT_1_OVER_W0		(1 << 16)
# define RADEON_VTX_ST0_PRE_MULT_1_OVER_W0	(1 << 17)
# define RADEON_VTX_ST1_PRE_MULT_1_OVER_W0	(1 << 19)
# define RADEON_VTX_ST2_PRE_MULT_1_OVER_W0	(1 << 21)
# define RADEON_VTX_ST3_PRE_MULT_1_OVER_W0	(1 << 23)
# define RADEON_TEX1_W_ROUTING_USE_W0		(0 << 26)
# define RADEON_TEX1_W_ROUTING_USE_Q1		(1 << 26)

#define RADEON_REG_PP_TXFILTER_0		0x1c54
#define RADEON_REG_PP_TXFILTER_1		0x1c6c
#define RADEON_REG_PP_TXFILTER_2		0x1c84
# define RADEON_MAG_FILTER_NEAREST		(0  <<  0)
# define RADEON_MAG_FILTER_LINEAR		(1  <<  0)
# define RADEON_MAG_FILTER_MASK			(1  <<  0)
# define RADEON_MIN_FILTER_NEAREST		(0  <<  1)
# define RADEON_MIN_FILTER_LINEAR		(1  <<  1)
# define RADEON_MIN_FILTER_NEAREST_MIP_NEAREST	(2  <<  1)
# define RADEON_MIN_FILTER_NEAREST_MIP_LINEAR	(3  <<  1)
# define RADEON_MIN_FILTER_LINEAR_MIP_NEAREST	(6  <<  1)
# define RADEON_MIN_FILTER_LINEAR_MIP_LINEAR	(7  <<  1)
# define RADEON_MIN_FILTER_ANISO_NEAREST	(8  <<  1)
# define RADEON_MIN_FILTER_ANISO_LINEAR		(9  <<  1)
# define RADEON_MIN_FILTER_ANISO_NEAREST_MIP_NEAREST	(10 <<  1)
# define RADEON_MIN_FILTER_ANISO_NEAREST_MIP_LINEAR	(11 <<  1)
# define RADEON_MIN_FILTER_MASK			(15 <<  1)
# define RADEON_MAX_ANISO_1_TO_1		(0  <<  5)
# define RADEON_MAX_ANISO_2_TO_1		(1  <<  5)
# define RADEON_MAX_ANISO_4_TO_1		(2  <<  5)
# define RADEON_MAX_ANISO_8_TO_1		(3  <<  5)
# define RADEON_MAX_ANISO_16_TO_1		(4  <<  5)
# define RADEON_MAX_ANISO_MASK			(7  <<  5)
# define RADEON_LOD_BIAS_MASK			(0xff <<  8)
# define RADEON_LOD_BIAS_SHIFT			8
# define RADEON_MAX_MIP_LEVEL_MASK		(0x0f << 16)
# define RADEON_MAX_MIP_LEVEL_SHIFT		16
# define RADEON_YUV_TO_RGB			(1  << 20)
# define RADEON_YUV_TEMPERATURE_COOL		(0  << 21)
# define RADEON_YUV_TEMPERATURE_HOT		(1  << 21)
# define RADEON_YUV_TEMPERATURE_MASK		(1  << 21)
# define RADEON_WRAPEN_S			(1  << 22)
# define RADEON_CLAMP_S_WRAP			(0  << 23)
# define RADEON_CLAMP_S_MIRROR			(1  << 23)
# define RADEON_CLAMP_S_CLAMP_LAST		(2  << 23)
# define RADEON_CLAMP_S_MIRROR_CLAMP_LAST	(3  << 23)
# define RADEON_CLAMP_S_CLAMP_BORDER		(4  << 23)
# define RADEON_CLAMP_S_MIRROR_CLAMP_BORDER	(5  << 23)
# define RADEON_CLAMP_S_CLAMP_GL		(6  << 23)
# define RADEON_CLAMP_S_MIRROR_CLAMP_GL		(7  << 23)
# define RADEON_CLAMP_S_MASK			(7  << 23)
# define RADEON_WRAPEN_T			(1  << 26)
# define RADEON_CLAMP_T_WRAP			(0  << 27)
# define RADEON_CLAMP_T_MIRROR			(1  << 27)
# define RADEON_CLAMP_T_CLAMP_LAST		(2  << 27)
# define RADEON_CLAMP_T_MIRROR_CLAMP_LAST	(3  << 27)
# define RADEON_CLAMP_T_CLAMP_BORDER		(4  << 27)
# define RADEON_CLAMP_T_MIRROR_CLAMP_BORDER	(5  << 27)
# define RADEON_CLAMP_T_CLAMP_GL		(6  << 27)
# define RADEON_CLAMP_T_MIRROR_CLAMP_GL		(7  << 27)
# define RADEON_CLAMP_T_MASK			(7  << 27)
# define RADEON_BORDER_MODE_OGL			(0  << 31)
# define RADEON_BORDER_MODE_D3D			(1  << 31)

#define RADEON_REG_PP_TXFORMAT_0		0x1c58
#define RADEON_REG_PP_TXFORMAT_1		0x1c70
#define RADEON_REG_PP_TXFORMAT_2		0x1c88
# define RADEON_TXFORMAT_I8			(0  <<  0)
# define RADEON_TXFORMAT_AI88			(1  <<  0)
# define RADEON_TXFORMAT_RGB332			(2  <<  0)
# define RADEON_TXFORMAT_ARGB1555		(3  <<  0)
# define RADEON_TXFORMAT_RGB565			(4  <<  0)
# define RADEON_TXFORMAT_ARGB4444		(5  <<  0)
# define RADEON_TXFORMAT_ARGB8888		(6  <<  0)
# define RADEON_TXFORMAT_RGBA8888		(7  <<  0)
# define RADEON_TXFORMAT_Y8			(8  <<  0)
# define RADEON_TXFORMAT_AYUV444		(9  <<  0)
# define RADEON_TXFORMAT_VYUY422		(10 <<  0)
# define RADEON_TXFORMAT_YVYU422		(11 <<  0)
# define RADEON_TXFORMAT_DXT1			(12 <<  0)
# define RADEON_TXFORMAT_DXT23			(14 <<  0)
# define RADEON_TXFORMAT_DXT45			(15 <<  0)
# define RADEON_TXFORMAT_FORMAT_MASK		(31 <<  0)
# define RADEON_TXFORMAT_FORMAT_SHIFT		0
# define RADEON_TXFORMAT_APPLE_YUV_MODE		(1  <<  5)
# define RADEON_TXFORMAT_ALPHA_IN_MAP		(1  <<  6)
# define RADEON_TXFORMAT_NON_POWER2		(1  <<  7)
# define RADEON_TXFORMAT_WIDTH_MASK		(15 <<  8)
# define RADEON_TXFORMAT_WIDTH_SHIFT		8
# define RADEON_TXFORMAT_HEIGHT_MASK		(15 << 12)
# define RADEON_TXFORMAT_HEIGHT_SHIFT		12
# define RADEON_TXFORMAT_F5_WIDTH_MASK		(15 << 16)
# define RADEON_TXFORMAT_F5_WIDTH_SHIFT		16
# define RADEON_TXFORMAT_F5_HEIGHT_MASK		(15 << 20)
# define RADEON_TXFORMAT_F5_HEIGHT_SHIFT	20
# define RADEON_TXFORMAT_ST_ROUTE_STQ0		(0  << 24)
# define RADEON_TXFORMAT_ST_ROUTE_STQ1		(1  << 24)
# define RADEON_TXFORMAT_ST_ROUTE_STQ2		(2  << 24)
# define RADEON_TXFORMAT_ST_ROUTE_MASK		(3  << 24)
# define RADEON_TXFORMAT_ENDIAN_NO_SWAP		(0  << 26)
# define RADEON_TXFORMAT_ENDIAN_16BPP_SWAP	(1  << 26)
# define RADEON_TXFORMAT_ENDIAN_32BPP_SWAP	(2  << 26)
# define RADEON_TXFORMAT_ENDIAN_HALFDW_SWAP	(3  << 26)
# define RADEON_TXFORMAT_ALPHA_MASK_ENABLE	(1  << 28)
# define RADEON_TXFORMAT_CHROMA_KEY_ENABLE	(1  << 29)
# define RADEON_TXFORMAT_CUBIC_MAP_ENABLE	(1  << 30)
# define RADEON_TXFORMAT_PERSPECTIVE_ENABLE	(1  << 31)

#define RADEON_REG_PP_TXOFFSET_0		0x1c5c
#define RADEON_REG_PP_TXOFFSET_1		0x1c74
#define RADEON_REG_PP_TXOFFSET_2		0x1c8c
# define RADEON_TXO_ENDIAN_NO_SWAP		(0 << 0)
# define RADEON_TXO_ENDIAN_BYTE_SWAP		(1 << 0)
# define RADEON_TXO_ENDIAN_WORD_SWAP		(2 << 0)
# define RADEON_TXO_ENDIAN_HALFDW_SWAP		(3 << 0)
# define RADEON_TXO_MACRO_LINEAR		(0 << 2)
# define RADEON_TXO_MACRO_TILE			(1 << 2)
# define RADEON_TXO_MICRO_LINEAR		(0 << 3)
# define RADEON_TXO_MICRO_TILE_X2		(1 << 3)
# define RADEON_TXO_MICRO_TILE_OPT		(2 << 3)
# define RADEON_TXO_OFFSET_MASK			0xffffffe0
# define RADEON_TXO_OFFSET_SHIFT		5

#define RADEON_REG_PP_TXCBLEND_0		0x1c60
#define RADEON_REG_PP_TXCBLEND_1		0x1c78
#define RADEON_REG_PP_TXCBLEND_2		0x1c90
# define RADEON_COLOR_ARG_A_SHIFT		0
# define RADEON_COLOR_ARG_A_MASK		(0x1f << 0)
# define RADEON_COLOR_ARG_A_ZERO		(0    << 0)
# define RADEON_COLOR_ARG_A_CURRENT_COLOR	(2    << 0)
# define RADEON_COLOR_ARG_A_CURRENT_ALPHA	(3    << 0)
# define RADEON_COLOR_ARG_A_DIFFUSE_COLOR	(4    << 0)
# define RADEON_COLOR_ARG_A_DIFFUSE_ALPHA	(5    << 0)
# define RADEON_COLOR_ARG_A_SPECULAR_COLOR	(6    << 0)
# define RADEON_COLOR_ARG_A_SPECULAR_ALPHA	(7    << 0)
# define RADEON_COLOR_ARG_A_TFACTOR_COLOR	(8    << 0)
# define RADEON_COLOR_ARG_A_TFACTOR_ALPHA	(9    << 0)
# define RADEON_COLOR_ARG_A_T0_COLOR		(10   << 0)
# define RADEON_COLOR_ARG_A_T0_ALPHA		(11   << 0)
# define RADEON_COLOR_ARG_A_T1_COLOR		(12   << 0)
# define RADEON_COLOR_ARG_A_T1_ALPHA		(13   << 0)
# define RADEON_COLOR_ARG_A_T2_COLOR		(14   << 0)
# define RADEON_COLOR_ARG_A_T2_ALPHA		(15   << 0)
# define RADEON_COLOR_ARG_A_T3_COLOR		(16   << 0)
# define RADEON_COLOR_ARG_A_T3_ALPHA		(17   << 0)
# define RADEON_COLOR_ARG_B_SHIFT		5
# define RADEON_COLOR_ARG_B_MASK		(0x1f << 5)
# define RADEON_COLOR_ARG_B_ZERO		(0    << 5)
# define RADEON_COLOR_ARG_B_CURRENT_COLOR	(2    << 5)
# define RADEON_COLOR_ARG_B_CURRENT_ALPHA	(3    << 5)
# define RADEON_COLOR_ARG_B_DIFFUSE_COLOR	(4    << 5)
# define RADEON_COLOR_ARG_B_DIFFUSE_ALPHA	(5    << 5)
# define RADEON_COLOR_ARG_B_SPECULAR_COLOR	(6    << 5)
# define RADEON_COLOR_ARG_B_SPECULAR_ALPHA	(7    << 5)
# define RADEON_COLOR_ARG_B_TFACTOR_COLOR	(8    << 5)
# define RADEON_COLOR_ARG_B_TFACTOR_ALPHA	(9    << 5)
# define RADEON_COLOR_ARG_B_T0_COLOR		(10   << 5)
# define RADEON_COLOR_ARG_B_T0_ALPHA		(11   << 5)
# define RADEON_COLOR_ARG_B_T1_COLOR		(12   << 5)
# define RADEON_COLOR_ARG_B_T1_ALPHA		(13   << 5)
# define RADEON_COLOR_ARG_B_T2_COLOR		(14   << 5)
# define RADEON_COLOR_ARG_B_T2_ALPHA		(15   << 5)
# define RADEON_COLOR_ARG_B_T3_COLOR		(16   << 5)
# define RADEON_COLOR_ARG_B_T3_ALPHA		(17   << 5)
# define RADEON_COLOR_ARG_C_SHIFT		10
# define RADEON_COLOR_ARG_C_MASK		(0x1f << 10)
# define RADEON_COLOR_ARG_C_ZERO		(0    << 10)
# define RADEON_COLOR_ARG_C_CURRENT_COLOR	(2    << 10)
# define RADEON_COLOR_ARG_C_CURRENT_ALPHA	(3    << 10)
# define RADEON_COLOR_ARG_C_DIFFUSE_COLOR	(4    << 10)
# define RADEON_COLOR_ARG_C_DIFFUSE_ALPHA	(5    << 10)
# define RADEON_COLOR_ARG_C_SPECULAR_COLOR	(6    << 10)
# define RADEON_COLOR_ARG_C_SPECULAR_ALPHA	(7    << 10)
# define RADEON_COLOR_ARG_C_TFACTOR_COLOR	(8    << 10)
# define RADEON_COLOR_ARG_C_TFACTOR_ALPHA	(9    << 10)
# define RADEON_COLOR_ARG_C_T0_COLOR		(10   << 10)
# define RADEON_COLOR_ARG_C_T0_ALPHA		(11   << 10)
# define RADEON_COLOR_ARG_C_T1_COLOR		(12   << 10)
# define RADEON_COLOR_ARG_C_T1_ALPHA		(13   << 10)
# define RADEON_COLOR_ARG_C_T2_COLOR		(14   << 10)
# define RADEON_COLOR_ARG_C_T2_ALPHA		(15   << 10)
# define RADEON_COLOR_ARG_C_T3_COLOR		(16   << 10)
# define RADEON_COLOR_ARG_C_T3_ALPHA		(17   << 10)
# define RADEON_COMP_ARG_A			(1 << 15)
# define RADEON_COMP_ARG_A_SHIFT		15
# define RADEON_COMP_ARG_B			(1 << 16)
# define RADEON_COMP_ARG_B_SHIFT		16
# define RADEON_COMP_ARG_C			(1 << 17)
# define RADEON_COMP_ARG_C_SHIFT		17
# define RADEON_BLEND_CTL_MASK			(7 << 18)
# define RADEON_BLEND_CTL_ADD			(0 << 18)
# define RADEON_BLEND_CTL_SUBTRACT		(1 << 18)
# define RADEON_BLEND_CTL_ADDSIGNED		(2 << 18)
# define RADEON_BLEND_CTL_BLEND			(3 << 18)
# define RADEON_BLEND_CTL_DOT3			(4 << 18)
# define RADEON_SCALE_SHIFT			21
# define RADEON_SCALE_MASK			(3 << 21)
# define RADEON_SCALE_1X			(0 << 21)
# define RADEON_SCALE_2X			(1 << 21)
# define RADEON_SCALE_4X			(2 << 21)
# define RADEON_CLAMP_TX			(1 << 23)
# define RADEON_T0_EQ_TCUR			(1 << 24)
# define RADEON_T1_EQ_TCUR			(1 << 25)
# define RADEON_T2_EQ_TCUR			(1 << 26)
# define RADEON_T3_EQ_TCUR			(1 << 27)
# define RADEON_COLOR_ARG_MASK			0x1f
# define RADEON_COMP_ARG_SHIFT			15

#define RADEON_REG_PP_TXABLEND_0		0x1c64
#define RADEON_REG_PP_TXABLEND_1		0x1c7c
#define RADEON_REG_PP_TXABLEND_2		0x1c94
# define RADEON_ALPHA_ARG_A_SHIFT		0
# define RADEON_ALPHA_ARG_A_MASK		(0xf << 0)
# define RADEON_ALPHA_ARG_A_ZERO		(0   << 0)
# define RADEON_ALPHA_ARG_A_CURRENT_ALPHA	(1   << 0)
# define RADEON_ALPHA_ARG_A_DIFFUSE_ALPHA	(2   << 0)
# define RADEON_ALPHA_ARG_A_SPECULAR_ALPHA	(3   << 0)
# define RADEON_ALPHA_ARG_A_TFACTOR_ALPHA	(4   << 0)
# define RADEON_ALPHA_ARG_A_T0_ALPHA		(5   << 0)
# define RADEON_ALPHA_ARG_A_T1_ALPHA		(6   << 0)
# define RADEON_ALPHA_ARG_A_T2_ALPHA		(7   << 0)
# define RADEON_ALPHA_ARG_A_T3_ALPHA		(8   << 0)
# define RADEON_ALPHA_ARG_B_SHIFT		4
# define RADEON_ALPHA_ARG_B_MASK		(0xf << 4)
# define RADEON_ALPHA_ARG_B_ZERO		(0   << 4)
# define RADEON_ALPHA_ARG_B_CURRENT_ALPHA	(1   << 4)
# define RADEON_ALPHA_ARG_B_DIFFUSE_ALPHA	(2   << 4)
# define RADEON_ALPHA_ARG_B_SPECULAR_ALPHA	(3   << 4)
# define RADEON_ALPHA_ARG_B_TFACTOR_ALPHA	(4   << 4)
# define RADEON_ALPHA_ARG_B_T0_ALPHA		(5   << 4)
# define RADEON_ALPHA_ARG_B_T1_ALPHA		(6   << 4)
# define RADEON_ALPHA_ARG_B_T2_ALPHA		(7   << 4)
# define RADEON_ALPHA_ARG_B_T3_ALPHA		(8   << 4)
# define RADEON_ALPHA_ARG_C_SHIFT		8
# define RADEON_ALPHA_ARG_C_MASK		(0xf << 8)
# define RADEON_ALPHA_ARG_C_ZERO		(0   << 8)
# define RADEON_ALPHA_ARG_C_CURRENT_ALPHA	(1   << 8)
# define RADEON_ALPHA_ARG_C_DIFFUSE_ALPHA	(2   << 8)
# define RADEON_ALPHA_ARG_C_SPECULAR_ALPHA	(3   << 8)
# define RADEON_ALPHA_ARG_C_TFACTOR_ALPHA	(4   << 8)
# define RADEON_ALPHA_ARG_C_T0_ALPHA		(5   << 8)
# define RADEON_ALPHA_ARG_C_T1_ALPHA		(6   << 8)
# define RADEON_ALPHA_ARG_C_T2_ALPHA		(7   << 8)
# define RADEON_ALPHA_ARG_C_T3_ALPHA		(8   << 8)
# define RADEON_DOT_ALPHA_DONT_REPLICATE	(1   << 9)
/* COMP_ARG, BLEND_CNTL, CLAMP_TX same as for CBLEND, T*_EQ_TCUR */
# define RADEON_ALPHA_ARG_MASK			0xf

#define RADEON_REG_PP_TFACTOR_0			0x1c68
#define RADEON_REG_PP_TFACTOR_1			0x1c80
#define RADEON_REG_PP_TFACTOR_2			0x1c98

#define R128_REG_TEX_CNTL_C			0x1c9c
# define R128_Z_ENABLE				(1 <<  0)
# define R128_Z_WRITE_ENABLE			(1 <<  1)
# define R128_STENCIL_ENABLE			(1 <<  3)
# define R128_SHADE_ENABLE			(0 <<  4)
# define R128_TEXMAP_ENABLE			(1 <<  4)
# define R128_SEC_TEXMAP_ENABLE			(1 <<  5)
# define R128_FOG_ENABLE			(1 <<  7)
# define R128_DITHER_ENABLE			(1 <<  8)
# define R128_ALPHA_ENABLE			(1 <<  9)
# define R128_ALPHA_TEST_ENABLE			(1 << 10)
# define R128_SPEC_LIGHT_ENABLE			(1 << 11)
# define R128_TEX_CHROMA_KEY_ENABLE		(1 << 12)
# define R128_ALPHA_IN_TEX_COMPLETE_A		(0 << 13)
# define R128_ALPHA_IN_TEX_LSB_A		(1 << 13)
# define R128_LIGHT_DIS				(0 << 14)
# define R128_LIGHT_COPY			(1 << 14)
# define R128_LIGHT_MODULATE			(2 << 14)
# define R128_LIGHT_ADD				(3 << 14)
# define R128_LIGHT_BLEND_CONSTANT		(4 << 14)
# define R128_LIGHT_BLEND_TEXTURE		(5 << 14)
# define R128_LIGHT_BLEND_VERTEX		(6 << 14)
# define R128_LIGHT_BLEND_CONST_COLOR		(7 << 14)
# define R128_ALPHA_LIGHT_DIS			(0 << 18)
# define R128_ALPHA_LIGHT_COPY			(1 << 18)
# define R128_ALPHA_LIGHT_MODULATE		(2 << 18)
# define R128_ALPHA_LIGHT_ADD			(3 << 18)
# define R128_ANTI_ALIAS			(1 << 21)
# define R128_TEX_CACHE_FLUSH			(1 << 23)
# define R128_LOD_BIAS_SHIFT			24
# define R128_LOD_BIAS_MASK			(0xff << 24)

#define R128_REG_MISC_3D_STATE_CNTL		0x1ca0
# define R128_REF_ALPHA_MASK			0xff
# define R128_MISC_SCALE_3D_NOOP		(0  <<  8)
# define R128_MISC_SCALE_3D_SCALE		(1  <<  8)
# define R128_MISC_SCALE_3D_TEXMAP_SHADE	(2  <<  8)
# define R128_MISC_SCALE_PIX_BLEND		(0  << 10)
# define R128_MISC_SCALE_PIX_REPLICATE		(1  << 10)
# define R128_ALPHA_COMB_ADD_CLAMP		(0  << 12)
# define R128_ALPHA_COMB_ADD_NO_CLAMP		(1  << 12)
# define R128_ALPHA_COMB_SUB_SRC_DST_CLAMP	(2  << 12)
# define R128_ALPHA_COMB_SUB_SRC_DST_NO_CLAMP	(3  << 12)
# define R128_FOG_VERTEX			(0  << 14)
# define R128_FOG_TABLE				(1  << 14)
# define R128_SBLEND_ZERO			(0  << 16)
# define R128_SBLEND_ONE			(1  << 16)
# define R128_SBLEND_SRCCOLOR			(2  << 16)
# define R128_SBLEND_INVSRCCOLOR		(3  << 16)
# define R128_SBLEND_SRC_ALPHA			(4  << 16)
# define R128_SBLEND_INV_SRC_ALPHA		(5  << 16)
# define R128_SBLEND_DST_ALPHA			(6  << 16)
# define R128_SBLEND_INV_DST_ALPHA		(7  << 16)
# define R128_SBLEND_DSTCOLOR			(8  << 16)
# define R128_SBLEND_INVDSTCOLOR		(9  << 16)
# define R128_SBLEND_SRC_ALPHASAT		(10 << 16)
# define R128_SBLEND_BOTHSRC_ALPHA		(11 << 16)
# define R128_SBLEND_BOTHINV_SRC_ALPHA		(12 << 16)
# define R128_SBLEND_MASK			(15 << 16)
# define R128_DBLEND_ZERO			(0  << 20)
# define R128_DBLEND_ONE			(1  << 20)
# define R128_DBLEND_SRCCOLOR			(2  << 20)
# define R128_DBLEND_INVSRCCOLOR		(3  << 20)
# define R128_DBLEND_SRC_ALPHA			(4  << 20)
# define R128_DBLEND_INV_SRC_ALPHA		(5  << 20)
# define R128_DBLEND_DST_ALPHA			(6  << 20)
# define R128_DBLEND_INV_DST_ALPHA		(7  << 20)
# define R128_DBLEND_DSTCOLOR			(8  << 20)
# define R128_DBLEND_INVDSTCOLOR		(9  << 20)
# define R128_DBLEND_SRC_ALPHASAT		(10 << 20)
# define R128_DBLEND_MASK			(15 << 20)
# define R128_ALPHA_TEST_NEVER			(0  << 24)
# define R128_ALPHA_TEST_LESS			(1  << 24)
# define R128_ALPHA_TEST_LESSEQUAL		(2  << 24)
# define R128_ALPHA_TEST_EQUAL			(3  << 24)
# define R128_ALPHA_TEST_GREATEREQUAL		(4  << 24)
# define R128_ALPHA_TEST_GREATER		(5  << 24)
# define R128_ALPHA_TEST_NEQUAL			(6  << 24)
# define R128_ALPHA_TEST_ALWAYS			(7  << 24)
# define R128_ALPHA_TEST_MASK			(7  << 24)

#define R128_REG_PRIM_TEX_CNTL_C		0x1cb0
#define R128_REG_SEC_TEX_CNTL_C			0x1d00
# define R128_SEC_SELECT_PRIM_ST		(0  <<  0)
# define R128_SEC_SELECT_SEC_ST			(1  <<  0)
# define R128_MIN_BLEND_NEAREST			(0  <<  1)
# define R128_MIN_BLEND_LINEAR			(1  <<  1)
# define R128_MIN_BLEND_MIPNEAREST		(2  <<  1)
# define R128_MIN_BLEND_MIPLINEAR		(3  <<  1)
# define R128_MIN_BLEND_LINEARMIPNEAREST	(4  <<  1)
# define R128_MIN_BLEND_LINEARMIPLINEAR		(5  <<  1)
# define R128_MIN_BLEND_MASK			(7  <<  1)
# define R128_MAG_BLEND_NEAREST			(0  <<  4)
# define R128_MAG_BLEND_LINEAR			(1  <<  4)
# define R128_MAG_BLEND_MASK			(7  <<  4)
# define R128_MIP_MAP_DISABLE			(1  <<  7)
# define R128_TEX_CLAMP_S_WRAP			(0  <<  8)
# define R128_TEX_CLAMP_S_MIRROR		(1  <<  8)
# define R128_TEX_CLAMP_S_CLAMP			(2  <<  8)
# define R128_TEX_CLAMP_S_BORDER_COLOR		(3  <<  8)
# define R128_TEX_CLAMP_S_MASK			(3  <<  8)
# define R128_TEX_WRAP_S			(1  << 10)
# define R128_TEX_CLAMP_T_WRAP			(0  << 11)
# define R128_TEX_CLAMP_T_MIRROR		(1  << 11)
# define R128_TEX_CLAMP_T_CLAMP			(2  << 11)
# define R128_TEX_CLAMP_T_BORDER_COLOR		(3  << 11)
# define R128_TEX_CLAMP_T_MASK			(3  << 11)
# define R128_TEX_WRAP_T			(1  << 13)
# define R128_TEX_PERSPECTIVE_DISABLE		(1  << 14)
# define R128_TEX_DATATYPE_SHIFT		16
# define R128_PALLETE_EITHER			(0  << 20)
# define R128_PALLETE_1				(1  << 20)
# define R128_PALLETE_2				(2  << 20)
# define R128_PSEUDOCOLOR_DT_RGB565		(0  << 24)
# define R128_PSEUDOCOLOR_DT_ARGB1555		(1  << 24)
# define R128_PSEUDOCOLOR_DT_ARGB4444		(2  << 24)

#define R128_REG_PRIM_TEXTURE_COMBINE_CNTL_C	0x1cb4
#define R128_REG_SEC_TEXTURE_COMBINE_CNTL_C	0x1d04
# define R128_COMB_DIS				(0  <<  0)
# define R128_COMB_COPY				(1  <<  0)
# define R128_COMB_COPY_INP			(2  <<  0)
# define R128_COMB_MODULATE			(3  <<  0)
# define R128_COMB_MODULATE2X			(4  <<  0)
# define R128_COMB_MODULATE4X			(5  <<  0)
# define R128_COMB_ADD				(6  <<  0)
# define R128_COMB_ADD_SIGNED			(7  <<  0)
# define R128_COMB_BLEND_VERTEX			(8  <<  0)
# define R128_COMB_BLEND_TEXTURE		(9  <<  0)
# define R128_COMB_BLEND_CONST			(10 <<  0)
# define R128_COMB_BLEND_PREMULT		(11 <<  0)
# define R128_COMB_BLEND_PREV			(12 <<  0)
# define R128_COMB_BLEND_PREMULT_INV		(13 <<  0)
# define R128_COMB_ADD_SIGNED2X			(14 <<  0)
# define R128_COMB_BLEND_CONST_COLOR		(15 <<  0)
# define R128_COMB_MASK				(15 <<  0)
# define R128_COLOR_FACTOR_CONST_COLOR		(0  <<  4)
# define R128_COLOR_FACTOR_NCONST_COLOR		(1  <<  4)
# define R128_COLOR_FACTOR_TEX			(4  <<  4)
# define R128_COLOR_FACTOR_NTEX			(5  <<  4)
# define R128_COLOR_FACTOR_ALPHA		(6  <<  4)
# define R128_COLOR_FACTOR_NALPHA		(7  <<  4)
# define R128_COLOR_FACTOR_PREV_COLOR		(8  <<  4)
# define R128_COLOR_FACTOR_MASK			(15 <<  4)
# define R128_COMB_FCN_MSB			(1  <<  8)
# define R128_INPUT_FACTOR_CONST_COLOR		(2  << 10)
# define R128_INPUT_FACTOR_CONST_ALPHA		(3  << 10)
# define R128_INPUT_FACTOR_INT_COLOR		(4  << 10)
# define R128_INPUT_FACTOR_INT_ALPHA		(5  << 10)
# define R128_INPUT_FACTOR_PREV_COLOR		(8  << 10)	/* SEC only */
# define R128_INPUT_FACTOR_PREV_ALPHA		(9  << 10)	/* SEC only */
# define R128_INPUT_FACTOR_MASK			(15 << 10)
# define R128_COMB_ALPHA_DIS			(0  << 14)
# define R128_COMB_ALPHA_COPY			(1  << 14)
# define R128_COMB_ALPHA_COPY_INP		(2  << 14)
# define R128_COMB_ALPHA_MODULATE		(3  << 14)
# define R128_COMB_ALPHA_MODULATE2X		(4  << 14)
# define R128_COMB_ALPHA_MODULATE4X		(5  << 14)
# define R128_COMB_ALPHA_ADD			(6  << 14)
# define R128_COMB_ALPHA_ADD_SIGNED		(7  << 14)
# define R128_COMB_ALPHA_ADD_SIGNED2X		(14 << 14)
# define R128_COMB_ALPHA_MASK			(15 << 14)
# define R128_ALPHA_FACTOR_TEX_ALPHA		(6  << 18)
# define R128_ALPHA_FACTOR_NTEX_ALPHA		(7  << 18)
# define R128_ALPHA_FACTOR_MASK			(15 << 18)
# define R128_INP_FACTOR_A_CONST_ALPHA		(1  << 25)
# define R128_INP_FACTOR_A_INT_ALPHA		(2  << 25)
# define R128_INP_FACTOR_A_PREV_ALPHA		(4  << 25)	/* SEC only */
# define R128_INP_FACTOR_A_MASK			(7  << 25)

#define R128_REG_TEX_SIZE_PITCH_C		0x1cb8
# define R128_TEX_PITCH_SHIFT			0
# define R128_TEX_SIZE_SHIFT			4
# define R128_TEX_HEIGHT_SHIFT			8
# define R128_TEX_MIN_SIZE_SHIFT		12
# define R128_SEC_TEX_PITCH_SHIFT		16
# define R128_SEC_TEX_SIZE_SHIFT		20
# define R128_SEC_TEX_HEIGHT_SHIFT		24
# define R128_SEC_TEX_MIN_SIZE_SHIFT		28
# define R128_TEX_PITCH_MASK			(0x0f <<  0)
# define R128_TEX_SIZE_MASK			(0x0f <<  4)
# define R128_TEX_HEIGHT_MASK			(0x0f <<  8)
# define R128_TEX_MIN_SIZE_MASK			(0x0f << 12)
# define R128_SEC_TEX_PITCH_MASK		(0x0f << 16)
# define R128_SEC_TEX_SIZE_MASK			(0x0f << 20)
# define R128_SEC_TEX_HEIGHT_MASK		(0x0f << 24)
# define R128_SEC_TEX_MIN_SIZE_MASK		(0x0f << 28)
# define R128_TEX_SIZE_PITCH_SHIFT		0
# define R128_SEC_TEX_SIZE_PITCH_SHIFT		16
# define R128_TEX_SIZE_PITCH_MASK		(0xffff <<  0)
# define R128_SEC_TEX_SIZE_PITCH_MASK		(0xffff << 16)

#define R128_REG_PRIM_TEX_0_OFFSET_C		0x1cbc
#define R128_REG_PRIM_TEX_1_OFFSET_C		0x1cc0
#define R128_REG_PRIM_TEX_2_OFFSET_C		0x1cc4
#define R128_REG_PRIM_TEX_3_OFFSET_C		0x1cc8
#define R128_REG_PRIM_TEX_4_OFFSET_C		0x1ccc
#define R128_REG_PRIM_TEX_5_OFFSET_C		0x1cd0
#define R128_REG_PRIM_TEX_6_OFFSET_C		0x1cd4
#define R128_REG_PRIM_TEX_7_OFFSET_C		0x1cd8
#define R128_REG_PRIM_TEX_8_OFFSET_C		0x1cdc
#define R128_REG_PRIM_TEX_9_OFFSET_C		0x1ce0
#define R128_REG_PRIM_TEX_10_OFFSET_C		0x1ce4
#define R128_REG_SEC_TEX_0_OFFSET_C		0x1d08
#define R128_REG_SEC_TEX_1_OFFSET_C		0x1d0c
#define R128_REG_SEC_TEX_2_OFFSET_C		0x1d10
#define R128_REG_SEC_TEX_3_OFFSET_C		0x1d14
#define R128_REG_SEC_TEX_4_OFFSET_C		0x1d18
#define R128_REG_SEC_TEX_5_OFFSET_C		0x1d1c
#define R128_REG_SEC_TEX_6_OFFSET_C		0x1d20
#define R128_REG_SEC_TEX_7_OFFSET_C		0x1d24
#define R128_REG_SEC_TEX_8_OFFSET_C		0x1d28
#define R128_REG_SEC_TEX_9_OFFSET_C		0x1d2c
#define R128_REG_SEC_TEX_10_OFFSET_C		0x1d30
# define R128_TEX_NO_TILE			(0 << 30)
# define R128_TEX_TILED_BY_HOST			(1 << 30)
# define R128_TEX_TILED_BY_STORAGE		(2 << 30)
# define R128_TEX_TILED_BY_STORAGE2		(3 << 30)
#define R128_REG_CONSTANT_COLOR_C		0x1d34
# define R128_CONSTANT_BLUE_SHIFT		0
# define R128_CONSTANT_GREEN_SHIFT		8
# define R128_CONSTANT_RED_SHIFT		16
# define R128_CONSTANT_ALPHA_SHIFT		24

#define RADEON_REG_PP_TEX_SIZE_0		0x1d04  /* NPOT */
#define RADEON_REG_PP_TEX_SIZE_1		0x1d0c  /* NPOT */
#define RADEON_REG_PP_TEX_SIZE_2		0x1d14  /* NPOT */
# define RADEON_TEX_USIZE_MASK			(0x7ff << 0)
# define RADEON_TEX_USIZE_SHIFT			0
# define RADEON_TEX_VSIZE_MASK			(0x7ff << 16)
# define RADEON_TEX_VSIZE_SHIFT			16
# define RADEON_SIGNED_RGB_MASK			(1 << 30)
# define RADEON_SIGNED_RGB_SHIFT		30
# define RADEON_SIGNED_ALPHA_MASK		(1 << 31)
# define RADEON_SIGNED_ALPHA_SHIFT		31

#define RADEON_REG_PP_TEX_PITCH_0		0x1d08  /* NPOT */
#define RADEON_REG_PP_TEX_PITCH_1		0x1d10  /* NPOT */
#define RADEON_REG_PP_TEX_PITCH_2		0x1d18  /* NPOT */
/* note: bits 13-5: 32 byte aligned stride of texture map */

#define R128_REG_PLANE_3D_MASK_C			0x1d44

#define RADEON_REG_RB3D_PLANEMASK		0x1d84

#define R200_REG_SE_VAP_CNTL			0x2080
# define R200_VAP_TCL_ENABLE			0x00000001
# define R200_VAP_SINGLE_BUF_STATE_ENABLE	0x00000010
# define R200_VAP_FORCE_W_TO_ONE		0x00010000
# define R200_VAP_D3D_TEX_DEFAULT		0x00020000
# define R200_VAP_VF_MAX_VTX_NUM__SHIFT		18
# define R200_VAP_VF_MAX_VTX_NUM		(9 << 18)
# define R200_VAP_DX_CLIP_SPACE_DEF		0x00400000

#define R200_REG_SE_VTX_FMT_0			0x2088
# define R200_VTX_XY				0 /* always have xy */
# define R200_VTX_Z0				(1 <<  0)
# define R200_VTX_W0				(1 <<  1)
# define R200_VTX_WEIGHT_COUNT_SHIFT		(2)
# define R200_VTX_PV_MATRIX_SEL			(1 <<  5)
# define R200_VTX_N0				(1 <<  6)
# define R200_VTX_POINT_SIZE			(1 <<  7)
# define R200_VTX_DISCRETE_FOG			(1 <<  8)
# define R200_VTX_SHININESS_0			(1 <<  9)
# define R200_VTX_SHININESS_1			(1 << 10)
# define   R200_VTX_COLOR_NOT_PRESENT		0
# define   R200_VTX_PK_RGBA			1
# define   R200_VTX_FP_RGB			2
# define   R200_VTX_FP_RGBA			3
# define   R200_VTX_COLOR_MASK			3
# define R200_VTX_COLOR_0_SHIFT			11
# define R200_VTX_COLOR_1_SHIFT			13
# define R200_VTX_COLOR_2_SHIFT			15
# define R200_VTX_COLOR_3_SHIFT			17
# define R200_VTX_COLOR_4_SHIFT			19
# define R200_VTX_COLOR_5_SHIFT			21
# define R200_VTX_COLOR_6_SHIFT			23
# define R200_VTX_COLOR_7_SHIFT			25
# define R200_VTX_XY1				(1 << 28)
# define R200_VTX_Z1				(1 << 29)
# define R200_VTX_W1				(1 << 30)
# define R200_VTX_N1				(1 << 31)

#define R200_REG_SE_VTX_FMT_1			0x208c
# define R200_VTX_TEX0_COMP_CNT_SHIFT		0
# define R200_VTX_TEX1_COMP_CNT_SHIFT		3
# define R200_VTX_TEX2_COMP_CNT_SHIFT		6
# define R200_VTX_TEX3_COMP_CNT_SHIFT		9
# define R200_VTX_TEX4_COMP_CNT_SHIFT		12
# define R200_VTX_TEX5_COMP_CNT_SHIFT		15

#define R200_REG_SE_VTE_CNTL			0x20b0
# define R200_VPORT_X_SCALE_ENA			0x00000001
# define R200_VPORT_X_OFFSET_ENA		0x00000002
# define R200_VPORT_Y_SCALE_ENA			0x00000004
# define R200_VPORT_Y_OFFSET_ENA		0x00000008
# define R200_VPORT_Z_SCALE_ENA			0x00000010
# define R200_VPORT_Z_OFFSET_ENA		0x00000020
# define R200_VTX_XY_FMT			0x00000100
# define R200_VTX_Z_FMT				0x00000200
# define R200_VTX_W0_FMT			0x00000400
# define R200_VTX_W0_NORMALIZE			0x00000800
# define R200_VTX_ST_DENORMALIZED		0x00001000

#define R200_REG_SE_VAP_CNTL_STATUS		0x2140
#define RADEON_REG_SE_CNTL_STATUS		0x2140
# define RADEON_VC_NO_SWAP			(0 << 0)
# define RADEON_VC_16BIT_SWAP			(1 << 0)
# define RADEON_VC_32BIT_SWAP			(2 << 0)
# define RADEON_VC_HALF_DWORD_SWAP		(3 << 0)
# define RADEON_TCL_BYPASS			(1 << 8)

#define R200_REG_SE_VTX_STATE_CNTL		0x2180

#define RADEON_REG_RE_TOP_LEFT			0x26c0

#define R200_REG_RE_AUX_SCISSOR_CNTL		0x26f0

#define R200_REG_PP_TXFILTER_0			0x2c00
#define R200_REG_PP_TXFILTER_1			0x2c20 
#define R200_REG_PP_TXFILTER_2			0x2c40 
#define R200_REG_PP_TXFILTER_3			0x2c60 
#define R200_REG_PP_TXFILTER_4			0x2c80 
#define R200_REG_PP_TXFILTER_5			0x2ca0 
# define R200_MAG_FILTER_NEAREST		(0  <<  0)
# define R200_MAG_FILTER_LINEAR			(1  <<  0)
# define R200_MAG_FILTER_MASK			(1  <<  0)
# define R200_MIN_FILTER_NEAREST		(0  <<  1)
# define R200_MIN_FILTER_LINEAR			(1  <<  1)
# define R200_MIN_FILTER_NEAREST_MIP_NEAREST	(2  <<  1)
# define R200_MIN_FILTER_NEAREST_MIP_LINEAR	(3  <<  1)
# define R200_MIN_FILTER_LINEAR_MIP_NEAREST	(6  <<  1)
# define R200_MIN_FILTER_LINEAR_MIP_LINEAR	(7  <<  1)
# define R200_MIN_FILTER_ANISO_NEAREST		(8  <<  1)
# define R200_MIN_FILTER_ANISO_LINEAR		(9  <<  1)
# define R200_MIN_FILTER_ANISO_NEAREST_MIP_NEAREST (10 <<  1)
# define R200_MIN_FILTER_ANISO_NEAREST_MIP_LINEAR (11 <<  1)
# define R200_MIN_FILTER_MASK			(15 <<  1)
# define R200_MAX_ANISO_1_TO_1			(0  <<  5)
# define R200_MAX_ANISO_2_TO_1			(1  <<  5)
# define R200_MAX_ANISO_4_TO_1			(2  <<  5)
# define R200_MAX_ANISO_8_TO_1			(3  <<  5)
# define R200_MAX_ANISO_16_TO_1			(4  <<  5)
# define R200_MAX_ANISO_MASK			(7  <<  5)
# define R200_MAX_MIP_LEVEL_MASK		(0x0f << 16)
# define R200_MAX_MIP_LEVEL_SHIFT		16
# define R200_YUV_TO_RGB			(1  << 20)
# define R200_YUV_TEMPERATURE_COOL		(0  << 21)
# define R200_YUV_TEMPERATURE_HOT		(1  << 21)
# define R200_YUV_TEMPERATURE_MASK		(1  << 21)
# define R200_WRAPEN_S				(1  << 22)
# define R200_CLAMP_S_WRAP			(0  << 23)
# define R200_CLAMP_S_MIRROR			(1  << 23)
# define R200_CLAMP_S_CLAMP_LAST		(2  << 23)
# define R200_CLAMP_S_MIRROR_CLAMP_LAST		(3  << 23)
# define R200_CLAMP_S_CLAMP_BORDER		(4  << 23)
# define R200_CLAMP_S_MIRROR_CLAMP_BORDER	(5  << 23)
# define R200_CLAMP_S_CLAMP_GL			(6  << 23)
# define R200_CLAMP_S_MIRROR_CLAMP_GL		(7  << 23)
# define R200_CLAMP_S_MASK			(7  << 23)
# define R200_WRAPEN_T				(1  << 26)
# define R200_CLAMP_T_WRAP			(0  << 27)
# define R200_CLAMP_T_MIRROR			(1  << 27)
# define R200_CLAMP_T_CLAMP_LAST		(2  << 27)
# define R200_CLAMP_T_MIRROR_CLAMP_LAST		(3  << 27)
# define R200_CLAMP_T_CLAMP_BORDER		(4  << 27)
# define R200_CLAMP_T_MIRROR_CLAMP_BORDER	(5  << 27)
# define R200_CLAMP_T_CLAMP_GL			(6  << 27)
# define R200_CLAMP_T_MIRROR_CLAMP_GL		(7  << 27)
# define R200_CLAMP_T_MASK			(7  << 27)
# define R200_KILL_LT_ZERO			(1  << 30)
# define R200_BORDER_MODE_OGL			(0  << 31)
# define R200_BORDER_MODE_D3D			(1  << 31)

#define R200_REG_PP_TXFORMAT_0			0x2c04
#define R200_REG_PP_TXFORMAT_1			0x2c24
#define R200_REG_PP_TXFORMAT_2			0x2c44
#define R200_REG_PP_TXFORMAT_3			0x2c64
#define R200_REG_PP_TXFORMAT_4			0x2c84
#define R200_REG_PP_TXFORMAT_5			0x2ca4
# define R200_TXFORMAT_I8			(0 << 0)
# define R200_TXFORMAT_AI88			(1 << 0)
# define R200_TXFORMAT_RGB332			(2 << 0)
# define R200_TXFORMAT_ARGB1555			(3 << 0)
# define R200_TXFORMAT_RGB565			(4 << 0)
# define R200_TXFORMAT_ARGB4444			(5 << 0)
# define R200_TXFORMAT_ARGB8888			(6 << 0)
# define R200_TXFORMAT_RGBA8888			(7 << 0)
# define R200_TXFORMAT_Y8			(8 << 0)
# define R200_TXFORMAT_AVYU4444			(9 << 0)
# define R200_TXFORMAT_VYUY422			(10 << 0)
# define R200_TXFORMAT_YVYU422			(11 << 0)
# define R200_TXFORMAT_DXT1			(12 << 0)
# define R200_TXFORMAT_DXT23			(14 << 0)
# define R200_TXFORMAT_DXT45			(15 << 0)
# define R200_TXFORMAT_FORMAT_MASK		(31 <<	0)
# define R200_TXFORMAT_FORMAT_SHIFT		0
# define R200_TXFORMAT_ALPHA_IN_MAP		(1 << 6)
# define R200_TXFORMAT_NON_POWER2		(1 << 7)
# define R200_TXFORMAT_WIDTH_MASK		(15 <<	8)
# define R200_TXFORMAT_WIDTH_SHIFT		8
# define R200_TXFORMAT_HEIGHT_MASK		(15 << 12)
# define R200_TXFORMAT_HEIGHT_SHIFT		12
# define R200_TXFORMAT_F5_WIDTH_MASK		(15 << 16)	/* cube face 5 */
# define R200_TXFORMAT_F5_WIDTH_SHIFT		16
# define R200_TXFORMAT_F5_HEIGHT_MASK		(15 << 20)
# define R200_TXFORMAT_F5_HEIGHT_SHIFT		20
# define R200_TXFORMAT_ST_ROUTE_STQ0		(0 << 24)
# define R200_TXFORMAT_ST_ROUTE_STQ1		(1 << 24)
# define R200_TXFORMAT_ST_ROUTE_STQ2		(2 << 24)
# define R200_TXFORMAT_ST_ROUTE_STQ3		(3 << 24)
# define R200_TXFORMAT_ST_ROUTE_STQ4		(4 << 24)
# define R200_TXFORMAT_ST_ROUTE_STQ5		(5 << 24)
# define R200_TXFORMAT_ST_ROUTE_MASK		(7 << 24)
# define R200_TXFORMAT_ST_ROUTE_SHIFT		24
# define R200_TXFORMAT_ALPHA_MASK_ENABLE	(1 << 28)
# define R200_TXFORMAT_CHROMA_KEY_ENABLE	(1 << 29)
# define R200_TXFORMAT_CUBIC_MAP_ENABLE		(1 << 30)

#define R200_REG_PP_TXFORMAT_X_0		0x2c08
#define R200_REG_PP_TXFORMAT_X_1		0x2c28
#define R200_REG_PP_TXFORMAT_X_2		0x2c48
#define R200_REG_PP_TXFORMAT_X_3		0x2c68
#define R200_REG_PP_TXFORMAT_X_4		0x2c88
#define R200_REG_PP_TXFORMAT_X_5		0x2ca8
# define R200_DEPTH_LOG2_MASK			(0xf << 0)
# define R200_DEPTH_LOG2_SHIFT			0
# define R200_VOLUME_FILTER_SHIFT		4
# define R200_VOLUME_FILTER_MASK		(1 << 4)
# define R200_VOLUME_FILTER_NEAREST		(0 << 4)
# define R200_VOLUME_FILTER_LINEAR		(1 << 4)
# define R200_WRAPEN_Q				(1 << 8)
# define R200_CLAMP_Q_WRAP			(0 << 9)
# define R200_CLAMP_Q_MIRROR			(1 << 9)
# define R200_CLAMP_Q_CLAMP_LAST		(2 << 9)
# define R200_CLAMP_Q_MIRROR_CLAMP_LAST		(3 << 9)
# define R200_CLAMP_Q_CLAMP_BORDER		(4 << 9)
# define R200_CLAMP_Q_MIRROR_CLAMP_BORDER	(5 << 9)
# define R200_CLAMP_Q_CLAMP_GL			(6 << 9)
# define R200_CLAMP_Q_MIRROR_CLAMP_GL		(7 << 9)
# define R200_CLAMP_Q_MASK			(7 << 9)
# define R200_MIN_MIP_LEVEL_MASK		(0xff << 12)
# define R200_MIN_MIP_LEVEL_SHIFT		12
# define R200_TEXCOORD_NONPROJ			(0 << 16)
# define R200_TEXCOORD_CUBIC_ENV		(1 << 16)
# define R200_TEXCOORD_VOLUME			(2 << 16)
# define R200_TEXCOORD_PROJ			(3 << 16)
# define R200_TEXCOORD_DEPTH			(4 << 16)
# define R200_TEXCOORD_1D_PROJ			(5 << 16)
# define R200_TEXCOORD_1D			(6 << 16)
# define R200_TEXCOORD_ZERO			(7 << 16)
# define R200_TEXCOORD_MASK			(7 << 16)
# define R200_LOD_BIAS_MASK			(0xfff80000)
# define R200_LOD_BIAS_SHIFT			19

#define R200_REG_PP_TXSIZE_0			0x2c0c /* NPOT only */
#define R200_REG_PP_TXSIZE_1			0x2c2c /* NPOT only */
#define R200_REG_PP_TXSIZE_2			0x2c4c /* NPOT only */
#define R200_REG_PP_TXSIZE_3			0x2c6c /* NPOT only */
#define R200_REG_PP_TXSIZE_4			0x2c8c /* NPOT only */
#define R200_REG_PP_TXSIZE_5			0x2cac /* NPOT only */

#define R200_REG_PP_TXPITCH_0			0x2c10 /* NPOT only */
#define R200_REG_PP_TXPITCH_1			0x2c30 /* NPOT only */
#define R200_REG_PP_TXPITCH_2			0x2c50 /* NPOT only */
#define R200_REG_PP_TXPITCH_3			0x2c70 /* NPOT only */
#define R200_REG_PP_TXPITCH_4			0x2c90 /* NPOT only */
#define R200_REG_PP_TXPITCH_5			0x2cb0 /* NPOT only */

#define R200_REG_PP_BORDER_COLOR_0		0x2c14
#define R200_REG_PP_TXMULTI_CTL_0		0x2c1c

#define R200_REG_PP_CNTL_X			0x2cc4

#define R200_PP_TXOFFSET_0			0x2d00
#define R200_PP_TXOFFSET_1			0x2d18
#define R200_PP_TXOFFSET_2			0x2d30
#define R200_PP_TXOFFSET_3			0x2d48
#define R200_PP_TXOFFSET_4			0x2d60
#define R200_PP_TXOFFSET_5			0x2d78
# define R200_TXO_ENDIAN_NO_SWAP		(0 << 0)
# define R200_TXO_ENDIAN_BYTE_SWAP		(1 << 0)
# define R200_TXO_ENDIAN_WORD_SWAP		(2 << 0)
# define R200_TXO_ENDIAN_HALFDW_SWAP		(3 << 0)
# define R200_TXO_OFFSET_MASK			0xffffffe0
# define R200_TXO_OFFSET_SHIFT			5

#define R200_PP_CUBIC_OFFSET_F1_0		0x2d04
#define R200_PP_CUBIC_OFFSET_F2_0		0x2d08
#define R200_PP_CUBIC_OFFSET_F3_0		0x2d0c
#define R200_PP_CUBIC_OFFSET_F4_0		0x2d10
#define R200_PP_CUBIC_OFFSET_F5_0		0x2d14
#define R200_PP_CUBIC_OFFSET_F1_1		0x2d1c
#define R200_PP_CUBIC_OFFSET_F2_1		0x2d20
#define R200_PP_CUBIC_OFFSET_F3_1		0x2d24
#define R200_PP_CUBIC_OFFSET_F4_1		0x2d28
#define R200_PP_CUBIC_OFFSET_F5_1		0x2d2c
#define R200_PP_CUBIC_OFFSET_F1_2		0x2d34
#define R200_PP_CUBIC_OFFSET_F2_2		0x2d38
#define R200_PP_CUBIC_OFFSET_F3_2		0x2d3c
#define R200_PP_CUBIC_OFFSET_F4_2		0x2d40
#define R200_PP_CUBIC_OFFSET_F5_2		0x2d44
#define R200_PP_CUBIC_OFFSET_F1_3		0x2d4c
#define R200_PP_CUBIC_OFFSET_F2_3		0x2d50
#define R200_PP_CUBIC_OFFSET_F3_3		0x2d54
#define R200_PP_CUBIC_OFFSET_F4_3		0x2d58
#define R200_PP_CUBIC_OFFSET_F5_3		0x2d5c
#define R200_PP_CUBIC_OFFSET_F1_4		0x2d64
#define R200_PP_CUBIC_OFFSET_F2_4		0x2d68
#define R200_PP_CUBIC_OFFSET_F3_4		0x2d6c
#define R200_PP_CUBIC_OFFSET_F4_4		0x2d70
#define R200_PP_CUBIC_OFFSET_F5_4		0x2d74
#define R200_PP_CUBIC_OFFSET_F1_5		0x2d7c
#define R200_PP_CUBIC_OFFSET_F2_5		0x2d80
#define R200_PP_CUBIC_OFFSET_F3_5		0x2d84
#define R200_PP_CUBIC_OFFSET_F4_5		0x2d88
#define R200_PP_CUBIC_OFFSET_F5_5		0x2d8c

/* AKA PIXSHADER_I0_C0 */
#define R200_REG_PP_TXCBLEND_0			0x2f00
# define R200_TXC_ARG_A_ZERO			(0)
# define R200_TXC_ARG_A_CURRENT_COLOR		(2)
# define R200_TXC_ARG_A_CURRENT_ALPHA		(3)
# define R200_TXC_ARG_A_DIFFUSE_COLOR		(4)
# define R200_TXC_ARG_A_DIFFUSE_ALPHA		(5)
# define R200_TXC_ARG_A_SPECULAR_COLOR		(6)
# define R200_TXC_ARG_A_SPECULAR_ALPHA		(7)
# define R200_TXC_ARG_A_TFACTOR_COLOR		(8)
# define R200_TXC_ARG_A_TFACTOR_ALPHA		(9)
# define R200_TXC_ARG_A_R0_COLOR		(10)
# define R200_TXC_ARG_A_R0_ALPHA		(11)
# define R200_TXC_ARG_A_R1_COLOR		(12)
# define R200_TXC_ARG_A_R1_ALPHA		(13)
# define R200_TXC_ARG_A_R2_COLOR		(14)
# define R200_TXC_ARG_A_R2_ALPHA		(15)
# define R200_TXC_ARG_A_R3_COLOR		(16)
# define R200_TXC_ARG_A_R3_ALPHA		(17)
# define R200_TXC_ARG_A_R4_COLOR		(18)
# define R200_TXC_ARG_A_R4_ALPHA		(19)
# define R200_TXC_ARG_A_R5_COLOR		(20)
# define R200_TXC_ARG_A_R5_ALPHA		(21)
# define R200_TXC_ARG_A_TFACTOR1_COLOR		(26)
# define R200_TXC_ARG_A_TFACTOR1_ALPHA		(27)
# define R200_TXC_ARG_A_MASK			(31 << 0)
# define R200_TXC_ARG_A_SHIFT			0
# define R200_TXC_ARG_B_ZERO			(0 << 5)
# define R200_TXC_ARG_B_CURRENT_COLOR		(2 << 5)
# define R200_TXC_ARG_B_CURRENT_ALPHA		(3 << 5)
# define R200_TXC_ARG_B_DIFFUSE_COLOR		(4 << 5)
# define R200_TXC_ARG_B_DIFFUSE_ALPHA		(5 << 5)
# define R200_TXC_ARG_B_SPECULAR_COLOR		(6 << 5)
# define R200_TXC_ARG_B_SPECULAR_ALPHA		(7 << 5)
# define R200_TXC_ARG_B_TFACTOR_COLOR		(8 << 5)
# define R200_TXC_ARG_B_TFACTOR_ALPHA		(9 << 5)
# define R200_TXC_ARG_B_R0_COLOR		(10 << 5)
# define R200_TXC_ARG_B_R0_ALPHA		(11 << 5)
# define R200_TXC_ARG_B_R1_COLOR		(12 << 5)
# define R200_TXC_ARG_B_R1_ALPHA		(13 << 5)
# define R200_TXC_ARG_B_R2_COLOR		(14 << 5)
# define R200_TXC_ARG_B_R2_ALPHA		(15 << 5)
# define R200_TXC_ARG_B_R3_COLOR		(16 << 5)
# define R200_TXC_ARG_B_R3_ALPHA		(17 << 5)
# define R200_TXC_ARG_B_R4_COLOR		(18 << 5)
# define R200_TXC_ARG_B_R4_ALPHA		(19 << 5)
# define R200_TXC_ARG_B_R5_COLOR		(20 << 5)
# define R200_TXC_ARG_B_R5_ALPHA		(21 << 5)
# define R200_TXC_ARG_B_TFACTOR1_COLOR		(26 << 5)
# define R200_TXC_ARG_B_TFACTOR1_ALPHA		(27 << 5)
# define R200_TXC_ARG_B_MASK			(31 << 5)
# define R200_TXC_ARG_B_SHIFT			5
# define R200_TXC_ARG_C_ZERO			(0 << 10)
# define R200_TXC_ARG_C_CURRENT_COLOR		(2 << 10)
# define R200_TXC_ARG_C_CURRENT_ALPHA		(3 << 10)
# define R200_TXC_ARG_C_DIFFUSE_COLOR		(4 << 10)
# define R200_TXC_ARG_C_DIFFUSE_ALPHA		(5 << 10)
# define R200_TXC_ARG_C_SPECULAR_COLOR		(6 << 10)
# define R200_TXC_ARG_C_SPECULAR_ALPHA		(7 << 10)
# define R200_TXC_ARG_C_TFACTOR_COLOR		(8 << 10)
# define R200_TXC_ARG_C_TFACTOR_ALPHA		(9 << 10)
# define R200_TXC_ARG_C_R0_COLOR		(10 << 10)
# define R200_TXC_ARG_C_R0_ALPHA		(11 << 10)
# define R200_TXC_ARG_C_R1_COLOR		(12 << 10)
# define R200_TXC_ARG_C_R1_ALPHA		(13 << 10)
# define R200_TXC_ARG_C_R2_COLOR		(14 << 10)
# define R200_TXC_ARG_C_R2_ALPHA		(15 << 10)
# define R200_TXC_ARG_C_R3_COLOR		(16 << 10)
# define R200_TXC_ARG_C_R3_ALPHA		(17 << 10)
# define R200_TXC_ARG_C_R4_COLOR		(18 << 10)
# define R200_TXC_ARG_C_R4_ALPHA		(19 << 10)
# define R200_TXC_ARG_C_R5_COLOR		(20 << 10)
# define R200_TXC_ARG_C_R5_ALPHA		(21 << 10)
# define R200_TXC_ARG_C_TFACTOR1_COLOR		(26 << 10)
# define R200_TXC_ARG_C_TFACTOR1_ALPHA		(27 << 10)
# define R200_TXC_ARG_C_MASK			(31 << 10)
# define R200_TXC_ARG_C_SHIFT			10
# define R200_TXC_COMP_ARG_A			(1 << 16)
# define R200_TXC_COMP_ARG_A_SHIFT		(16)
# define R200_TXC_BIAS_ARG_A			(1 << 17)
# define R200_TXC_SCALE_ARG_A			(1 << 18)
# define R200_TXC_NEG_ARG_A			(1 << 19)
# define R200_TXC_COMP_ARG_B			(1 << 20)
# define R200_TXC_COMP_ARG_B_SHIFT		(20)
# define R200_TXC_BIAS_ARG_B			(1 << 21)
# define R200_TXC_SCALE_ARG_B			(1 << 22)
# define R200_TXC_NEG_ARG_B			(1 << 23)
# define R200_TXC_COMP_ARG_C			(1 << 24)
# define R200_TXC_COMP_ARG_C_SHIFT		(24)
# define R200_TXC_BIAS_ARG_C			(1 << 25)
# define R200_TXC_SCALE_ARG_C			(1 << 26)
# define R200_TXC_NEG_ARG_C			(1 << 27)
# define R200_TXC_OP_MADD			(0 << 28)
# define R200_TXC_OP_CND0			(2 << 28)
# define R200_TXC_OP_LERP			(3 << 28)
# define R200_TXC_OP_DOT3			(4 << 28)
# define R200_TXC_OP_DOT4			(5 << 28)
# define R200_TXC_OP_CONDITIONAL		(6 << 28)
# define R200_TXC_OP_DOT2_ADD			(7 << 28)
# define R200_TXC_OP_MASK			(7 << 28)

/* AKA PIXSHADER_I0_C1 */
#define R200_REG_PP_TXCBLEND2_0			0x2f04
# define R200_TXC_TFACTOR_SEL_SHIFT		0
# define R200_TXC_TFACTOR_SEL_MASK		0x7
# define R200_TXC_TFACTOR1_SEL_SHIFT		4
# define R200_TXC_TFACTOR1_SEL_MASK		(0x7 << 4)
# define R200_TXC_SCALE_SHIFT			8
# define R200_TXC_SCALE_MASK			(7 << 8)
# define R200_TXC_SCALE_1X			(0 << 8)
# define R200_TXC_SCALE_2X			(1 << 8)
# define R200_TXC_SCALE_4X			(2 << 8)
# define R200_TXC_SCALE_8X			(3 << 8)
# define R200_TXC_SCALE_INV2			(5 << 8)
# define R200_TXC_SCALE_INV4			(6 << 8)
# define R200_TXC_SCALE_INV8			(7 << 8)
# define R200_TXC_CLAMP_SHIFT			12
# define R200_TXC_CLAMP_MASK			(3 << 12)
# define R200_TXC_CLAMP_WRAP			(0 << 12)
# define R200_TXC_CLAMP_0_1			(1 << 12)
# define R200_TXC_CLAMP_8_8			(2 << 12)
# define R200_TXC_OUTPUT_REG_MASK		(7 << 16)
# define R200_TXC_OUTPUT_REG_NONE		(0 << 16)
# define R200_TXC_OUTPUT_REG_R0			(1 << 16)
# define R200_TXC_OUTPUT_REG_R1			(2 << 16)
# define R200_TXC_OUTPUT_REG_R2			(3 << 16)
# define R200_TXC_OUTPUT_REG_R3			(4 << 16)
# define R200_TXC_OUTPUT_REG_R4			(5 << 16)
# define R200_TXC_OUTPUT_REG_R5			(6 << 16)
# define R200_TXC_OUTPUT_MASK_MASK		(7 << 20)
# define R200_TXC_OUTPUT_MASK_RGB		(0 << 20)
# define R200_TXC_OUTPUT_MASK_RG		(1 << 20)
# define R200_TXC_OUTPUT_MASK_RB		(2 << 20)
# define R200_TXC_OUTPUT_MASK_R			(3 << 20)
# define R200_TXC_OUTPUT_MASK_GB		(4 << 20)
# define R200_TXC_OUTPUT_MASK_G			(5 << 20)
# define R200_TXC_OUTPUT_MASK_B			(6 << 20)
# define R200_TXC_OUTPUT_MASK_NONE		(7 << 20)
# define R200_TXC_REPL_NORMAL			0
# define R200_TXC_REPL_RED			1
# define R200_TXC_REPL_GREEN			2
# define R200_TXC_REPL_BLUE			3
# define R200_TXC_REPL_ARG_A_SHIFT		26
# define R200_TXC_REPL_ARG_A_MASK		(3 << 26)
# define R200_TXC_REPL_ARG_B_SHIFT		28
# define R200_TXC_REPL_ARG_B_MASK		(3 << 28)
# define R200_TXC_REPL_ARG_C_SHIFT		30
# define R200_TXC_REPL_ARG_C_MASK		(3 << 30)

/* AKA PIXSHADER_I0_A0 */
#define R200_REG_PP_TXABLEND_0			0x2f08
# define R200_TXA_ARG_A_ZERO			(0)
# define R200_TXA_ARG_A_CURRENT_ALPHA		(2) /* guess */
# define R200_TXA_ARG_A_CURRENT_BLUE		(3) /* guess */
# define R200_TXA_ARG_A_DIFFUSE_ALPHA		(4)
# define R200_TXA_ARG_A_DIFFUSE_BLUE		(5)
# define R200_TXA_ARG_A_SPECULAR_ALPHA		(6)
# define R200_TXA_ARG_A_SPECULAR_BLUE		(7)
# define R200_TXA_ARG_A_TFACTOR_ALPHA		(8)
# define R200_TXA_ARG_A_TFACTOR_BLUE		(9)
# define R200_TXA_ARG_A_R0_ALPHA		(10)
# define R200_TXA_ARG_A_R0_BLUE			(11)
# define R200_TXA_ARG_A_R1_ALPHA		(12)
# define R200_TXA_ARG_A_R1_BLUE			(13)
# define R200_TXA_ARG_A_R2_ALPHA		(14)
# define R200_TXA_ARG_A_R2_BLUE			(15)
# define R200_TXA_ARG_A_R3_ALPHA		(16)
# define R200_TXA_ARG_A_R3_BLUE			(17)
# define R200_TXA_ARG_A_R4_ALPHA		(18)
# define R200_TXA_ARG_A_R4_BLUE			(19)
# define R200_TXA_ARG_A_R5_ALPHA		(20)
# define R200_TXA_ARG_A_R5_BLUE			(21)
# define R200_TXA_ARG_A_TFACTOR1_ALPHA		(26)
# define R200_TXA_ARG_A_TFACTOR1_BLUE		(27)
# define R200_TXA_ARG_A_MASK			(31 << 0)
# define R200_TXA_ARG_A_SHIFT			0
# define R200_TXA_ARG_B_ZERO			(0 << 5)
# define R200_TXA_ARG_B_CURRENT_ALPHA		(2 << 5) /* guess */
# define R200_TXA_ARG_B_CURRENT_BLUE		(3 << 5) /* guess */
# define R200_TXA_ARG_B_DIFFUSE_ALPHA		(4 << 5)
# define R200_TXA_ARG_B_DIFFUSE_BLUE		(5 << 5)
# define R200_TXA_ARG_B_SPECULAR_ALPHA		(6 << 5)
# define R200_TXA_ARG_B_SPECULAR_BLUE		(7 << 5)
# define R200_TXA_ARG_B_TFACTOR_ALPHA		(8 << 5)
# define R200_TXA_ARG_B_TFACTOR_BLUE		(9 << 5)
# define R200_TXA_ARG_B_R0_ALPHA		(10 << 5)
# define R200_TXA_ARG_B_R0_BLUE			(11 << 5)
# define R200_TXA_ARG_B_R1_ALPHA		(12 << 5)
# define R200_TXA_ARG_B_R1_BLUE			(13 << 5)
# define R200_TXA_ARG_B_R2_ALPHA		(14 << 5)
# define R200_TXA_ARG_B_R2_BLUE			(15 << 5)
# define R200_TXA_ARG_B_R3_ALPHA		(16 << 5)
# define R200_TXA_ARG_B_R3_BLUE			(17 << 5)
# define R200_TXA_ARG_B_R4_ALPHA		(18 << 5)
# define R200_TXA_ARG_B_R4_BLUE			(19 << 5)
# define R200_TXA_ARG_B_R5_ALPHA		(20 << 5)
# define R200_TXA_ARG_B_R5_BLUE			(21 << 5)
# define R200_TXA_ARG_B_TFACTOR1_ALPHA		(26 << 5)
# define R200_TXA_ARG_B_TFACTOR1_BLUE		(27 << 5)
# define R200_TXA_ARG_B_MASK			(31 << 5)
# define R200_TXA_ARG_B_SHIFT			5
# define R200_TXA_ARG_C_ZERO			(0 << 10)
# define R200_TXA_ARG_C_CURRENT_ALPHA		(2 << 10) /* guess */
# define R200_TXA_ARG_C_CURRENT_BLUE		(3 << 10) /* guess */
# define R200_TXA_ARG_C_DIFFUSE_ALPHA		(4 << 10)
# define R200_TXA_ARG_C_DIFFUSE_BLUE		(5 << 10)
# define R200_TXA_ARG_C_SPECULAR_ALPHA		(6 << 10)
# define R200_TXA_ARG_C_SPECULAR_BLUE		(7 << 10)
# define R200_TXA_ARG_C_TFACTOR_ALPHA		(8 << 10)
# define R200_TXA_ARG_C_TFACTOR_BLUE		(9 << 10)
# define R200_TXA_ARG_C_R0_ALPHA		(10 << 10)
# define R200_TXA_ARG_C_R0_BLUE			(11 << 10)
# define R200_TXA_ARG_C_R1_ALPHA		(12 << 10)
# define R200_TXA_ARG_C_R1_BLUE			(13 << 10)
# define R200_TXA_ARG_C_R2_ALPHA		(14 << 10)
# define R200_TXA_ARG_C_R2_BLUE			(15 << 10)
# define R200_TXA_ARG_C_R3_ALPHA		(16 << 10)
# define R200_TXA_ARG_C_R3_BLUE			(17 << 10)
# define R200_TXA_ARG_C_R4_ALPHA		(18 << 10)
# define R200_TXA_ARG_C_R4_BLUE			(19 << 10)
# define R200_TXA_ARG_C_R5_ALPHA		(20 << 10)
# define R200_TXA_ARG_C_R5_BLUE			(21 << 10)
# define R200_TXA_ARG_C_TFACTOR1_ALPHA		(26 << 10)
# define R200_TXA_ARG_C_TFACTOR1_BLUE		(27 << 10)
# define R200_TXA_ARG_C_MASK			(31 << 10)
# define R200_TXA_ARG_C_SHIFT			10
# define R200_TXA_COMP_ARG_A			(1 << 16)
# define R200_TXA_COMP_ARG_A_SHIFT		(16)
# define R200_TXA_BIAS_ARG_A			(1 << 17)
# define R200_TXA_SCALE_ARG_A			(1 << 18)
# define R200_TXA_NEG_ARG_A			(1 << 19)
# define R200_TXA_COMP_ARG_B			(1 << 20)
# define R200_TXA_COMP_ARG_B_SHIFT		(20)
# define R200_TXA_BIAS_ARG_B			(1 << 21)
# define R200_TXA_SCALE_ARG_B			(1 << 22)
# define R200_TXA_NEG_ARG_B			(1 << 23)
# define R200_TXA_COMP_ARG_C			(1 << 24)
# define R200_TXA_COMP_ARG_C_SHIFT		(24)
# define R200_TXA_BIAS_ARG_C			(1 << 25)
# define R200_TXA_SCALE_ARG_C			(1 << 26)
# define R200_TXA_NEG_ARG_C			(1 << 27)
# define R200_TXA_OP_MADD			(0 << 28)
# define R200_TXA_OP_CND0			(2 << 28)
# define R200_TXA_OP_LERP			(3 << 28)
# define R200_TXA_OP_CONDITIONAL		(6 << 28)
# define R200_TXA_OP_MASK			(7 << 28)

/* AKA PIXSHADER_I0_A1 */
#define R200_REG_PP_TXABLEND2_0			0x2f0c
# define R200_TXA_TFACTOR_SEL_SHIFT		0
# define R200_TXA_TFACTOR_SEL_MASK		0x7
# define R200_TXA_TFACTOR1_SEL_SHIFT		4
# define R200_TXA_TFACTOR1_SEL_MASK		(0x7 << 4)
# define R200_TXA_SCALE_SHIFT			8
# define R200_TXA_SCALE_MASK			(7 << 8)
# define R200_TXA_SCALE_1X			(0 << 8)
# define R200_TXA_SCALE_2X			(1 << 8)
# define R200_TXA_SCALE_4X			(2 << 8)
# define R200_TXA_SCALE_8X			(3 << 8)
# define R200_TXA_SCALE_INV2			(5 << 8)
# define R200_TXA_SCALE_INV4			(6 << 8)
# define R200_TXA_SCALE_INV8			(7 << 8)
# define R200_TXA_CLAMP_SHIFT			12
# define R200_TXA_CLAMP_MASK			(3 << 12)
# define R200_TXA_CLAMP_WRAP			(0 << 12)
# define R200_TXA_CLAMP_0_1			(1 << 12)
# define R200_TXA_CLAMP_8_8			(2 << 12)
# define R200_TXA_OUTPUT_REG_MASK		(7 << 16)
# define R200_TXA_OUTPUT_REG_NONE		(0 << 16)
# define R200_TXA_OUTPUT_REG_R0			(1 << 16)
# define R200_TXA_OUTPUT_REG_R1			(2 << 16)
# define R200_TXA_OUTPUT_REG_R2			(3 << 16)
# define R200_TXA_OUTPUT_REG_R3			(4 << 16)
# define R200_TXA_OUTPUT_REG_R4			(5 << 16)
# define R200_TXA_OUTPUT_REG_R5			(6 << 16)
# define R200_TXA_DOT_ALPHA			(1 << 20)
# define R200_TXA_REPL_NORMAL			0
# define R200_TXA_REPL_RED			1
# define R200_TXA_REPL_GREEN			2
# define R200_TXA_REPL_ARG_A_SHIFT		26
# define R200_TXA_REPL_ARG_A_MASK		(3 << 26)
# define R200_TXA_REPL_ARG_B_SHIFT		28
# define R200_TXA_REPL_ARG_B_MASK		(3 << 28)
# define R200_TXA_REPL_ARG_C_SHIFT		30
# define R200_TXA_REPL_ARG_C_MASK		(3 << 30)

#define RADEON_REG_RB2D_DSTCACHE_MODE		0x3428
/* This is a read-only mirror of RADEON_REG_RB3D_DSTCACHE_MODE */

#define RADEON_REG_RB2D_DSTCACHE_CTLSTAT	0x342C
/* This is a read-only mirror of RADEON_REG_RB3D_DSTCACHE_CTLSTAT */

#define RADEON_REG_RB3D_DSTCACHE_MODE		0x3258
# define RADEON_RB3D_DC_CACHE_ENABLE		(0)
# define RADEON_RB3D_DC_2D_CACHE_DISABLE	(1)
# define RADEON_RB3D_DC_3D_CACHE_DISABLE	(2)
# define RADEON_RB3D_DC_CACHE_DISABLE		(3)
# define RADEON_RB3D_DC_2D_CACHE_LINESIZE_128	(1 << 2)
# define RADEON_RB3D_DC_3D_CACHE_LINESIZE_128	(2 << 2)
# define RADEON_RB3D_DC_2D_CACHE_AUTOFLUSH	(1 << 8)
# define RADEON_RB3D_DC_3D_CACHE_AUTOFLUSH	(2 << 8)
# define R200_RB3D_DC_2D_CACHE_AUTOFREE		(1 << 10)
# define R200_RB3D_DC_3D_CACHE_AUTOFREE		(2 << 10)
# define RADEON_RB3D_DC_FORCE_RMW		(1 << 16)
# define RADEON_RB3D_DC_DISABLE_RI_FILL		(1 << 24)
# define RADEON_RB3D_DC_DISABLE_RI_READ		(1 << 25)
# define RADEON_RB3D_DC_DISABLE_MASK_CHK	(1 << 26)

#define RADEON_REG_RB3D_DSTCACHE_CTLSTAT	0x325C
# define RADEON_RB3D_DC_FLUSH			(3 << 0)
# define RADEON_RB3D_DC_FREE			(3 << 2)
# define RADEON_RB3D_DC_FLUSH_ALL		0xf
# define RADEON_RB3D_DC_BUSY			(1 << 31)

/* PLL register defines */
#define R128_REG_MCLK_CNTL			0x000f
# define R128_FORCE_GCP				(1 << 16)
# define R128_FORCE_PIPE3D_CP			(1 << 17)
# define R128_FORCE_RCP				(1 << 18)
#define RADEON_REG_MCLK_CNTL			0x0012
# define RADEON_FORCEON_MCLKA			(1 << 16)
# define RADEON_FORCEON_MCLKB			(1 << 17)
# define RADEON_FORCEON_YCLKA			(1 << 18)
# define RADEON_FORCEON_YCLKB			(1 << 19)
# define RADEON_FORCEON_MC			(1 << 20)
# define RADEON_FORCEON_AIC			(1 << 21)

/* CCE packet defines */

#define ATI_CCE_PACKETTYPE_MASK			0xc0000000
#define ATI_CCE_PACKET0				0x00000000
#define ATI_CCE_PACKET0_COUNT_MASK		0x3fff0000
#define ATI_CCE_PACKET0_ONE_REG_WR		0x00008000
#define ATI_CCE_PACKET0_REG_MASK		0x000007ff
#define ATI_CCE_PACKET1				0x40000000
#define ATI_CCE_PACKET1_REG_1			0x000007ff
#define ATI_CCE_PACKET1_REG_2			0x003ff800
#define ATI_CCE_PACKET1_REG_2_SHIFT		10
#define ATI_CCE_PACKET2				0x80000000
#define ATI_CCE_PACKET3				0xc0000000
#define ATI_CCE_PACKET3_COUNT_MASK		0x3fff0000
#define ATI_CCE_PACKET3_IT_OPCODE_MASK		0x0000ff00
#define ATI_CCE_PACKET3_NOP			0xc0001000
#define ATI_CCE_PACKET3_NEXT_CHAR		0xc0001900
#define ATI_CCE_PACKET3_PLY_NEXTSCAN		0xc0001d00
#define ATI_CCE_PACKET3_SET_SCISSORS		0xc0001e00
#define R128_CCE_PACKET3_SET_MODE_24BPP		0xc0001f00
#define R128_CCE_PACKET3_3D_SAVE_CONTEXT	0xc0002000
#define R128_CCE_PACKET3_3D_PLAY_CONTEXT	0xc0002100
#define ATI_CCE_PACKET3_3D_RNDR_GEN_INDX_PRIM	0xc0002300
#define RADEON_CP_PACKET3_LOAD_MICROCODE	0xc0002400
#define ATI_CCE_PACKET3_3D_RNDR_GEN_PRIM	0xc0002500
#define RADEON_CP_PACKET3_WAIT_FOR_IDLE		0xc0002600
#define RADEON_CP_PACKET3_3D_DRAW_VBUF		0xc0002800
#define RADEON_CP_PACKET3_3D_DRAW_IMMD		0xc0002900
#define RADEON_CP_PACKET3_3D_DRAW_INDX		0xc0002a00
#define ATI_CCE_PACKET3_LOAD_PALETTE		0xc0002c00
#define R128_CCE_PACKET3_PURGE			0xc0002d00
#define R128_CCE_PACKET3_NEXT_VERTEX_BUNDLE	0xc0002e00
#define RADEON_CP_PACKET3_3D_LOAD_VBPNTR	0xc0002f00
#define RADEON_CP_PACKET3_3D_CLEAR_ZMASK	0xc0003200
#define R200_CP_PACKET3_3D_DRAW_IMMD_2		0xc0003500
#define ATI_CCE_PACKET3_CNTL_PAINT		0xc0009100
#define ATI_CCE_PACKET3_CNTL_BITBLT		0xc0009200
#define ATI_CCE_PACKET3_CNTL_SMALLTEXT		0xc0009300
#define ATI_CCE_PACKET3_HOSTDATA_BLT		0xc0009400
#define ATI_CCE_PACKET3_CNTL_POLYLINE		0xc0009500
#define R128_CCE_PACKET3_SCALE			0xc0009600
#define R128_CCE_PACKET3_TRANS_SCALE		0xc0009700
#define ATI_CCE_PACKET3_CNTL_POLYSCANLINES	0xc0009800
#define ATI_CCE_PACKET3_PAINT_MULTI		0xc0009a00
#define ATI_CCE_PACKET3_BITBLT_MULTI		0xc0009b00
#define ATI_CCE_PACKET3_CNTL_TRANS_BITBLT	0xc0009c00

#define RADEON_CP_VC_FRMT_XY			0x00000000
#define RADEON_CP_VC_FRMT_W0			0x00000001
#define RADEON_CP_VC_FRMT_FPCOLOR		0x00000002
#define RADEON_CP_VC_FRMT_FPALPHA		0x00000004
#define RADEON_CP_VC_FRMT_PKCOLOR		0x00000008
#define RADEON_CP_VC_FRMT_FPSPEC		0x00000010
#define RADEON_CP_VC_FRMT_FPFOG			0x00000020
#define RADEON_CP_VC_FRMT_PKSPEC		0x00000040
#define RADEON_CP_VC_FRMT_ST0			0x00000080
#define RADEON_CP_VC_FRMT_ST1			0x00000100
#define RADEON_CP_VC_FRMT_Q1			0x00000200
#define RADEON_CP_VC_FRMT_ST2			0x00000400
#define RADEON_CP_VC_FRMT_Q2			0x00000800
#define RADEON_CP_VC_FRMT_ST3			0x00001000
#define RADEON_CP_VC_FRMT_Q3			0x00002000
#define RADEON_CP_VC_FRMT_Q0			0x00004000
#define RADEON_CP_VC_FRMT_BLND_WEIGHT_CNT_MASK	0x00038000
#define RADEON_CP_VC_FRMT_N0			0x00040000
#define RADEON_CP_VC_FRMT_XY1			0x08000000
#define RADEON_CP_VC_FRMT_Z1			0x10000000
#define RADEON_CP_VC_FRMT_W1			0x20000000
#define RADEON_CP_VC_FRMT_N1			0x40000000
#define RADEON_CP_VC_FRMT_Z			0x80000000

#define RADEON_CP_VC_CNTL_PRIM_TYPE_NONE	0x00000000
#define RADEON_CP_VC_CNTL_PRIM_TYPE_POINT	0x00000001
#define RADEON_CP_VC_CNTL_PRIM_TYPE_LINE	0x00000002
#define RADEON_CP_VC_CNTL_PRIM_TYPE_LINE_STRIP	0x00000003
#define RADEON_CP_VC_CNTL_PRIM_TYPE_TRI_LIST	0x00000004
#define RADEON_CP_VC_CNTL_PRIM_TYPE_TRI_FAN	0x00000005
#define RADEON_CP_VC_CNTL_PRIM_TYPE_TRI_STRIP	0x00000006
#define RADEON_CP_VC_CNTL_PRIM_TYPE_TRI_TYPE_2	0x00000007
#define RADEON_CP_VC_CNTL_PRIM_TYPE_RECT_LIST	0x00000008
#define RADEON_CP_VC_CNTL_PRIM_TYPE_3VRT_POINT_LIST 0x00000009
#define RADEON_CP_VC_CNTL_PRIM_TYPE_3VRT_LINE_LIST 0x0000000a
#define RADEON_CP_VC_CNTL_PRIM_WALK_IND		0x00000010
#define RADEON_CP_VC_CNTL_PRIM_WALK_LIST	0x00000020
#define RADEON_CP_VC_CNTL_PRIM_WALK_RING	0x00000030
#define RADEON_CP_VC_CNTL_COLOR_ORDER_BGRA	0x00000000
#define RADEON_CP_VC_CNTL_COLOR_ORDER_RGBA	0x00000040
#define RADEON_CP_VC_CNTL_MAOS_ENABLE		0x00000080
#define RADEON_CP_VC_CNTL_VTX_FMT_NON_RADEON_MODE 0x00000000
#define RADEON_CP_VC_CNTL_VTX_FMT_RADEON_MODE	0x00000100
#define RADEON_CP_VC_CNTL_TCL_DISABLE		0x00000000
#define RADEON_CP_VC_CNTL_TCL_ENABLE		0x00000200
#define RADEON_CP_VC_CNTL_NUM_SHIFT		16

#define R128_CCE_VC_FRMT_RHW			0x00000001
#define R128_CCE_VC_FRMT_DIFFUSE_BGR		0x00000002
#define R128_CCE_VC_FRMT_DIFFUSE_A		0x00000004
#define R128_CCE_VC_FRMT_DIFFUSE_ARGB		0x00000008
#define R128_CCE_VC_FRMT_SPEC_BGR		0x00000010
#define R128_CCE_VC_FRMT_SPEC_F			0x00000020
#define R128_CCE_VC_FRMT_SPEC_FRGB		0x00000040
#define R128_CCE_VC_FRMT_S_T			0x00000080
#define R128_CCE_VC_FRMT_S2_T2			0x00000100
#define R128_CCE_VC_FRMT_RHW2			0x00000200

#define R128_CCE_VC_CNTL_PRIM_TYPE_NONE		0x00000000
#define R128_CCE_VC_CNTL_PRIM_TYPE_POINT	0x00000001
#define R128_CCE_VC_CNTL_PRIM_TYPE_LINE		0x00000002
#define R128_CCE_VC_CNTL_PRIM_TYPE_POLY_LINE	0x00000003
#define R128_CCE_VC_CNTL_PRIM_TYPE_TRI_LIST	0x00000004
#define R128_CCE_VC_CNTL_PRIM_TYPE_TRI_FAN	0x00000005
#define R128_CCE_VC_CNTL_PRIM_TYPE_TRI_STRIP	0x00000006
#define R128_CCE_VC_CNTL_PRIM_TYPE_TRI_TYPE2	0x00000007
#define R128_CCE_VC_CNTL_PRIM_WALK_IND		0x00000010
#define R128_CCE_VC_CNTL_PRIM_WALK_LIST		0x00000020
#define R128_CCE_VC_CNTL_PRIM_WALK_RING		0x00000030
#define R128_CCE_VC_CNTL_NUM_SHIFT		16

#define R128_DATATYPE_VQ			0
#define R128_DATATYPE_CI4			1
#define R128_DATATYPE_CI8			2
#define R128_DATATYPE_ARGB1555			3
#define R128_DATATYPE_RGB565			4
#define R128_DATATYPE_RGB888			5
#define R128_DATATYPE_ARGB8888			6
#define R128_DATATYPE_RGB332			7
#define R128_DATATYPE_Y8			8
#define R128_DATATYPE_RGB8			9
#define R128_DATATYPE_CI16			10
#define R128_DATATYPE_VYUY_422			11
#define R128_DATATYPE_YVYU_422			12
#define R128_DATATYPE_AYUV_444			14
#define R128_DATATYPE_ARGB4444			15

#define R128_AGP_OFFSET				0x02000000

#define R128_WATERMARK_L			16
#define R128_WATERMARK_M			8
#define R128_WATERMARK_N			8
#define R128_WATERMARK_K			128
