/*
 * Copyright (c) 2003 Nokia
 * Author: tsavola@movial.fi
 *
 * This program is licensed under GPL (see COPYING for details)
 */

#ifndef CONFIG_H
#define CONFIG_H

#include "types.h"

/** Holds the info parsed from the client's config file. */
typedef struct {
	char *user;
	char *host;
	uint16_t port;
	char *pwd;
	char **opts;
} config_t;

extern void init_config(config_t *cfg);
extern void free_config(config_t *cfg);
extern bool_t read_config(const char *file, const char *target, config_t *cfg);
extern char **get_targets(const char *filename);

#endif
